/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IDeltaTranslatingIndex;
import com.teamscale.core.analysis.IIndexDelta;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.RepositoryNeedsRollbackException;
import com.teamscale.core.analysis.configuration.TriggerDescription;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.analysis.trigger.AnalysisStepContext;
import com.teamscale.core.analysis.trigger.IAnalysisStep;
import com.teamscale.core.analysis.trigger.IPostTriggerAction;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.index.CommitResolver;
import com.teamscale.core.index.CriticalSystemStateIndex;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.runtime.api.rollback.RollbackRequest;
import com.teamscale.core.runtime.impl.analysis.ISchedulingCommit;
import com.teamscale.core.runtime.impl.analysis.RateLimitableResource;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepBranchingLayerAccess;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepDeltaSource;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepGlobalIndexAccess;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepIndexAccessBase;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepParameter;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepPostInjectionMethod;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepProjectIndexAccess;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.ETriggerType;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.scheduling.TriggerCache;
import com.teamscale.core.runtime.impl.worker.ICrossProjectLockSupport;
import com.teamscale.core.runtime.impl.worker.ITriggerExecutionResultState;
import com.teamscale.core.runtime.impl.worker.NonLockingLockSupport;
import com.teamscale.core.runtime.impl.worker.RecordingStore;
import com.teamscale.core.runtime.impl.worker.TriggerExecutionResult;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.RateLimitedAccessException;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.core.logging.TeamscaleLogAppender;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.IStoreDecorator;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StoreWithAbbreviationSupport;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.util.IStorageAbbreviator;
import org.conqat.engine.persistence.store.util.ReadOnlyStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.lang.SilentAutoClosable;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class AnalysisTriggerExecutorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<EIndexAccessMode> ORDERED_ACCESS_MODES = List.of(EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY, EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, EIndexAccessMode.READ_WRITE, EIndexAccessMode.READ_ONLY);
    public static final String REPOSITORY_NEEDS_RESCHEDULE_EXCEPTION_NAME = "RepositoryNeedsRescheduleException";
    private final String triggerName;
    private final InternalProjectId projectId;
    private final TriggerDescription triggerDescription;
    private final IParallelTaskExecutor parallelTaskExecutor;
    private final ILockProvider lockProvider;
    private AnalysisTrigger trigger;
    private final @Nullable ParentedCommitDescriptor schedulingCommit;
    private final PairList<String, RecordingStore> recordingStores = new PairList();
    private final Map<String, IStorageIndex> openIndexes = new HashMap<String, IStorageIndex>();
    private final Map<String, List<IStorageIndex>> openedPreviousIndexes = new HashMap<String, List<IStorageIndex>>();
    private final Map<String, IIndexDelta> inputDeltas = new HashMap<String, IIndexDelta>();
    private IProfilingMonitor profilingMonitor;
    private final CommitResolver commitResolver = new CommitResolver();
    private final Set<String> requiredDeltas = new HashSet<String>();
    private final SequencedSet<IPostTriggerAction> postTriggerActions = new LinkedHashSet<IPostTriggerAction>();
    private boolean testMode = false;

    protected AnalysisTriggerExecutorBase(String triggerName, InternalProjectId projectId, @Nullable ParentedCommitDescriptor schedulingCommit, TriggerDescription triggerDescription, IParallelTaskExecutor parallelTaskExecutor, ILockProvider lockProvider) {
        this.triggerName = triggerName;
        this.projectId = projectId;
        this.schedulingCommit = schedulingCommit;
        this.triggerDescription = triggerDescription;
        this.parallelTaskExecutor = parallelTaskExecutor;
        this.lockProvider = lockProvider;
    }

    protected void addExpectedDeltas(Collection<String> storeNames) {
        this.requiredDeltas.addAll(storeNames);
    }

    @TestOnly
    public TriggerExecutionResult executeInTestMode(TriggerCache triggerCache, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem) throws StorageException, TriggerCompilationException {
        this.testMode = true;
        return this.execute(triggerCache, projectStorageSystem, globalStorageSystem, new NonLockingLockSupport(), ignored -> SilentAutoClosable.empty());
    }

    public TriggerExecutionResult execute(TriggerCache triggerCache, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, ICrossProjectLockSupport lockSupport, Function<IAnalysisStep, SilentAutoClosable> stepExecutionWrapper) throws StorageException, TriggerCompilationException {
        this.trigger = (AnalysisTrigger)triggerCache.getTrigger(this.triggerName, ETriggerType.BLOCK, this.projectId);
        if (this.requiredDeltas.isEmpty() && this.testMode) {
            this.requiredDeltas.addAll((Collection<String>)this.trigger.getWriteStores());
        }
        AnalysisStepBase instance = this.createAnalysisStepInstanceForCurrentTrigger(globalStorageSystem);
        this.injectAnalysisStepParameters(projectStorageSystem, globalStorageSystem, lockSupport, instance);
        this.invokePostInjectionMethods(instance);
        TeamscaleLogAppender.init();
        try {
            TriggerExecutionResult triggerExecutionResult;
            block10: {
                SilentAutoClosable ignoredCleanup = stepExecutionWrapper.apply(instance);
                try {
                    lockSupport.lock();
                    CriticalSystemStateIndex criticalSystemStateIndex = (CriticalSystemStateIndex)globalStorageSystem.openGlobalIndex(CriticalSystemStateIndex.class);
                    ITriggerExecutionResultState executionResultState = AnalysisTriggerExecutorBase.executeAndHandleExceptions(instance, criticalSystemStateIndex, this.postTriggerActions, this.trigger.getRemoteResource());
                    triggerExecutionResult = new TriggerExecutionResult(executionResultState, (List<LogEvent>)TeamscaleLogAppender.getLogEvents(), this.inputDeltas, this.getOutputDeltas(), this.getWrittenVirtualStoreNameToId());
                    if (ignoredCleanup == null) break block10;
                }
                catch (Throwable throwable) {
                    if (ignoredCleanup != null) {
                        try {
                            ignoredCleanup.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignoredCleanup.close();
            }
            return triggerExecutionResult;
        }
        finally {
            lockSupport.unlock();
        }
    }

    private @NonNull AnalysisStepBase createAnalysisStepInstanceForCurrentTrigger(GlobalStorageSystem globalStorageSystem) throws TriggerCompilationException, StorageException {
        Class<? extends AnalysisStepBase> stepClass = this.trigger.getAnalysisStepClass();
        PublicProjectId publicId = AnalysisTriggerExecutorBase.lookupPublicId(this.projectId, globalStorageSystem);
        return this.createAnalysisStepInstanceForCurrentTrigger(stepClass.asSubclass(AnalysisStepBase.class), publicId);
    }

    private static @Nullable PublicProjectId lookupPublicId(InternalProjectId projectId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        if (projectId == null) {
            return null;
        }
        return ((ProjectIndex)globalStorageSystem.openGlobalIndex(ProjectIndex.class)).resolveProject((IProjectId)projectId).getPrimaryPublicId();
    }

    private AnalysisStepBase createAnalysisStepInstanceForCurrentTrigger(Class<? extends AnalysisStepBase> blockClass, PublicProjectId publicProjectId) throws TriggerCompilationException {
        try {
            AnalysisStepBase instance = blockClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.initAnalysisStepInstance(instance, publicProjectId);
            return instance;
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new TriggerCompilationException("Could not create instance of block " + String.valueOf(blockClass) + ": " + e.getMessage(), e);
        }
    }

    protected void initAnalysisStepInstance(AnalysisStepBase instance, PublicProjectId publicProjectId) throws TriggerCompilationException, IOException {
        instance.init(new AnalysisStepContext(this.triggerName, this.schedulingCommit == null ? null : ISchedulingCommit.parented(this.schedulingCommit), publicProjectId, this.profilingMonitor, this.postTriggerActions::add, this.getTempDir(), this.parallelTaskExecutor, this.lockProvider));
    }

    private void injectAnalysisStepParameters(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, ICrossProjectLockSupport crossProjectLockSupport, AnalysisStepBase instance) throws StorageException, TriggerCompilationException, AssertionError {
        this.injectAnalysisStepIndices(projectStorageSystem, crossProjectLockSupport, instance);
        for (EIndexAccessMode eIndexAccessMode : ORDERED_ACCESS_MODES) {
            for (AnalysisStepGlobalIndexAccess globalIndexAccess : this.trigger.getAnalysisStepInitializer().getGlobalIndexAccesses().getOrDefault((Object)eIndexAccessMode, Collections.emptyList())) {
                globalIndexAccess.setValue(instance, this.openGlobalIndex(globalIndexAccess, globalStorageSystem, crossProjectLockSupport));
            }
        }
        for (AnalysisStepBranchingLayerAccess analysisStepBranchingLayerAccess : this.trigger.getAnalysisStepInitializer().getBranchingLayerAccesses()) {
            analysisStepBranchingLayerAccess.setValue(instance, this.openBranchingLayer(analysisStepBranchingLayerAccess, (SchemaAwareStorageSystem)projectStorageSystem, crossProjectLockSupport));
        }
        for (AnalysisStepDeltaSource analysisStepDeltaSource : this.trigger.getAnalysisStepInitializer().getDeltaSources()) {
            String indexName = this.trigger.resolveIndexName(analysisStepDeltaSource.getIndexName());
            IIndexDelta delta = this.getDeltaForIndex(indexName, analysisStepDeltaSource.getIndexClass());
            this.inputDeltas.put(indexName, delta);
            analysisStepDeltaSource.setDelta(instance, delta);
        }
        this.injectTriggerParameters(instance);
    }

    private void injectAnalysisStepIndices(ProjectStorageSystem projectStorageSystem, ICrossProjectLockSupport crossProjectLockSupport, AnalysisStepBase instance) throws StorageException, TriggerCompilationException {
        Map<EIndexAccessMode, List<AnalysisStepProjectIndexAccess<?>>> indexAccesses = this.trigger.getAnalysisStepInitializer().getIndexAccesses();
        for (EIndexAccessMode accessMode : ORDERED_ACCESS_MODES) {
            for (AnalysisStepProjectIndexAccess indexAccess : indexAccesses.getOrDefault((Object)accessMode, Collections.emptyList())) {
                indexAccess.setValue(instance, this.openProjectIndex(indexAccess, projectStorageSystem, crossProjectLockSupport));
            }
        }
    }

    private void injectTriggerParameters(AnalysisStepBase instance) throws TriggerCompilationException {
        HashMap<String, Object> parameterValueCache = new HashMap<String, Object>();
        for (AnalysisStepParameter parameter : this.trigger.getAnalysisStepInitializer().getAnalysisStepParameters()) {
            String parameterName = parameter.getName();
            Optional<TriggerDescription.Parameter<String>> value = this.triggerDescription.getTriggerParameters().getParameter(parameterName);
            if (value.isEmpty()) {
                if (parameter.isOptional()) continue;
                throw new TriggerCompilationException("Expected parameter for " + String.valueOf(parameter));
            }
            if (!parameterValueCache.containsKey(parameterName)) {
                parameterValueCache.put(parameterName, parameter.parseValue(value.get()));
            }
            parameter.setValue(instance, parameterValueCache.get(parameterName));
        }
        this.checkForUnusedTriggerParameters();
    }

    private void checkForUnusedTriggerParameters() {
        HashSet unusedParameters = CollectionUtils.differenceSet(this.triggerDescription.getTriggerParameters().getParameterKeys(), (Collection[])new Collection[]{CollectionUtils.map(this.trigger.getAnalysisStepInitializer().getAnalysisStepParameters(), AnalysisStepParameter::getName)});
        if (!unusedParameters.isEmpty()) {
            LOGGER.error("Parameters supplied but not used by " + this.triggerName + ": " + String.valueOf(unusedParameters));
        }
    }

    private void invokePostInjectionMethods(AnalysisStepBase instance) {
        for (AnalysisStepPostInjectionMethod method : this.trigger.getAnalysisStepInitializer().getPostInjectionMethods()) {
            method.invoke(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ITriggerExecutionResultState executeAndHandleExceptions(IAnalysisStep step, CriticalSystemStateIndex criticalSystemStateIndex, SequencedSet<IPostTriggerAction> postTriggerActions, @Nullable RateLimitableResource remoteResource) {
        try {
            step.execute();
            ITriggerExecutionResultState.RunSuccessfully runSuccessfully = new ITriggerExecutionResultState.RunSuccessfully(postTriggerActions);
            return runSuccessfully;
        }
        catch (OutOfMemoryError e) {
            try {
                criticalSystemStateIndex.setStatus(CriticalSystemStateIndex.CriticalSystemStatus.createOutOfMemoryStatus());
            }
            catch (StorageException storageException) {
                LOGGER.error("Error writing critical system status: " + storageException.getMessage(), (Throwable)storageException);
            }
            ITriggerExecutionResultState storageException = AnalysisTriggerExecutorBase.handleFatalExecutionError(step, e, postTriggerActions);
            return storageException;
        }
        catch (RateLimitedAccessException e) {
            LOGGER.atInfo().withThrowable((Throwable)e).log(e.getMessage());
            Instant earliestReschedule = Instant.ofEpochMilli(e.earliestNextScheduleTimestamp);
            if (remoteResource == null) {
                LOGGER.warn("Trigger {} had a rate-limited access to a remote resource, but no such resource was specified", (Object)step.getClass().getSimpleName());
                ITriggerExecutionResultState.RescheduleRequested rescheduleRequested = new ITriggerExecutionResultState.RescheduleRequested(earliestReschedule);
                return rescheduleRequested;
            }
            ITriggerExecutionResultState.RescheduleRequested rescheduleRequested = new ITriggerExecutionResultState.RescheduleRequested(earliestReschedule, CollectionUtils.sequencedSet((Object[])new IPostTriggerAction.ApplyRateLimiting[]{new IPostTriggerAction.ApplyRateLimiting(remoteResource, earliestReschedule)}));
            return rescheduleRequested;
        }
        catch (RescheduleRequestedException e) {
            LOGGER.atInfo().withThrowable((Throwable)e).log(e.getMessage());
            ITriggerExecutionResultState.RescheduleRequested rescheduleRequested = new ITriggerExecutionResultState.RescheduleRequested(Instant.ofEpochMilli(e.earliestNextScheduleTimestamp));
            return rescheduleRequested;
        }
        catch (ExecutionCanceledException e) {
            ITriggerExecutionResultState.RunSuccessfully runSuccessfully = new ITriggerExecutionResultState.RunSuccessfully(CollectionUtils.sequencedSet((Object[])new IPostTriggerAction[0]));
            return runSuccessfully;
        }
        catch (Throwable t) {
            ITriggerExecutionResultState iTriggerExecutionResultState = AnalysisTriggerExecutorBase.handleFatalExecutionError(step, t, postTriggerActions);
            return iTriggerExecutionResultState;
        }
        finally {
            if (step.isCanceled()) {
                LOGGER.warn("Execution was canceled");
            }
        }
    }

    private static @NonNull ITriggerExecutionResultState handleFatalExecutionError(IAnalysisStep step, Throwable t, SequencedSet<IPostTriggerAction> postTriggerActions) {
        if (t instanceof RepositoryNeedsRollbackException) {
            RepositoryNeedsRollbackException rollbackException = (RepositoryNeedsRollbackException)((Object)t);
            LOGGER.error("Execution failed, requested reschedule: {}", (Object)t.getMessage(), (Object)t);
            return new ITriggerExecutionResultState.RunSuccessfully(CollectionUtils.sequencedSet((Object[])new IPostTriggerAction[]{new IPostTriggerAction.RequestRollback(new RollbackRequest(rollbackException.getRollbackToAsSchedulingHints(), rollbackException.getMessage(), rollbackException.getRollbackId()))}));
        }
        if (step.shouldRescheduleOnError()) {
            LOGGER.error("Execution failed, requested reschedule: " + t.getMessage(), t);
            return new ITriggerExecutionResultState.RescheduleRequested(Instant.EPOCH);
        }
        if (t.getClass().getSimpleName().equals(REPOSITORY_NEEDS_RESCHEDULE_EXCEPTION_NAME)) {
            LOGGER.warn("Trigger requested a reschedule, but is not reschedulable. For periodic triggers, this just means they will run again in their regular intervals instead of being immediately rescheduled: " + t.getMessage(), t);
            return new ITriggerExecutionResultState.RunSuccessfully(postTriggerActions);
        }
        LOGGER.fatal("Execution failed badly: " + t.getMessage(), t);
        return new ITriggerExecutionResultState.FailedBadly(t);
    }

    private IBranchingLayer openBranchingLayer(AnalysisStepBranchingLayerAccess branchingLayerAccess, SchemaAwareStorageSystem schemaAwareStorageSystem, ICrossProjectLockSupport crossProjectLockSupport) throws StorageException, TriggerCompilationException {
        String storeName = this.trigger.resolveIndexName(branchingLayerAccess.getIndexName());
        IndexSchema schema = schemaAwareStorageSystem.getSchema();
        SchemaEntry schemaEntry = schema.getEntry(storeName);
        if (schemaEntry == null) {
            throw new TriggerCompilationException("Could not find entry for store " + storeName + " in the schema!");
        }
        if (schemaEntry.usesOption(EStorageOption.VIRTUAL)) {
            throw new TriggerCompilationException("Can not access branching layer for store " + storeName + " as it is marked virtual!");
        }
        IStore rawStore = IndexSchema.applyStoreOptions((SchemaEntry)schemaEntry, (IStore)schemaAwareStorageSystem.openStore(storeName), (boolean)true, null, (IStorageSystem)schemaAwareStorageSystem, null);
        crossProjectLockSupport.collectNeededLocks(schemaEntry, rawStore);
        return IBranchingLayer.create((IStore)rawStore, (SchemaEntry)schemaEntry);
    }

    private Object openGlobalIndex(AnalysisStepGlobalIndexAccess indexAccess, GlobalStorageSystem globalStorageSystem, ICrossProjectLockSupport crossProjectLockSupport) throws StorageException {
        try {
            return switch (indexAccess.getAccessMode()) {
                case EIndexAccessMode.READ_ONLY, EIndexAccessMode.READ_WRITE -> this.openIndexPlain(indexAccess, (SchemaAwareStorageSystem)globalStorageSystem, crossProjectLockSupport);
                default -> CCSMAssert.fail((String)"Access mode not supported for global storage system.");
            };
        }
        catch (AssertionError e) {
            throw AnalysisTriggerExecutorBase.errorWithIndexAccessInfo(e, indexAccess);
        }
    }

    private Object openProjectIndex(AnalysisStepProjectIndexAccess<?> indexAccess, ProjectStorageSystem projectStorageSystem, ICrossProjectLockSupport crossProjectLockSupport) throws StorageException, TriggerCompilationException {
        try {
            return switch (indexAccess.getAccessMode()) {
                default -> throw new MatchException(null, null);
                case EIndexAccessMode.READ_ONLY, EIndexAccessMode.READ_WRITE -> this.openIndexPlain(indexAccess, (SchemaAwareStorageSystem)projectStorageSystem, crossProjectLockSupport);
                case EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY -> {
                    List<IStorageIndex> indices = this.openPreviousIndex(indexAccess, projectStorageSystem, crossProjectLockSupport);
                    if (indices.isEmpty() && this.schedulingCommit == null) {
                        yield null;
                    }
                    yield indices.getFirst();
                }
                case EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY -> new ArrayList(this.openPreviousIndex(indexAccess, projectStorageSystem, crossProjectLockSupport));
            };
        }
        catch (AssertionError e) {
            throw AnalysisTriggerExecutorBase.errorWithIndexAccessInfo(e, indexAccess);
        }
    }

    private static @NonNull AssertionError errorWithIndexAccessInfo(AssertionError assertionError, AnalysisStepIndexAccessBase<?> indexAccess) {
        return new AssertionError("Could not open index " + String.valueOf(indexAccess.getIndexName()) + " in mode " + String.valueOf((Object)indexAccess.getAccessMode()), (Throwable)((Object)assertionError));
    }

    private IStorageIndex openIndexPlain(AnalysisStepIndexAccessBase<?> indexAccess, SchemaAwareStorageSystem schemaAwareStorageSystem, ICrossProjectLockSupport crossProjectLockSupport) throws StorageException {
        IStorageIndex index;
        IndexSchema schema = schemaAwareStorageSystem.getSchema();
        String storeName = this.trigger.resolveIndexName(indexAccess.getIndexName());
        if (this.openIndexes.containsKey(storeName)) {
            return this.openIndexes.get(storeName);
        }
        boolean readOnly = indexAccess.getAccessMode() == EIndexAccessMode.READ_ONLY;
        SchemaEntry schemaEntry = schema.getEntry(storeName);
        boolean virtual = schemaEntry.usesOption(EStorageOption.VIRTUAL);
        IStoreDecorator decorator = this.getDecoratorToApply(storeName, readOnly, virtual);
        if (schemaEntry.isHistorized()) {
            CCSMAssert.isFalse((this.schedulingCommit == null ? 1 : 0) != 0, (String)("Expected valid commit for accessing historized store " + storeName + " but was null"));
            Optional<HistoryAccessOption> historyAccess = this.determineHistoryAccess(storeName, schemaEntry, readOnly, schemaAwareStorageSystem);
            index = historyAccess.isPresent() ? schemaAwareStorageSystem.openIndex(schemaEntry.createIndexClass(), storeName, historyAccess.get(), virtualStoreName -> this.openVirtualStore((String)virtualStoreName, readOnly), decorator) : AnalysisTriggerExecutorBase.createIndexForCommit(null, storeName, schemaEntry.createIndexClass(), schemaAwareStorageSystem, decorator);
        } else {
            index = schemaAwareStorageSystem.openIndex(schemaEntry.createIndexClass(), storeName, null, virtualStoreName -> this.openVirtualStore((String)virtualStoreName, readOnly), decorator);
        }
        crossProjectLockSupport.collectNeededLocks(schemaEntry, index);
        this.openIndexes.put(storeName, index);
        return index;
    }

    private List<IStorageIndex> openPreviousIndex(AnalysisStepProjectIndexAccess<?> indexAccess, ProjectStorageSystem projectStorageSystem, ICrossProjectLockSupport crossProjectLockSupport) throws StorageException, TriggerCompilationException {
        IndexSchema schema = projectStorageSystem.getSchema();
        String storeName = this.trigger.resolveIndexName(indexAccess.getIndexName());
        if (this.openedPreviousIndexes.containsKey(storeName)) {
            return this.openedPreviousIndexes.get(storeName);
        }
        SchemaEntry schemaEntry = schema.getEntry(storeName);
        if (schemaEntry.usesOption(EStorageOption.VIRTUAL)) {
            throw new TriggerCompilationException("Can not open previous version of store " + storeName + " as this is marked as virtual!");
        }
        CCSMAssert.isTrue((boolean)schemaEntry.isHistorized(), (String)"Expected historized store!");
        IBranchingLayer branchingLayer = projectStorageSystem.openBranchingLayer(storeName, schemaEntry.createIndexClass());
        List<IStorageIndex> result = this.openPreviousIndexesForAnalysisStep(projectStorageSystem, storeName, branchingLayer, schemaEntry.createIndexClass());
        crossProjectLockSupport.collectNeededLocks(schemaEntry, projectStorageSystem.openStore(storeName));
        this.openedPreviousIndexes.put(storeName, result);
        return result;
    }

    private List<IStorageIndex> openPreviousIndexesForAnalysisStep(ProjectStorageSystem projectStorageSystem, String storeName, IBranchingLayer branchingLayer, Class<? extends IStorageIndex> indexClass) throws StorageException {
        if (this.schedulingCommit == null) {
            return Collections.emptyList();
        }
        if (!this.trigger.isReadOnlyPreviousAllParentsStore(storeName)) {
            return List.of(AnalysisTriggerExecutorBase.createIndexForCommit(this.commitResolver.resolveCommit(this.getParentCommit(), branchingLayer, projectStorageSystem).orElse(null), storeName, indexClass, (SchemaAwareStorageSystem)projectStorageSystem, null));
        }
        return CollectionUtils.mapWithException((Collection)this.schedulingCommit.getParentCommits(), parent -> AnalysisTriggerExecutorBase.createIndexForCommit(this.commitResolver.resolveCommit((CommitDescriptor)parent, branchingLayer, projectStorageSystem).orElse(null), storeName, indexClass, (SchemaAwareStorageSystem)projectStorageSystem, null));
    }

    private Optional<HistoryAccessOption> determineHistoryAccess(String storeName, SchemaEntry schemaEntry, boolean readOnly, SchemaAwareStorageSystem schemaAwareStorageSystem) throws AssertionError, StorageException {
        if (schemaEntry.usesOption(EStorageOption.BRANCHED)) {
            CCSMAssert.isInstanceOf((Object)schemaAwareStorageSystem, ProjectStorageSystem.class);
            IBranchingLayer branchingLayer = schemaAwareStorageSystem.openBranchingLayer(storeName, schemaEntry.createIndexClass());
            return this.determineBranchedHistoryAccess(readOnly, (ProjectStorageSystem)schemaAwareStorageSystem, branchingLayer);
        }
        return Optional.of(this.determineNonBranchedHistoryAccess(readOnly));
    }

    private HistoryAccessOption determineNonBranchedHistoryAccess(boolean readOnly) {
        if (readOnly) {
            return HistoryAccessOption.readTimestampUnbranched((long)this.schedulingCommit.getTimestamp());
        }
        return HistoryAccessOption.readHeadWriteTimestampUnbranched((long)this.schedulingCommit.getTimestamp());
    }

    private Optional<HistoryAccessOption> determineBranchedHistoryAccess(boolean readOnly, ProjectStorageSystem projectStorageSystem, IBranchingLayer branchingLayer) throws AssertionError, StorageException {
        if (readOnly) {
            return this.determineBranchedReadOnlyHistoryAccess(projectStorageSystem, branchingLayer);
        }
        return Optional.of(this.determineBranchedReadWriteHistoryAccess(projectStorageSystem, branchingLayer));
    }

    private Optional<HistoryAccessOption> determineBranchedReadOnlyHistoryAccess(ProjectStorageSystem projectStorageSystem, IBranchingLayer branchingLayer) throws StorageException {
        Optional<CommitDescriptor> resolvedCommit = this.commitResolver.resolveCommit(this.schedulingCommit.getCommit(), branchingLayer, projectStorageSystem);
        return resolvedCommit.map(commitDescriptor -> HistoryAccessOption.readTimestamp((String)commitDescriptor.getBranchName(), (long)commitDescriptor.getTimestamp()));
    }

    private @NonNull HistoryAccessOption determineBranchedReadWriteHistoryAccess(ProjectStorageSystem projectStorageSystem, IBranchingLayer branchingLayer) throws StorageException {
        HistoryAccessOption historyAccess = HistoryAccessOption.readHeadWriteTimestamp((String)this.schedulingCommit.getBranchName(), (long)this.schedulingCommit.getTimestamp());
        Optional<CommitDescriptor> parentCommit = this.commitResolver.resolveCommit(this.getParentCommit(), branchingLayer, projectStorageSystem);
        parentCommit.ifPresent(commitDescriptor -> historyAccess.setExplicitParentCommit(commitDescriptor.getBranchName(), commitDescriptor.getTimestamp()));
        return historyAccess;
    }

    private List<CommitDescriptor> getParentCommits() {
        CCSMAssert.isFalse((this.schedulingCommit == null ? 1 : 0) != 0, (String)("Expected valid commit for accessing historized store " + (String)CollectionUtils.getAny(this.trigger.getReadOnlyPreviousStores()) + " but was null"));
        return this.schedulingCommit.getParentCommits();
    }

    private CommitDescriptor getParentCommit() {
        List<CommitDescriptor> parentCommits = this.getParentCommits();
        if (parentCommits.isEmpty()) {
            return null;
        }
        return parentCommits.getFirst();
    }

    private static IStorageIndex createIndexForCommit(CommitDescriptor commit, String storeName, Class<? extends IStorageIndex> indexClass, SchemaAwareStorageSystem schemaAwareStorageSystem, @Nullable IStoreDecorator decorator) throws StorageException {
        if (commit == null) {
            return AnalysisTriggerExecutorBase.createIndexForNullCommit(storeName, indexClass, schemaAwareStorageSystem, decorator);
        }
        HistoryAccessOption historyAccess = HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp());
        return schemaAwareStorageSystem.openIndex(indexClass, storeName, historyAccess, decorator);
    }

    private static IStorageIndex createIndexForNullCommit(String storeName, Class<? extends IStorageIndex> indexClass, SchemaAwareStorageSystem schemaAwareStorageSystem, @Nullable IStoreDecorator decorator) throws StorageException {
        try {
            InMemoryStore store = new InMemoryStore();
            if (decorator != null) {
                store = decorator.decorate((IStore)store);
            }
            if (schemaAwareStorageSystem.getSchema().getEntry(storeName).usesOption(EStorageOption.ABBREVIATE_STRINGS)) {
                IStorageAbbreviator abbreviator = schemaAwareStorageSystem.getAbbreviator();
                store = new StoreWithAbbreviationSupport((IStore)store, abbreviator);
            }
            return indexClass.getConstructor(IStore.class).newInstance(store);
        }
        catch (Exception e) {
            throw new StorageException("Failed to create index for " + storeName + " (index class " + String.valueOf(indexClass) + ")", (Throwable)e);
        }
    }

    protected abstract Path getTempDir();

    protected abstract IIndexDelta getDeltaForIndex(String var1, Class<? extends IStorageIndex> var2) throws StorageException;

    protected abstract IStore openVirtualStore(String var1, boolean var2) throws StorageException;

    protected abstract Map<String, Long> getWrittenVirtualStoreNameToId();

    private IStoreDecorator getDecoratorToApply(String storeName, boolean readOnly, boolean virtual) {
        if (readOnly) {
            return ReadOnlyStore::new;
        }
        if (this.requiredDeltas.contains(storeName)) {
            return store -> {
                RecordingStore recordingStore = new RecordingStore(store, virtual);
                this.recordingStores.add((Object)storeName, (Object)recordingStore);
                return recordingStore;
            };
        }
        return null;
    }

    private Map<String, List<IIndexDelta>> getOutputDeltas() throws StorageException {
        int maxDeltaSize = this.trigger.getMaxOutputDeltaSize();
        HashMap<String, List<IIndexDelta>> outputDeltas = new HashMap<String, List<IIndexDelta>>();
        for (int i = 0; i < this.recordingStores.size(); ++i) {
            String storeName;
            IIndexDelta resolvedDelta;
            KeyDelta keyDelta = ((RecordingStore)((Object)this.recordingStores.getSecond(i))).obtainDelta();
            if (keyDelta.isEmpty() || (resolvedDelta = AnalysisTriggerExecutorBase.resolveDelta(this.openIndexes.get(storeName = (String)this.recordingStores.getFirst(i)), keyDelta, storeName)).isEmpty()) continue;
            ArrayList<IIndexDelta> indexDeltas = new ArrayList<IIndexDelta>();
            for (IIndexDelta iIndexDelta : AnalysisTriggerExecutorBase.splitDeltaIfNecessary(resolvedDelta, maxDeltaSize)) {
                CCSMAssert.isFalse((boolean)iIndexDelta.isEmpty(), (String)"Obtained empty delta");
                CCSMAssert.isTrue((boolean)resolvedDelta.getClass().isAssignableFrom(iIndexDelta.getClass()), () -> "Obtained delta of a different type, expected %s but got %s".formatted(resolvedDelta.getClass(), delta.getClass()));
                indexDeltas.add(iIndexDelta);
            }
            outputDeltas.put(storeName, indexDeltas);
        }
        return outputDeltas;
    }

    private static IIndexDelta resolveDelta(IStorageIndex index, KeyDelta keyDelta, String storeName) throws StorageException {
        if (!(index instanceof IDeltaTranslatingIndex)) {
            return keyDelta;
        }
        IDeltaTranslatingIndex deltaTranslatingIndex = (IDeltaTranslatingIndex)index;
        Object resolvedDelta = deltaTranslatingIndex.resolveDelta(keyDelta);
        CCSMAssert.isNotNull(resolvedDelta, () -> "Index %s (%s) resolved the delta to null. Should be empty instead.".formatted(storeName, index.getClass()));
        CCSMAssert.isFalse((boolean)(resolvedDelta instanceof KeyDelta), () -> "Index %s (%s) illegally created %s".formatted(storeName, index.getClass(), KeyDelta.class));
        return resolvedDelta;
    }

    private static List<? extends IIndexDelta> splitDeltaIfNecessary(IIndexDelta baseDelta, int maxDeltaSize) {
        if (baseDelta.size() > maxDeltaSize) {
            return baseDelta.split(maxDeltaSize);
        }
        return List.of(baseDelta);
    }

    public @Nullable ParentedCommitDescriptor getSchedulingCommit() {
        return this.schedulingCommit;
    }

    protected abstract InternalProjectId getProjectId();

    public void setProfilingMonitor(IProfilingMonitor profilingMonitor) {
        this.profilingMonitor = profilingMonitor;
    }

    static {
        ArrayList<EIndexAccessMode> accessModes = new ArrayList<EIndexAccessMode>(Arrays.asList(EIndexAccessMode.values()));
        accessModes.removeAll(ORDERED_ACCESS_MODES);
        CCSMAssert.isTrue((boolean)accessModes.isEmpty(), () -> "Unexpected index access mode(s): %s".formatted(accessModes));
    }
}

