/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.analysis.trigger.IPostTriggerAction;
import com.teamscale.core.runtime.impl.analysis.ETriggerExecutionResultState;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.SequencedSet;
import org.conqat.lib.commons.collections.CollectionUtils;

public sealed interface ITriggerExecutionResultState {
    public ETriggerExecutionResultState getResult();

    public record RescheduleRequested(Instant earliestReschedule, SequencedSet<IPostTriggerAction.ApplyRateLimiting> rateLimitingActions) implements ITriggerExecutionResultState
    {
        public RescheduleRequested(Instant earliestReschedule) {
            this(earliestReschedule, CollectionUtils.sequencedSet((Object[])new IPostTriggerAction.ApplyRateLimiting[0]));
        }

        public RescheduleRequested {
            Objects.requireNonNull(earliestReschedule, "earliestReschedule");
            rateLimitingActions = Collections.unmodifiableSequencedSet(new LinkedHashSet(Objects.requireNonNull(rateLimitingActions, "rateLimitingActions")));
        }

        @Override
        public ETriggerExecutionResultState getResult() {
            return ETriggerExecutionResultState.RESCHEDULE_REQUESTED;
        }
    }

    public record FailedBadly(Throwable cause) implements ITriggerExecutionResultState
    {
        public FailedBadly {
            Objects.requireNonNull(cause, "cause");
        }

        @Override
        public ETriggerExecutionResultState getResult() {
            return ETriggerExecutionResultState.FAILED_BADLY;
        }
    }

    public record RunSuccessfully(SequencedSet<IPostTriggerAction> postTriggerActions) implements ITriggerExecutionResultState
    {
        public RunSuccessfully {
            postTriggerActions = Collections.unmodifiableSequencedSet(new LinkedHashSet(Objects.requireNonNull(postTriggerActions, "postTriggerActions")));
        }

        @Override
        public ETriggerExecutionResultState getResult() {
            return ETriggerExecutionResultState.RUN_SUCCESSFULLY;
        }
    }
}

