/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.analysis.trigger.IPostTriggerAction;
import com.teamscale.core.runtime.impl.project.DeleteProjectTrigger;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedSet;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.jspecify.annotations.Nullable;

public class JobExecutionResult {
    private final ScheduledJob scheduledJob;
    private final EJobResult result;
    private final PairList<String, Long> outputDeltas;
    private final Map<String, Long> virtualStores;
    private final long rescheduleAfterTimestamp;
    private final SequencedSet<IPostTriggerAction> postTriggerActions;

    public JobExecutionResult(ScheduledJob scheduledJob, EJobResult result, @Nullable PairList<String, Long> outputDeltas, @Nullable Map<String, Long> virtualStores, long rescheduleAfterTimestamp, SequencedSet<IPostTriggerAction> postTriggerActions) {
        this.scheduledJob = scheduledJob;
        this.result = result;
        this.outputDeltas = Objects.requireNonNullElseGet(outputDeltas, PairList::new);
        this.virtualStores = Objects.requireNonNullElse(virtualStores, Collections.emptyMap());
        this.rescheduleAfterTimestamp = rescheduleAfterTimestamp;
        this.postTriggerActions = new LinkedHashSet<IPostTriggerAction>(postTriggerActions);
    }

    public ScheduledJob getScheduledJob() {
        return this.scheduledJob;
    }

    public EJobResult getResult() {
        return this.result;
    }

    public PairList<String, Long> getOutputDeltas() {
        return this.outputDeltas;
    }

    public long getRescheduleAfterTimestamp() {
        return this.rescheduleAfterTimestamp;
    }

    public SequencedSet<IPostTriggerAction> getPostTriggerActions() {
        return this.postTriggerActions;
    }

    public Optional<Long> getVirtualStoreId(String storeName) {
        return Optional.ofNullable(this.virtualStores.get(storeName));
    }

    public UnmodifiableCollection<Long> getVirtualStores() {
        return CollectionUtils.asUnmodifiable(this.virtualStores.values());
    }

    public boolean isDeleted() {
        return this.result == EJobResult.COMPLETED_SUCCESSFULLY && DeleteProjectTrigger.class.getName().equals(this.scheduledJob.getTriggerName());
    }

    public String toString() {
        return "JobExecutionResult{scheduledJob=" + String.valueOf(this.scheduledJob) + ", result=" + String.valueOf((Object)this.result) + ", outputDeltas=" + String.valueOf(this.outputDeltas) + ", virtualStores=" + String.valueOf(this.virtualStores) + ", rescheduleAfterTimestamp=" + this.rescheduleAfterTimestamp + ", postTriggerActions=" + String.valueOf(this.postTriggerActions) + "}";
    }

    public static enum EJobResult {
        COMPLETED_SUCCESSFULLY,
        COMPLETED_WITH_ERROR,
        COMPLETED_WITH_UNRECOVERABLE_ERROR,
        RESCHEDULE_REQUESTED;

    }
}

