/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.analysis.IIndexDelta;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.trigger.IAnalysisStep;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.interaction.GlobalInteractionLogIndex;
import com.teamscale.core.log.interaction.ProjectInteractionLogIndex;
import com.teamscale.core.log.interaction.ShortInteractionLog;
import com.teamscale.core.log.parse.EParseLogOrigin;
import com.teamscale.core.log.parse.ParseLogEntry;
import com.teamscale.core.log.parse.ParseLogIndex;
import com.teamscale.core.log.worker.GlobalCriticalEventWorkerLogIndex;
import com.teamscale.core.log.worker.GlobalWorkerLogDigestIndex;
import com.teamscale.core.log.worker.GlobalWorkerLogIndex;
import com.teamscale.core.log.worker.ProjectCriticalEventWorkerLogIndex;
import com.teamscale.core.log.worker.ProjectWorkerLogDigestIndex;
import com.teamscale.core.log.worker.ProjectWorkerLogIndex;
import com.teamscale.core.log.worker.ShortCriticalEventWorkerLog;
import com.teamscale.core.log.worker.WorkerLogData;
import com.teamscale.core.log.worker.WorkerLogDigestIndexBase;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.api.performance.PerformanceDetailEntry;
import com.teamscale.core.runtime.api.performance.PerformanceIndexBase;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.api.rollback.RollbackRequest;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.DeltaIndex;
import com.teamscale.core.runtime.impl.analysis.ETriggerExecutionResultState;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.VirtualStoreIndex;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.ETriggerType;
import com.teamscale.core.runtime.impl.analysis.trigger.ITrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.performance.IThreadMemoryMonitor;
import com.teamscale.core.runtime.impl.performance.SectionProfilingMonitor;
import com.teamscale.core.runtime.impl.progress.AnalysisProgressIndexBase;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.core.runtime.impl.scheduling.AssignedJobs;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.scheduling.TriggerCache;
import com.teamscale.core.runtime.impl.worker.ICrossProjectLockSupport;
import com.teamscale.core.runtime.impl.worker.ITriggerExecutionResultState;
import com.teamscale.core.runtime.impl.worker.JobExecutionResult;
import com.teamscale.core.runtime.impl.worker.MultiThreadedReadsStorageSystemProviderDecorator;
import com.teamscale.core.runtime.impl.worker.PrivilegedTriggerExecutor;
import com.teamscale.core.runtime.impl.worker.TriggerExecutionResult;
import com.teamscale.core.runtime.impl.worker.WorkerAnalysisTriggerExecutor;
import com.teamscale.core.runtime.impl.worker.WorkerThread;
import com.teamscale.core.shutdown.ShutdownLock;
import eu.cqse.check.framework.shallowparser.util.ParseLogMessage;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.core.logging.TeamscaleLogAppender;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.index.collections.DurableIdGenerator;
import org.conqat.engine.persistence.store.IStorageSystemProviderDecorator;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.profiler.DetailedStorageProfiler;
import org.conqat.engine.persistence.store.profiler.StorageProfiler;
import org.conqat.engine.persistence.store.util.InterruptAwareStorageSystemProviderDecorator;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.lang.SilentAutoClosable;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class WorkerJobExecutor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String THREAD_CONTEXT_JOB_FIELD = "job";
    private static final String THREAD_CONTEXT_TRIGGER_FIELD = "trigger";
    private static final String THREAD_CONTEXT_PROJECT_ID_FIELD = "project";
    private static final String THREAD_CONTEXT_COMMIT_FIELD = "commit";
    private static final int DEFAULT_ACCEPTABLE_JOBS_DURATION_MS = 900000;
    private static final long MAX_JOBS_DURATION = Integer.parseInt(System.getProperty("com.teamscale.worker.max-job-duration", Integer.toString(900000)));
    private final String workerId;
    private final InstanceConfiguration instanceConfiguration;
    private final IndexLayer indexLayer;
    private final PublicProjectId publicProjectId;
    private final DeltaIndex deltaIndex;
    private final VirtualStoreIndex virtualStoreIndex;
    private final ProjectIndex projectIndex;
    private final TriggerCache triggerCache;
    private final ILockProvider lockProvider;
    private final TemporaryDirectory tempDirectory;
    private final ShutdownLock shutdownLock;
    private final DurableIdGenerator idGenerator;
    private final IParallelTaskExecutor parallelTaskExecutor;
    private final List<PerformanceDetailEntry.WorkerPerformanceData> supportingThreadPerformance = Collections.synchronizedList(new ArrayList());
    private final Phaser parallelExecutions = new Phaser(1);
    private final List<LogEvent> additionalLogEvents = Collections.synchronizedList(new ArrayList());
    private final AtomicReference<IAnalysisStep> currentlyExecutedStep = new AtomicReference();

    public WorkerJobExecutor(String workerId, InstanceConfiguration instanceConfiguration, IndexLayer indexLayer, PublicProjectId publicProjectId, DeltaIndex deltaIndex, VirtualStoreIndex virtualStoreIndex, ProjectIndex projectIndex, TriggerCache triggerCache, ILockProvider lockProvider, TemporaryDirectory tempDirectory, ShutdownLock shutdownLock, DurableIdGenerator idGenerator, IParallelTaskExecutor parallelTaskExecutor) {
        this.workerId = workerId;
        this.instanceConfiguration = instanceConfiguration;
        this.indexLayer = indexLayer;
        this.publicProjectId = publicProjectId;
        this.deltaIndex = deltaIndex;
        this.virtualStoreIndex = virtualStoreIndex;
        this.projectIndex = projectIndex;
        this.triggerCache = triggerCache;
        this.lockProvider = lockProvider;
        this.tempDirectory = tempDirectory;
        this.shutdownLock = shutdownLock;
        this.idGenerator = idGenerator;
        this.parallelTaskExecutor = parallelTaskExecutor;
    }

    public JobExecutionResult executeJob(ScheduledJob scheduledJob) throws StorageException {
        IThreadMemoryMonitor.MEMORY_MONITOR.startRecording(Thread.currentThread().threadId());
        StorageProfiler storageProfiler = WorkerJobExecutor.createStorageProfiler();
        SectionProfilingMonitor profilingMonitor = new SectionProfilingMonitor();
        try (SilentAutoClosable ignoredCleanup = WorkerJobExecutor.prepareLoggingEnvironment(scheduledJob, this.publicProjectId);){
            long startTime = System.currentTimeMillis();
            JobExecutionResult result = this.executeJob(scheduledJob, startTime, storageProfiler, profilingMonitor);
            this.logPerformanceData(scheduledJob.getJob(), startTime, storageProfiler, profilingMonitor, result);
            JobExecutionResult jobExecutionResult = result;
            return jobExecutionResult;
        }
    }

    private JobExecutionResult executeJob(ScheduledJob scheduledJob, long startTime, StorageProfiler storageProfiler, SectionProfilingMonitor profilingMonitor) throws StorageException {
        IndexLayer usedIndexLayer = this.indexLayer.decorate(new MultiThreadedReadsStorageSystemProviderDecorator()).decorate((IStorageSystemProviderDecorator)storageProfiler).decorate((IStorageSystemProviderDecorator)new InterruptAwareStorageSystemProviderDecorator());
        try {
            if (WorkerJobExecutor.prepareAndClear(this.tempDirectory, scheduledJob.getJob())) {
                return this.executeTrigger(scheduledJob, startTime, usedIndexLayer, profilingMonitor);
            }
            return new JobExecutionResult(scheduledJob, JobExecutionResult.EJobResult.RESCHEDULE_REQUESTED, (PairList<String, Long>)PairList.emptyPairList(), Collections.emptyMap(), 0L, Collections.emptyNavigableSet());
        }
        catch (Throwable t) {
            LOGGER.fatal("Had a serious error during trigger execution: {}", (Object)t.getMessage(), (Object)t);
            LOGGER.fatal("This might indicate inconsistencies between the scheduler and the worker.");
            LOGGER.fatal(this.buildRunningJobsMessage(scheduledJob, usedIndexLayer));
            this.logFatalException(scheduledJob.getJob(), startTime, t);
            return new JobExecutionResult(scheduledJob, JobExecutionResult.EJobResult.COMPLETED_WITH_UNRECOVERABLE_ERROR, (PairList<String, Long>)PairList.emptyPairList(), Collections.emptyMap(), 0L, Collections.emptyNavigableSet());
        }
    }

    private String buildRunningJobsMessage(ScheduledJob scheduledJob, IndexLayer usedIndexLayer) throws StorageException {
        AssignedJobs assignedJobs = new AssignedJobs(AnalysisProgressIndexBase.open(usedIndexLayer, (IProjectId)scheduledJob.getProjectId()));
        StringBuilder errorMessage = new StringBuilder("Jobs currently running in project '").append(this.indexLayer.resolveToPrimaryPublicProjectId((IProjectId)scheduledJob.getProjectId())).append("' (").append(scheduledJob.getProjectId()).append("):\n");
        for (ScheduledJob job : assignedJobs.getAllJobs()) {
            errorMessage.append("\t");
            if (job.equals(scheduledJob)) {
                errorMessage.append("[FAILING JOB] ");
            }
            errorMessage.append(job).append("\n");
        }
        return errorMessage.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobExecutionResult executeTrigger(ScheduledJob scheduledJob, long startTime, IndexLayer usedIndexLayer, IProfilingMonitor profilingMonitor) throws ConQATException, TriggerCompilationException, IOException {
        try {
            LOGGER.info("Starting job at {}", (Object)startTime);
            TriggerExecutionResult executionResult = switch (scheduledJob.getJob().getTriggerType()) {
                default -> throw new MatchException(null, null);
                case ETriggerType.PRIVILEGED -> this.executePrivilegedTrigger(scheduledJob, usedIndexLayer, profilingMonitor);
                case ETriggerType.BLOCK -> this.executeBlockBasedTrigger(scheduledJob, usedIndexLayer, profilingMonitor);
            };
            JobExecutionResult jobExecutionResult = this.buildJobExecutionResult(scheduledJob, startTime, executionResult);
            return jobExecutionResult;
        }
        finally {
            LOGGER.info("Finished job at {}", (Object)System.currentTimeMillis());
        }
    }

    private TriggerExecutionResult executeBlockBasedTrigger(ScheduledJob scheduledJob, IndexLayer indexLayer, IProfilingMonitor profilingMonitor) throws ConQATException, TriggerCompilationException {
        ITrigger trigger = this.triggerCache.findTrigger(scheduledJob.getJob()).orElseThrow(() -> new ConQATException("Job references invalid trigger: " + scheduledJob.getTriggerName()));
        AnalysisTrigger analysisTrigger = (AnalysisTrigger)CCSMAssert.checkedCast((Object)trigger, AnalysisTrigger.class);
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem((IProjectId)scheduledJob.getProjectId());
        WorkerAnalysisTriggerExecutor executor = new WorkerAnalysisTriggerExecutor(scheduledJob, analysisTrigger.getDescription(), this.tempDirectory.getPath(), this.deltaIndex, this.virtualStoreIndex, this.idGenerator, projectStorageSystem, this.parallelTaskExecutor, this.lockProvider);
        executor.setProfilingMonitor(profilingMonitor);
        ICrossProjectLockSupport crossProjectLockSupport = ICrossProjectLockSupport.createForProject(scheduledJob.getProjectId(), this.projectIndex, this.lockProvider);
        return executor.execute(this.triggerCache, projectStorageSystem, indexLayer.openGlobalStorageSystem(), crossProjectLockSupport, this::withAnalysisStep);
    }

    private TriggerExecutionResult executePrivilegedTrigger(ScheduledJob scheduledJob, IndexLayer indexLayer, IProfilingMonitor profilingMonitor) throws TriggerCompilationException, StorageException, IOException {
        PrivilegedTriggerExecutor executor = new PrivilegedTriggerExecutor(scheduledJob, indexLayer, this.lockProvider, this.instanceConfiguration, this.tempDirectory.getPath(), this.parallelTaskExecutor, profilingMonitor);
        return executor.execute(this::withAnalysisStep);
    }

    private static @NonNull StorageProfiler createStorageProfiler() {
        if (WorkerThread.LOG_PERFORMANCE_DETAILS) {
            return new DetailedStorageProfiler(false);
        }
        return new StorageProfiler();
    }

    private static SilentAutoClosable prepareLoggingEnvironment(ScheduledJob scheduledJob, PublicProjectId publicProjectId) {
        ThreadContext.put((String)THREAD_CONTEXT_JOB_FIELD, (String)"%s/%s (@%s)".formatted(publicProjectId, scheduledJob.getTriggerName(), scheduledJob.getSchedulingCommitDescriptor()));
        ThreadContext.put((String)THREAD_CONTEXT_TRIGGER_FIELD, (String)scheduledJob.getTriggerName());
        ThreadContext.put((String)THREAD_CONTEXT_PROJECT_ID_FIELD, (String)scheduledJob.getProjectId().toString());
        ThreadContext.put((String)THREAD_CONTEXT_COMMIT_FIELD, (String)String.valueOf(scheduledJob.getSchedulingCommitDescriptor()));
        return () -> {
            ThreadContext.remove((String)"context");
            ThreadContext.remove((String)THREAD_CONTEXT_COMMIT_FIELD);
            ThreadContext.remove((String)THREAD_CONTEXT_PROJECT_ID_FIELD);
            ThreadContext.remove((String)THREAD_CONTEXT_TRIGGER_FIELD);
            ThreadContext.remove((String)THREAD_CONTEXT_JOB_FIELD);
        };
    }

    public static void setAdditionalLog4jContext(String contextInformation) {
        ThreadContext.put((String)"context", (String)contextInformation);
    }

    private void logCriticalEvent(JobDescriptor job, long startTime) throws StorageException {
        if (!job.isCritical()) {
            return;
        }
        InternalProjectId projectId = job.getInternalProjectId();
        ShortCriticalEventWorkerLog shortLog = new ShortCriticalEventWorkerLog(this.workerId, projectId, job.getTriggerName(), LogEntryIdentifier.freshWithTimestamp(startTime), System.currentTimeMillis(), WorkerJobExecutor.replaceRollbackRequestedCommitDescriptor(job), job.getSchedulingReason(), job.getRollbackId());
        if (SchedulingConstants.isMaintenance((IProjectId)projectId)) {
            this.indexLayer.openGlobalIndex(GlobalCriticalEventWorkerLogIndex.class).insertWorkerLog(shortLog);
        } else {
            ProjectCriticalEventWorkerLogIndex index = this.indexLayer.openNonHistorizedProjectIndex(ProjectCriticalEventWorkerLogIndex.class, (IProjectId)projectId);
            index.insertWorkerLog(shortLog);
        }
    }

    @VisibleForTesting
    static @Nullable CommitDescriptor replaceRollbackRequestedCommitDescriptor(JobDescriptor job) {
        CommitDescriptor schedulingCommit = job.getSchedulingCommitDescriptor();
        if (!RollbackRequest.ROLLBACK_REQUESTED_COMMIT.equals((Object)schedulingCommit)) {
            return schedulingCommit;
        }
        try {
            return (CommitDescriptor)job.getParameterObject(RollbackRequest.class).rollbackCommits().stream().min(Comparator.naturalOrder()).orElseThrow();
        }
        catch (JsonSerializationException e) {
            LOGGER.error("Could not deserialize RollbackRequest", (Throwable)e);
            return schedulingCommit;
        }
    }

    private void insertWorkerLogIntoIndex(JobDescriptor job, WorkerLogData workerLogData) throws StorageException {
        InternalProjectId projectId = job.getInternalProjectId();
        if (SchedulingConstants.isMaintenance((IProjectId)projectId)) {
            this.indexLayer.openGlobalIndex(GlobalWorkerLogIndex.class).insertWorkerLog(workerLogData);
            WorkerJobExecutor.insertLogEntryDigest((SupplierWithException<WorkerLogDigestIndexBase, StorageException>)((SupplierWithException)() -> this.indexLayer.openGlobalIndex(GlobalWorkerLogDigestIndex.class)), workerLogData);
        } else {
            this.indexLayer.openNonHistorizedProjectIndex(ProjectWorkerLogIndex.class, (IProjectId)projectId).insertWorkerLog(workerLogData);
            WorkerJobExecutor.insertLogEntryDigest((SupplierWithException<WorkerLogDigestIndexBase, StorageException>)((SupplierWithException)() -> this.indexLayer.openNonHistorizedProjectIndex(ProjectWorkerLogDigestIndex.class, (IProjectId)projectId)), workerLogData);
        }
    }

    private static void insertLogEntryDigest(SupplierWithException<WorkerLogDigestIndexBase, StorageException> digestIndexSupplier, WorkerLogData workerLogData) throws StorageException {
        if (!workerLogData.hasErrorsOrWarnings()) {
            return;
        }
        ((WorkerLogDigestIndexBase)((Object)digestIndexSupplier.get())).insertDigestForLogEntry(workerLogData);
    }

    private JobExecutionResult buildJobExecutionResult(ScheduledJob scheduledJob, long startTime, TriggerExecutionResult executionResult) throws StorageException {
        this.shutdownLock.enterNoShutdownRegion();
        this.logExecutionResults(scheduledJob, startTime, executionResult);
        PairList<String, Long> outputDeltas = this.getOutputDeltas(scheduledJob, executionResult);
        Map<String, Long> virtualStores = executionResult.writtenVirtualStores();
        ITriggerExecutionResultState iTriggerExecutionResultState = executionResult.state();
        Objects.requireNonNull(iTriggerExecutionResultState);
        ITriggerExecutionResultState iTriggerExecutionResultState2 = iTriggerExecutionResultState;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ITriggerExecutionResultState.RunSuccessfully.class, ITriggerExecutionResultState.FailedBadly.class, ITriggerExecutionResultState.RescheduleRequested.class}, (ITriggerExecutionResultState)iTriggerExecutionResultState2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ITriggerExecutionResultState.RunSuccessfully runSuccessfully = (ITriggerExecutionResultState.RunSuccessfully)iTriggerExecutionResultState2;
                yield new JobExecutionResult(scheduledJob, JobExecutionResult.EJobResult.COMPLETED_SUCCESSFULLY, outputDeltas, virtualStores, 0L, runSuccessfully.postTriggerActions());
            }
            case 1 -> {
                ITriggerExecutionResultState.FailedBadly ignored = (ITriggerExecutionResultState.FailedBadly)iTriggerExecutionResultState2;
                yield new JobExecutionResult(scheduledJob, JobExecutionResult.EJobResult.COMPLETED_WITH_ERROR, outputDeltas, virtualStores, 0L, Collections.emptyNavigableSet());
            }
            case 2 -> {
                ITriggerExecutionResultState.RescheduleRequested rescheduleRequested = (ITriggerExecutionResultState.RescheduleRequested)iTriggerExecutionResultState2;
                yield new JobExecutionResult(scheduledJob, JobExecutionResult.EJobResult.RESCHEDULE_REQUESTED, outputDeltas, virtualStores, rescheduleRequested.earliestReschedule().toEpochMilli(), Collections.unmodifiableSequencedSet(rescheduleRequested.rateLimitingActions()));
            }
        };
    }

    private PairList<String, Long> getOutputDeltas(ScheduledJob scheduledJob, TriggerExecutionResult executionResult) throws StorageException {
        PairList<String, Long> deltas = this.dumpDeltas(executionResult);
        LOGGER.debug(() -> "Output job: " + String.valueOf(scheduledJob.getJob()) + " (" + String.valueOf(scheduledJob.getInputDeltaStoreNames()) + " -> " + String.valueOf(deltas));
        return deltas;
    }

    private void logExecutionResults(ScheduledJob scheduledJob, long startTime, TriggerExecutionResult executionResult) throws StorageException {
        JobDescriptor job = scheduledJob.getJob();
        if (SchedulingConstants.isDeleteOrReanalyze(job)) {
            return;
        }
        List<LogEvent> loggingEvents = this.mergeLogEvents(executionResult);
        List<LogEvent> nonParseLogEvents = this.filterAndHandleParsingErrors(job, loggingEvents);
        WorkerLogData workerLogData = WorkerLogData.create(this.workerId, startTime, job, job.getInternalProjectId(), LoggingEventTransport.convertFromLog4j(nonParseLogEvents), executionResult.inputDeltas().values(), executionResult.state().getResult());
        this.logCriticalEvent(job, startTime);
        this.logInteractions(job, nonParseLogEvents);
        this.insertWorkerLogIntoIndex(job, workerLogData);
    }

    private List<LogEvent> mergeLogEvents(TriggerExecutionResult executionResult) {
        ArrayList<LogEvent> loggingEvents = new ArrayList<LogEvent>(executionResult.loggingEvents());
        if (!this.additionalLogEvents.isEmpty()) {
            loggingEvents.addAll(this.additionalLogEvents);
            loggingEvents.sort(Comparator.comparingLong(LogEvent::getTimeMillis));
        }
        return loggingEvents;
    }

    private void logInteractions(JobDescriptor job, List<LogEvent> logEvents) throws StorageException {
        List interactionLogEvents = CollectionUtils.filter(logEvents, LoggingUtils::isInteractionLog);
        if (interactionLogEvents.isEmpty()) {
            return;
        }
        InternalProjectId projectId = job.getInternalProjectId();
        if (SchedulingConstants.isMaintenance((IProjectId)projectId)) {
            this.indexLayer.openGlobalIndex(GlobalInteractionLogIndex.class).insertInteractionLogs(ShortInteractionLog.convert(job.getTriggerName(), job.getSchedulingCommitDescriptor(), SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, interactionLogEvents));
        } else {
            this.indexLayer.openNonHistorizedProjectIndex(ProjectInteractionLogIndex.class, (IProjectId)projectId).insertInteractionLogs(ShortInteractionLog.convert(job.getTriggerName(), job.getSchedulingCommitDescriptor(), projectId, interactionLogEvents));
        }
    }

    private List<LogEvent> filterAndHandleParsingErrors(JobDescriptor job, List<LogEvent> logEvents) throws StorageException {
        ArrayList<LogEvent> parseLogEvents = new ArrayList<LogEvent>();
        ArrayList<LogEvent> otherEvents = new ArrayList<LogEvent>();
        for (LogEvent logEvent : logEvents) {
            if (LoggingUtils.isParseLog((LogEvent)logEvent)) {
                parseLogEvents.add(logEvent);
                continue;
            }
            otherEvents.add(logEvent);
        }
        if (parseLogEvents.isEmpty()) {
            return logEvents;
        }
        if (PreCommitUtils.isPrecommitJob(job)) {
            return otherEvents;
        }
        List<ParseLogEntry> logEntries = WorkerJobExecutor.convertToParseLogEntries(parseLogEvents, job.getSchedulingCommitDescriptor());
        InternalProjectId projectId = job.getInternalProjectId();
        this.indexLayer.openNonHistorizedProjectIndex(ParseLogIndex.class, (IProjectId)projectId).persistLogEntries(logEntries);
        return otherEvents;
    }

    public static @NonNull List<ParseLogEntry> convertToParseLogEntries(List<LogEvent> parseLogEvents, @Nullable CommitDescriptor commit) {
        ArrayList<ParseLogEntry> logEntries = new ArrayList<ParseLogEntry>();
        for (LogEvent event : parseLogEvents) {
            ParseLogMessage message = (ParseLogMessage)event.getMessage();
            logEntries.add(new ParseLogEntry(EParseLogOrigin.valueOf(message.getParseLogOriginStep()), message.getFormattedMessage(), message.getUniformPath(), commit, message.getLineNumber()));
        }
        return logEntries;
    }

    private static boolean prepareAndClear(TemporaryDirectory tempDirectory, JobDescriptor job) {
        try {
            FileSystemUtils.ensureDirectoryExists((Path)tempDirectory.getPath());
            tempDirectory.clear();
            return true;
        }
        catch (Exception e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Failed to clear temp dir. Rescheduling job {} to retry later. This might delay the job indefinitely. If this error seems systemic, please contact support@cqse.eu.", (Object)job);
            return false;
        }
    }

    private PairList<String, Long> dumpDeltas(TriggerExecutionResult executionResult) throws StorageException {
        PairList outputDeltas = new PairList();
        PairList valuesToWrite = new PairList();
        for (Map.Entry<String, List<IIndexDelta>> deltaEntry : executionResult.outputDeltas().entrySet()) {
            String storeName = deltaEntry.getKey();
            List<IIndexDelta> deltas = deltaEntry.getValue();
            for (IIndexDelta delta : deltas) {
                Long deltaId = this.idGenerator.getNextId();
                valuesToWrite.add((Object)deltaId, (Object)delta);
                outputDeltas.add((Object)storeName, (Object)deltaId);
            }
        }
        this.deltaIndex.putDeltas((PairList<Long, IIndexDelta>)valuesToWrite);
        return outputDeltas;
    }

    private void logFatalException(JobDescriptor job, long startTime, Throwable t) throws StorageException {
        LoggingEventTransport loggingEvent = LoggingEventTransport.of((String)StringUtils.obtainStackTrace((Throwable)t), (ELogLevel)ELogLevel.FATAL);
        CommitDescriptor commit = job.getSchedulingCommitDescriptor();
        if (commit == null) {
            commit = CommitDescriptor.createUnbranchedDescriptor((long)1L);
        }
        this.insertWorkerLogIntoIndex(job, WorkerLogData.create(this.workerId, startTime, job, job.getInternalProjectId(), commit, Collections.singletonList(loggingEvent), Collections.emptyList(), ETriggerExecutionResultState.FAILED_BADLY));
    }

    private void logPerformanceData(JobDescriptor job, long startTime, StorageProfiler storageProfiler, SectionProfilingMonitor profilingMonitor, JobExecutionResult jobResult) {
        if (!WorkerJobExecutor.shouldLogPerformanceData(job)) {
            return;
        }
        ETriggerExecutionResultState triggerExecutionResult = switch (jobResult.getResult()) {
            default -> throw new MatchException(null, null);
            case JobExecutionResult.EJobResult.COMPLETED_SUCCESSFULLY -> ETriggerExecutionResultState.RUN_SUCCESSFULLY;
            case JobExecutionResult.EJobResult.COMPLETED_WITH_ERROR, JobExecutionResult.EJobResult.COMPLETED_WITH_UNRECOVERABLE_ERROR -> ETriggerExecutionResultState.FAILED_BADLY;
            case JobExecutionResult.EJobResult.RESCHEDULE_REQUESTED -> ETriggerExecutionResultState.RESCHEDULE_REQUESTED;
        };
        try {
            this.logPerformanceData(job, startTime, storageProfiler, profilingMonitor, triggerExecutionResult);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to store performance data", (Throwable)e);
        }
    }

    private void logPerformanceData(JobDescriptor job, long startTime, StorageProfiler storageProfiler, SectionProfilingMonitor profilingMonitor, ETriggerExecutionResultState triggerExecutionResult) throws StorageException {
        PerformanceIndexBase performanceIndex = PerformanceIndexBase.open(this.indexLayer, (IProjectId)job.getInternalProjectId());
        long durationMillis = System.currentTimeMillis() - startTime;
        InternalProjectId projectId = job.getInternalProjectId();
        EAnalysisState analysisState = EAnalysisState.LIVE_ANALYSIS;
        if (!SchedulingConstants.isMaintenance((IProjectId)projectId)) {
            analysisState = this.indexLayer.openNonHistorizedProjectIndex(ProjectAnalysisProgressIndex.class, (IProjectId)job.getInternalProjectId()).getAnalysisState();
            if (durationMillis > MAX_JOBS_DURATION) {
                WorkerLogData workerLogData = WorkerLogData.create(this.workerId, startTime, job, projectId, List.of(LoggingEventTransport.of((String)("Job took " + durationMillis + " milliseconds, which is longer than " + MAX_JOBS_DURATION + " milliseconds . To change the acceptable duration, set the JVM flag: com.teamscale.worker.max-job-duration to a different millisecond threshold."), (ELogLevel)ELogLevel.WARN)), Collections.emptyList(), triggerExecutionResult);
                this.insertWorkerLogIntoIndex(job, workerLogData);
            }
        }
        PerformanceDetailEntry entry = new PerformanceDetailEntry(analysisState, job.getTriggerName(), this.indexLayer.resolveToPrimaryPublicProjectId((IProjectId)job.getInternalProjectId()), job.getSchedulingCommitDescriptor(), new PerformanceDetailEntry.WorkerPerformanceData(this.workerId, Instant.ofEpochMilli(startTime), Duration.ofMillis(durationMillis), IThreadMemoryMonitor.MEMORY_MONITOR.getMaxMemoryBytes(Thread.currentThread().threadId())), this.supportingThreadPerformance, storageProfiler.getNumberOfCalls(), storageProfiler.getTimeMillis());
        profilingMonitor.appendToEntry(entry);
        if (WorkerThread.LOG_PERFORMANCE_DETAILS) {
            entry.setStoreOperationStatisticsByStore(((DetailedStorageProfiler)storageProfiler).getOperationStatisticsByStore());
            performanceIndex.addDetailEntry(entry);
        }
        performanceIndex.updateAggregate(entry);
    }

    private static boolean shouldLogPerformanceData(JobDescriptor job) {
        return job.getTriggerType() != ETriggerType.PRIVILEGED || !SchedulingConstants.isDeleteOrReanalyze(job);
    }

    SilentAutoClosable registerParallelExecution(String supportingWorkerId, ScheduledJob scheduledJob) {
        TeamscaleLogAppender.init();
        SilentAutoClosable loggingCleanup = WorkerJobExecutor.prepareLoggingEnvironment(scheduledJob, this.publicProjectId);
        this.parallelExecutions.register();
        Instant startTime = DateTimeUtils.now();
        return ((SilentAutoClosable)() -> {
            this.appendParallelExecutionData((UnmodifiableList<LogEvent>)TeamscaleLogAppender.getLogEvents(), startTime, supportingWorkerId);
            this.parallelExecutions.arriveAndDeregister();
        }).andThen(loggingCleanup);
    }

    private void appendParallelExecutionData(UnmodifiableList<LogEvent> logEvents, Instant startTime, String workerId) {
        this.additionalLogEvents.addAll((Collection<LogEvent>)logEvents);
        this.supportingThreadPerformance.add(new PerformanceDetailEntry.WorkerPerformanceData(workerId, startTime, Duration.between(startTime, DateTimeUtils.now()), IThreadMemoryMonitor.MEMORY_MONITOR.getMaxMemoryBytes(Thread.currentThread().getId())));
    }

    private void awaitParallelExecutions() {
        this.parallelExecutions.arriveAndAwaitAdvance();
    }

    private SilentAutoClosable withAnalysisStep(IAnalysisStep step) {
        if (!this.currentlyExecutedStep.compareAndSet(null, step)) {
            throw new IllegalStateException("There is already a different step being executed");
        }
        return () -> {
            this.awaitParallelExecutions();
            if (!this.currentlyExecutedStep.compareAndSet(step, null)) {
                throw new IllegalStateException("Unable to unset step %s as a different one is being executed.".formatted(step));
            }
        };
    }

    public void cancelStep(boolean interrupt) {
        ICancelable delegate = this.currentlyExecutedStep.get();
        if (delegate == null) {
            return;
        }
        delegate.cancel(interrupt);
    }
}

