/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.shutdown;

import com.teamscale.core.shutdown.ShutdownLock;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.lib.commons.waiting.WaitSpec;
import org.conqat.lib.commons.waiting.WaitUtil;

public class ShutdownManager {
    private static final int MAX_SHUTDOWN_DELAY_MILLIS = 5000;
    private static final int SHUTDOWN_WAIT_DELAY_MILLIS = 100;
    private static ShutdownManager instance;
    private boolean shutdownStarted = false;
    private final List<Runnable> shutdownHooks = new ArrayList<Runnable>();
    private final List<WeakReference<ShutdownLock>> shutdownLocks = new ArrayList<WeakReference<ShutdownLock>>();

    private ShutdownManager() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::prepareShutdown));
    }

    public static synchronized ShutdownManager getInstance() {
        if (instance == null) {
            instance = new ShutdownManager();
        }
        return instance;
    }

    public void shutdown() {
        this.shutdown(0);
    }

    public void shutdown(int exitCode) {
        new Thread(() -> {
            if (this.prepareShutdown()) {
                System.exit(exitCode);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareShutdown() {
        ShutdownManager shutdownManager = this;
        synchronized (shutdownManager) {
            if (this.shutdownStarted) {
                return false;
            }
            this.shutdownStarted = true;
        }
        LoggingUtils.OPERATIONS_LOGGER.info("Shutdown of Teamscale requested!");
        this.waitForShutdownLocks();
        this.runShutdownHooks();
        return true;
    }

    private void waitForShutdownLocks() {
        List<ShutdownLock> remainingLocks = Collections.synchronizedList(new ArrayList());
        for (WeakReference<ShutdownLock> lockReference : this.shutdownLocks) {
            ShutdownLock lock = (ShutdownLock)lockReference.get();
            if (lock == null || !lock.isInNoShutdownRegion()) continue;
            remainingLocks.add(lock);
        }
        ((WaitSpec)((WaitSpec)((WaitSpec)WaitUtil.condition(() -> {
            remainingLocks.removeIf(lock -> !lock.isInNoShutdownRegion());
            return remainingLocks.isEmpty();
        }).asWaitingFor("shutdown locks to complete no-shutdown region")).timeout(Duration.ofMillis(5000L))).pollInterval(Duration.ofMillis(100L))).continueSilentlyOnTimeoutOrInterrupt().execute();
    }

    private void runShutdownHooks() {
        Collections.reverse(this.shutdownHooks);
        for (Runnable shutdownHook : this.shutdownHooks) {
            try {
                shutdownHook.run();
            }
            catch (Throwable t) {
                LoggingUtils.OPERATIONS_LOGGER.error("Error in shutdown hook: " + t.getMessage(), t);
            }
        }
    }

    public synchronized ShutdownLock obtainShutdownLock() {
        ShutdownLock lock = new ShutdownLock();
        this.shutdownLocks.add(new WeakReference<ShutdownLock>(lock));
        return lock;
    }

    public synchronized boolean isShutdownStarted() {
        return this.shutdownStarted;
    }

    public void addShutdownHook(Runnable runnable) {
        this.shutdownHooks.add(runnable);
    }
}

