/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.tfs;

import com.microsoft.tfs.core.TFProxyServerSettings;
import com.microsoft.tfs.core.config.ConnectionInstanceData;
import com.microsoft.tfs.core.config.DefaultConnectionAdvisor;
import com.microsoft.tfs.core.config.httpclient.DefaultHTTPClientFactory;
import com.microsoft.tfs.core.config.httpclient.HTTPClientFactory;
import com.microsoft.tfs.core.config.httpclient.internal.DefaultSSLProtocolSocketFactory;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.core.config.tfproxy.DefaultTFProxyServerSettingsFactory;
import com.microsoft.tfs.core.config.tfproxy.TFProxyServerSettingsFactory;
import com.microsoft.tfs.core.httpclient.HostConfiguration;
import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.core.httpclient.HttpConnectionManager;
import com.microsoft.tfs.core.httpclient.HttpState;
import com.microsoft.tfs.core.httpclient.MultiThreadedHttpConnectionManager;
import com.microsoft.tfs.core.httpclient.ProxyHost;
import com.microsoft.tfs.core.httpclient.params.HttpClientParams;
import com.microsoft.tfs.core.httpclient.params.HttpConnectionManagerParams;
import com.microsoft.tfs.core.httpclient.params.HttpConnectionParams;
import com.microsoft.tfs.core.httpclient.protocol.DefaultProtocolSocketFactory;
import com.microsoft.tfs.core.httpclient.protocol.Protocol;
import com.microsoft.tfs.core.httpclient.protocol.ProtocolSocketFactory;
import com.microsoft.tfs.core.persistence.FilesystemPersistenceStore;
import com.microsoft.tfs.core.persistence.VersionedVendorFilesystemPersistenceStore;
import com.teamscale.core.rest.client.Retrofit;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class TeamscaleTfsConnectionAdvisor
extends DefaultConnectionAdvisor {
    private static TeamscaleTfsConnectionAdvisor instance;
    private static SSLContext customSslContext;
    private final Map<String, HTTPClientFactory> httpClientFactories = new HashMap<String, HTTPClientFactory>();
    private final HttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager(this){
        {
            Objects.requireNonNull(this$0);
        }

        public synchronized void shutdown() {
        }
    };
    private final ProtocolSocketFactory socketFactory = new DefaultProtocolSocketFactory();
    private ProtocolSocketFactory sslSocketFactory = new DefaultSSLProtocolSocketFactory();
    private final TeamscalePersistenceStoreProvider persistenceStoreProvider = new TeamscalePersistenceStoreProvider();

    private TeamscaleTfsConnectionAdvisor() throws IOException {
        super(Locale.getDefault(), TimeZone.getDefault());
        if (customSslContext != null) {
            this.sslSocketFactory = TeamscaleTfsConnectionAdvisor::createSocketWithCustomSslContext;
        }
        HttpConnectionManagerParams params = this.connectionManager.getParams();
        params.setMaxTotalConnections(Integer.getInteger("com.microsoft.tfs.core.maxTotalConnections", 40).intValue());
        params.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, Integer.getInteger("com.microsoft.tfs.core.maxConnectionsPerHost", 10).intValue());
        params.setConnectionTimeout(Integer.getInteger("com.microsoft.tfs.core.connectTimeoutSeconds", 30) * 1000);
    }

    private static Socket createSocketWithCustomSslContext(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException {
        Socket socket = customSslContext.getSocketFactory().createSocket();
        socket.bind(new InetSocketAddress(localAddress, localPort));
        int timeout = params.getConnectionTimeout();
        socket.connect(new InetSocketAddress(host, port), timeout);
        return socket;
    }

    public static synchronized TeamscaleTfsConnectionAdvisor getInstance() throws IOException {
        if (instance == null) {
            instance = new TeamscaleTfsConnectionAdvisor();
        }
        return instance;
    }

    public static void overwriteSslContext(SSLContext sslContext) {
        customSslContext = sslContext;
    }

    public synchronized HTTPClientFactory getHTTPClientFactory(ConnectionInstanceData instanceData) {
        String instanceDataHash = TeamscaleTfsConnectionAdvisor.getConnectionInstanceDataKey(instanceData);
        Object factory = this.httpClientFactories.get(instanceDataHash);
        if (factory == null) {
            factory = new TeamscaleHttpClientFactory(this, instanceData);
            this.httpClientFactories.put(instanceDataHash, (HTTPClientFactory)factory);
        }
        return factory;
    }

    public TFProxyServerSettingsFactory getTFProxyServerSettingsFactory(ConnectionInstanceData instanceData) {
        return new DefaultTFProxyServerSettingsFactory(this, instanceData){
            {
                Objects.requireNonNull(this$0);
                super(connectionInstanceData);
            }

            protected TFProxyServerSettings configureFromRegistry() {
                return null;
            }
        };
    }

    private static String getConnectionInstanceDataKey(ConnectionInstanceData instanceData) {
        Object key = instanceData.getServerURI().toString();
        if (instanceData.getCredentials() != null) {
            key = instanceData.getCredentials().toString() + "@" + (String)key;
        }
        return key;
    }

    @VisibleForTesting
    static boolean isHostExcludedFromProxy(String host, String nonProxyHosts) {
        if (StringUtils.isEmpty((String)nonProxyHosts)) {
            return false;
        }
        for (String nonProxyHost : StringUtils.splitToList((String)nonProxyHosts, (String)"\\|")) {
            if (nonProxyHost.startsWith("*") && StringUtils.endsWithIgnoreCase((String)host, (String)nonProxyHost.substring(1))) {
                return true;
            }
            if (nonProxyHost.endsWith("*") && StringUtils.startsWithIgnoreCase((String)host, (String)nonProxyHost.substring(0, nonProxyHost.length() - 1))) {
                return true;
            }
            if (!host.equalsIgnoreCase(nonProxyHost)) continue;
            return true;
        }
        return false;
    }

    public PersistenceStoreProvider getPersistenceStoreProvider(ConnectionInstanceData instanceData) {
        return this.persistenceStoreProvider;
    }

    static {
        customSslContext = null;
    }

    private static class TeamscalePersistenceStoreProvider
    implements PersistenceStoreProvider {
        private final VersionedVendorFilesystemPersistenceStore cachePersistenceStore;
        private final VersionedVendorFilesystemPersistenceStore configurationPersistenceStore;
        private final VersionedVendorFilesystemPersistenceStore logPersistenceStore;

        public TeamscalePersistenceStoreProvider() throws IOException {
            File tfsDataFolder = new File("tfs-data");
            if (tfsDataFolder.exists()) {
                FileSystemUtils.deleteRecursively((File)tfsDataFolder);
            }
            TeamscaleVersionedVendorFilesystemPersistenceStore basePersistenceStore = new TeamscaleVersionedVendorFilesystemPersistenceStore(tfsDataFolder);
            this.cachePersistenceStore = (VersionedVendorFilesystemPersistenceStore)basePersistenceStore.getChildStore("Cache");
            this.configurationPersistenceStore = (VersionedVendorFilesystemPersistenceStore)basePersistenceStore.getChildStore("Configuration");
            this.logPersistenceStore = (VersionedVendorFilesystemPersistenceStore)basePersistenceStore.getChildStore("Logs");
        }

        public FilesystemPersistenceStore getCachePersistenceStore() {
            return this.cachePersistenceStore;
        }

        public FilesystemPersistenceStore getConfigurationPersistenceStore() {
            return this.configurationPersistenceStore;
        }

        public FilesystemPersistenceStore getLogPersistenceStore() {
            return this.logPersistenceStore;
        }
    }

    private class TeamscaleHttpClientFactory
    extends DefaultHTTPClientFactory {
        final /* synthetic */ TeamscaleTfsConnectionAdvisor this$0;

        private TeamscaleHttpClientFactory(TeamscaleTfsConnectionAdvisor teamscaleTfsConnectionAdvisor, ConnectionInstanceData connectionInstanceData) {
            TeamscaleTfsConnectionAdvisor teamscaleTfsConnectionAdvisor2 = teamscaleTfsConnectionAdvisor;
            Objects.requireNonNull(teamscaleTfsConnectionAdvisor2);
            this.this$0 = teamscaleTfsConnectionAdvisor2;
            super(connectionInstanceData);
        }

        public HttpConnectionManager createConnectionManager(ConnectionInstanceData connectionInstanceData) {
            return this.this$0.connectionManager;
        }

        public HttpClient createHTTPClient(HttpConnectionManager connectionManager, ConnectionInstanceData connectionInstanceData) {
            Protocol.registerProtocol((String)"http", (Protocol)new Protocol("http", this.this$0.socketFactory, 80));
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", this.this$0.sslSocketFactory, 443));
            return new HttpClient(connectionManager);
        }

        public void configureClientProxy(HttpClient httpClient, HostConfiguration hostConfiguration, HttpState httpState, ConnectionInstanceData connectionInstanceData) {
            String scheme = connectionInstanceData.getServerURI().getScheme();
            if (TeamscaleHttpClientFactory.isHostExcludedFromProxy(connectionInstanceData.getServerURI().getHost(), scheme)) {
                return;
            }
            String proxyHost = System.getProperty(scheme + ".proxyHost");
            if (!StringUtils.isEmpty((String)proxyHost)) {
                String proxyPortString = System.getProperty(scheme + ".proxyPort");
                ProxyHost proxy = new ProxyHost(proxyHost);
                if (proxyPortString != null && Pattern.matches("\\d+", proxyPortString)) {
                    proxy = new ProxyHost(proxyHost, Integer.parseInt(proxyPortString));
                }
                hostConfiguration.setProxyHost(proxy);
            }
        }

        private static boolean isHostExcludedFromProxy(String host, String scheme) {
            String nonProxyHosts = System.getProperty("http.nonProxyHosts");
            if (StringUtils.isEmpty((String)nonProxyHosts) && scheme.equalsIgnoreCase("https")) {
                nonProxyHosts = System.getProperty("https.nonProxyHosts");
            }
            return TeamscaleTfsConnectionAdvisor.isHostExcludedFromProxy(host, nonProxyHosts);
        }

        public void configureClientParams(HttpClient httpClient, HttpClientParams params, ConnectionInstanceData connectionInstanceData) {
            super.configureClientParams(httpClient, params, connectionInstanceData);
            params.setParameter("http.useragent", (Object)Retrofit.USER_AGENT);
        }
    }

    private static class TeamscaleVersionedVendorFilesystemPersistenceStore
    extends VersionedVendorFilesystemPersistenceStore {
        public TeamscaleVersionedVendorFilesystemPersistenceStore(File directory) {
            super(directory);
        }
    }
}

