/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.tfs.wiql;

import com.teamscale.core.tfs.wiql.FieldBasedWiqlWhereClause;
import com.teamscale.core.tfs.wiql.IWiqlWhereOperator;
import com.teamscale.core.tfs.wiql.SimpleWiqlBuilder;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

final class CollectionWiqlWhereClause
extends FieldBasedWiqlWhereClause<IWiqlWhereOperator.EWiqlCollectionOperator> {
    private final Set<String> values;

    public CollectionWiqlWhereClause(String field, IWiqlWhereOperator.EWiqlCollectionOperator operator, Collection<String> values) {
        super(field, operator);
        this.values = new LinkedHashSet<String>(Objects.requireNonNull(values, "values"));
    }

    @Override
    protected boolean isValueValid() {
        return this.values.stream().allMatch(SimpleWiqlBuilder::isValueValidForQuery);
    }

    @Override
    protected String wiqlValue() {
        return this.values.stream().map(SimpleWiqlBuilder::escapeValue).collect(Collectors.joining(", ", "(", ")"));
    }

    @Override
    protected boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public CollectionWiqlWhereClause negated() {
        return new CollectionWiqlWhereClause(this.field, ((IWiqlWhereOperator.EWiqlCollectionOperator)this.operator).negated(), this.values);
    }
}

