/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.tfs.wiql;

public sealed interface IWiqlWhereOperator {
    public String wiqlValue();

    public IWiqlWhereOperator negated();

    public static enum EWiqlCollectionOperator implements IWiqlWhereOperator
    {
        IN("in"),
        NOT_IN("not in");

        private final String value;

        private EWiqlCollectionOperator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.wiqlValue();
        }

        @Override
        public String wiqlValue() {
            return this.value;
        }

        @Override
        public EWiqlCollectionOperator negated() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> NOT_IN;
                case 1 -> IN;
            };
        }
    }

    public static enum EWiqlSimpleOperator implements IWiqlWhereOperator
    {
        EQ("="),
        NEQ("<>"),
        GT(">"),
        GE(">="),
        LT("<"),
        LE("<="),
        UNDER("under"),
        NOT_UNDER("not under"),
        CONTAINS("contains"),
        NOT_CONTAINS("not contains");

        private final String value;

        private EWiqlSimpleOperator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.wiqlValue();
        }

        @Override
        public String wiqlValue() {
            return this.value;
        }

        @Override
        public EWiqlSimpleOperator negated() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> NEQ;
                case 1 -> EQ;
                case 2 -> LE;
                case 5 -> GT;
                case 3 -> LT;
                case 4 -> GE;
                case 6 -> NOT_UNDER;
                case 7 -> UNDER;
                case 8 -> NOT_CONTAINS;
                case 9 -> CONTAINS;
            };
        }
    }
}

