/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.tfs.wiql;

import com.teamscale.core.tfs.wiql.WiqlWhereClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.conqat.lib.commons.collections.Pair;

public class SimpleWiqlBuilder {
    private final Set<String> selectFields = new LinkedHashSet<String>();
    private static final char[] FORBIDDEN_FIELD_NAME_CHARACTERS = new char[]{',', ';', '\'', '`', ':', '~', '/', '\\', '*', '|', '?', '\"', '&', '%', '$', '!', '+', '=', '(', ')', '[', ']', '{', '}', '<', '>'};
    private String fromTable;
    private final List<WiqlWhereClause> wheres = new ArrayList<WiqlWhereClause>();
    private final List<Pair<Boolean, String>> orderBys = new ArrayList<Pair<Boolean, String>>();

    public SimpleWiqlBuilder select(String ... fields) {
        this.selectFields.addAll(List.of(fields));
        return this;
    }

    public SimpleWiqlBuilder select(Collection<String> fields) {
        this.selectFields.addAll(fields);
        return this;
    }

    public SimpleWiqlBuilder from(String from) {
        this.fromTable = from;
        return this;
    }

    public SimpleWiqlBuilder where(WiqlWhereClause ... whereClause) {
        return this.where(List.of(whereClause));
    }

    public SimpleWiqlBuilder where(Collection<WiqlWhereClause> whereClause) {
        this.wheres.addAll(whereClause);
        return this;
    }

    public SimpleWiqlBuilder orderBy(boolean ascending, String fieldName) {
        this.orderBys.add((Pair<Boolean, String>)new Pair((Object)ascending, (Object)fieldName));
        return this;
    }

    public boolean validate() {
        return !this.selectFields.isEmpty() && this.fromTable != null && !this.fromTable.isEmpty() && SimpleWiqlBuilder.isFieldNameValidForQuery(this.fromTable) && this.wheres.stream().allMatch(WiqlWhereClause::isValid);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Select ");
        builder.append(SimpleWiqlBuilder.concatSelectFields(this.selectFields));
        builder.append(" from ");
        builder.append(this.fromTable);
        String whereClauses = SimpleWiqlBuilder.concatWhereClauses(this.wheres);
        if (!whereClauses.isEmpty()) {
            builder.append(" Where ");
            builder.append(whereClauses);
        }
        if (!this.orderBys.isEmpty()) {
            builder.append(" ORDER BY ");
            builder.append(SimpleWiqlBuilder.concatOrderBys(this.orderBys));
        }
        return builder.toString();
    }

    private static String concatSelectFields(Collection<String> selectFields) {
        return selectFields.stream().map(field -> "[" + field + "]").collect(Collectors.joining(", "));
    }

    private static String concatOrderBys(List<Pair<Boolean, String>> orderBys) {
        return orderBys.stream().map(pair -> SimpleWiqlBuilder.escapeFieldName((String)pair.getSecond()) + " " + SimpleWiqlBuilder.orderByToString((Boolean)pair.getFirst())).collect(Collectors.joining(", "));
    }

    private static String orderByToString(boolean ascending) {
        return ascending ? "Asc" : "Desc";
    }

    private static String concatWhereClauses(Collection<WiqlWhereClause> whereClauses) {
        return whereClauses.stream().filter(Predicate.not(WiqlWhereClause::isEmpty)).map(WiqlWhereClause::toWiqlString).collect(Collectors.joining(" AND "));
    }

    public static boolean isFieldNameValidForQuery(String fieldName) {
        return StringUtils.containsNone((CharSequence)fieldName, (char[])FORBIDDEN_FIELD_NAME_CHARACTERS);
    }

    public static boolean isValueValidForQuery(String value) {
        return StringUtils.containsNone((CharSequence)value, (String)"'\"");
    }

    static String escapeValue(String value) {
        value = StringUtils.remove((String)value, (String)"'");
        value = StringUtils.remove((String)value, (String)"\"");
        return "'" + value + "'";
    }

    static String escapeFieldName(String fieldName) {
        for (char forbiddenCharacter : FORBIDDEN_FIELD_NAME_CHARACTERS) {
            fieldName = StringUtils.remove((String)fieldName, (char)forbiddenCharacter);
        }
        return "[" + fieldName + "]";
    }
}

