/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeLabel;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtilsKt;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionWithNext;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.KtElementInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MergeInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.AbstractJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ConditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.InlinedLocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineSinkInstruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.PseudocodeTraverserKt;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.kotlin.com.google.common.collect.HashMultimap;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.com.intellij.util.containers.BidirectionalMap;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010L\u001a\u00020M2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010N\u001a\u00020M2\u0006\u0010\u001a\u001a\u00020\u0017J\u000e\u0010O\u001a\u00020M2\u0006\u0010P\u001a\u00020\u001eJ\u0010\u0010Q\u001a\u00020M2\u0006\u0010P\u001a\u00020RH\u0002J\u000e\u0010S\u001a\u00020M2\u0006\u0010G\u001a\u00020(J\u0018\u0010T\u001a\u00020M2\u0006\u0010U\u001a\u00020\u00112\u0006\u0010V\u001a\u00020\u001eH\u0002J\u0016\u0010W\u001a\u00020M2\u0006\u0010X\u001a\u00020\u00032\u0006\u0010U\u001a\u00020\u0011J\u000e\u0010Y\u001a\u00020M2\u0006\u0010Z\u001a\u00020*J\b\u0010[\u001a\u00020MH\u0002J\b\u0010\\\u001a\u00020MH\u0002J\b\u0010]\u001a\u00020\u0000H\u0016J$\u0010^\u001a\u00020\u001e2\u0006\u0010P\u001a\u00020\u001e2\u0012\u0010_\u001a\u000e\u0012\u0004\u0012\u00020a\u0012\u0004\u0012\u00020*0`H\u0002J0\u0010b\u001a\b\u0012\u0004\u0012\u00020a0K2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020a0c2\u0012\u0010_\u001a\u000e\u0012\u0004\u0012\u00020a\u0012\u0004\u0012\u00020*0`H\u0002J\u0018\u0010d\u001a\u00020*2\u0006\u0010e\u001a\u00020f2\b\u0010g\u001a\u0004\u0018\u00010fJ\u0014\u0010h\u001a\u0004\u0018\u00010\u00112\b\u0010X\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010i\u001a\u00020\u001e2\u0006\u0010j\u001a\u00020aH\u0002J\f\u0010k\u001a\b\u0012\u0004\u0012\u00020*0\"J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010l\u001a\u00020\u0001H\u0002J\u0016\u0010m\u001a\b\u0012\u0004\u0012\u00020\u00110,2\u0006\u0010U\u001a\u00020\u0011H\u0002J\u0010\u0010n\u001a\u00020\u001e2\u0006\u0010o\u001a\u00020pH\u0002J\u0018\u0010q\u001a\b\u0012\u0004\u0012\u00020\u001e0K2\b\u0010U\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010r\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\b\u0010U\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010s\u001a\u0004\u0018\u00010A2\u0006\u0010X\u001a\u00020\u0003H\u0016J\u0010\u0010t\u001a\u00020\u00052\u0006\u0010P\u001a\u00020\u001eH\u0016J\b\u0010u\u001a\u00020MH\u0002J\u0006\u0010v\u001a\u00020MJ,\u0010w\u001a\u00020p2\u0006\u0010x\u001a\u00020\u00002\b\u0010y\u001a\u0004\u0018\u00010a2\b\u0010z\u001a\u0004\u0018\u00010a2\u0006\u0010{\u001a\u00020pH\u0002J8\u0010|\u001a\u00020M2\u0006\u0010}\u001a\u00020\u001e2\u0012\u0010_\u001a\u000e\u0012\u0004\u0012\u00020a\u0012\u0004\u0012\u00020*0`2\u0012\u0010~\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020a0\u007fH\u0002J \u0010\u0080\u0001\u001a\u00020p2\u0006\u0010y\u001a\u00020a2\u0006\u0010z\u001a\u00020a2\u0007\u0010\u0081\u0001\u001a\u00020pJ\u0011\u0010\u0082\u0001\u001a\u00020M2\u0006\u0010x\u001a\u00020\u0000H\u0002J\u0015\u0010\u0083\u0001\u001a\u00020M*\u00020\u001e2\u0006\u0010o\u001a\u00020pH\u0002R$\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b.\u0010/R6\u00102\u001a*\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110,03j\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110,`4X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010 R\"\u00107\u001a\u0004\u0018\u00010\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u000e\u0010:\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010;\u001a\u0012\u0012\u0004\u0012\u00020\u001e0<j\b\u0012\u0004\u0012\u00020\u001e`=\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u001a\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020A03X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001e0\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010$R\u0014\u0010D\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u00109R\u001e\u0010F\u001a\u0012\u0012\u0004\u0012\u00020\u001e0<j\b\u0012\u0004\u0012\u00020\u001e`=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010G\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR6\u0010J\u001a*\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0K03j\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0K`4X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0084\u0001"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl;", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "correspondingElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isInlined", "", "(Lorg/jetbrains/kotlin/psi/KtElement;Z)V", "<set-?>", "containsDoWhile", "getContainsDoWhile", "()Z", "setContainsDoWhile$cfg", "(Z)V", "getCorrespondingElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "elementsToValues", "Lorg/jetbrains/kotlin/com/intellij/util/containers/BidirectionalMap;", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "enterInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineEnterInstruction;", "getEnterInstruction", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineEnterInstruction;", "errorInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineExitInstruction;", "getErrorInstruction", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineExitInstruction;", "exitInstruction", "getExitInstruction", "instructions", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "getInstructions", "()Ljava/util/ArrayList;", "instructionsIncludingDeadCode", "", "getInstructionsIncludingDeadCode", "()Ljava/util/List;", "internalErrorInstruction", "internalExitInstruction", "internalSinkInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineSinkInstruction;", "labels", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeLabel;", "localDeclarations", "", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/LocalFunctionDeclarationInstruction;", "getLocalDeclarations", "()Ljava/util/Set;", "localDeclarations$delegate", "Lkotlin/Lazy;", "mergedValues", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "mutableInstructionList", "getMutableInstructionList$cfg", "parent", "getParent", "()Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "postPrecessed", "reachableInstructions", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getReachableInstructions", "()Ljava/util/HashSet;", "representativeInstructions", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/KtElementInstruction;", "reversedInstructions", "getReversedInstructions", "rootPseudocode", "getRootPseudocode", "sideEffectFree", "sinkInstruction", "getSinkInstruction", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineSinkInstruction;", "valueUsages", "", "addErrorInstruction", "", "addExitInstruction", "addInstruction", "instruction", "addMergedValues", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MergeInstruction;", "addSinkInstruction", "addValueUsage", "value", "usage", "bindElementToValue", "element", "bindLabel", "label", "collectAndCacheReachableInstructions", "collectReachableInstructions", "copy", "copyInstruction", "originalToCopy", "", "Lorg/jetbrains/kotlin/cfg/Label;", "copyLabels", "", "createLabel", "name", "", "comment", "getElementValue", "getJumpTarget", "targetLabel", "getLabels", "pseudocode", "getMergedValues", "getNextPosition", "currentPosition", "", "getUsages", "getValueElements", "instructionForElement", "isSideEffectFree", "markDeadInstructions", "postProcess", "repeatInternal", "originalPseudocode", "startLabel", "finishLabel", "labelCountArg", "repeatLabelsBindingForInstruction", "originalInstruction", "originalLabelsForInstruction", "Lorg/jetbrains/kotlin/com/google/common/collect/Multimap;", "repeatPart", "labelCount", "repeatWhole", "processInstruction", "cfg"})
@SourceDebugExtension(value={"SMAP\nPseudocodeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PseudocodeImpl.kt\norg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,456:1\n372#2,7:457\n1855#3,2:464\n1#4:466\n*S KotlinDebug\n*F\n+ 1 PseudocodeImpl.kt\norg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl\n*L\n222#1:457,7\n331#1:464,2\n*E\n"})
public final class PseudocodeImpl
implements Pseudocode {
    @NotNull
    private final KtElement correspondingElement;
    private final boolean isInlined;
    @NotNull
    private final ArrayList<Instruction> mutableInstructionList;
    @NotNull
    private final ArrayList<Instruction> instructions;
    @NotNull
    private final BidirectionalMap<KtElement, PseudoValue> elementsToValues;
    @NotNull
    private final HashMap<PseudoValue, List<Instruction>> valueUsages;
    @NotNull
    private final HashMap<PseudoValue, Set<PseudoValue>> mergedValues;
    @NotNull
    private final HashSet<Instruction> sideEffectFree;
    @Nullable
    private Pseudocode parent;
    @NotNull
    private final Lazy localDeclarations$delegate;
    @NotNull
    private final HashSet<Instruction> reachableInstructions;
    @NotNull
    private final HashMap<KtElement, KtElementInstruction> representativeInstructions;
    @NotNull
    private final ArrayList<PseudocodeLabel> labels;
    @Nullable
    private SubroutineExitInstruction internalExitInstruction;
    @Nullable
    private SubroutineSinkInstruction internalSinkInstruction;
    @Nullable
    private SubroutineExitInstruction internalErrorInstruction;
    private boolean postPrecessed;
    private boolean containsDoWhile;

    public PseudocodeImpl(@NotNull KtElement correspondingElement, boolean isInlined) {
        Intrinsics.checkNotNullParameter(correspondingElement, "correspondingElement");
        this.correspondingElement = correspondingElement;
        this.isInlined = isInlined;
        this.mutableInstructionList = new ArrayList();
        this.instructions = new ArrayList();
        this.elementsToValues = new BidirectionalMap();
        this.valueUsages = new HashMap();
        this.mergedValues = new HashMap();
        this.sideEffectFree = new HashSet();
        this.localDeclarations$delegate = LazyKt.lazy((Function0)new Function0<Set<? extends LocalFunctionDeclarationInstruction>>(this){
            final /* synthetic */ PseudocodeImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<LocalFunctionDeclarationInstruction> invoke() {
                return PseudocodeImpl.access$getLocalDeclarations(this.this$0, this.this$0);
            }
        });
        this.reachableInstructions = new HashSet();
        this.representativeInstructions = new HashMap();
        this.labels = new ArrayList();
    }

    @Override
    @NotNull
    public KtElement getCorrespondingElement() {
        return this.correspondingElement;
    }

    @Override
    public boolean isInlined() {
        return this.isInlined;
    }

    @NotNull
    public final ArrayList<Instruction> getMutableInstructionList$cfg() {
        return this.mutableInstructionList;
    }

    @NotNull
    public ArrayList<Instruction> getInstructions() {
        return this.instructions;
    }

    @Override
    @Nullable
    public Pseudocode getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Set<LocalFunctionDeclarationInstruction> getLocalDeclarations() {
        Lazy lazy = this.localDeclarations$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final HashSet<Instruction> getReachableInstructions() {
        return this.reachableInstructions;
    }

    @Override
    @NotNull
    public SubroutineExitInstruction getExitInstruction() {
        SubroutineExitInstruction subroutineExitInstruction = this.internalExitInstruction;
        if (subroutineExitInstruction == null) {
            throw new AssertionError((Object)"Exit instruction is read before initialization");
        }
        return subroutineExitInstruction;
    }

    @Override
    @NotNull
    public SubroutineSinkInstruction getSinkInstruction() {
        SubroutineSinkInstruction subroutineSinkInstruction = this.internalSinkInstruction;
        if (subroutineSinkInstruction == null) {
            throw new AssertionError((Object)"Sink instruction is read before initialization");
        }
        return subroutineSinkInstruction;
    }

    @Override
    @NotNull
    public SubroutineExitInstruction getErrorInstruction() {
        SubroutineExitInstruction subroutineExitInstruction = this.internalErrorInstruction;
        if (subroutineExitInstruction == null) {
            throw new AssertionError((Object)"Error instruction is read before initialization");
        }
        return subroutineExitInstruction;
    }

    @Override
    public boolean getContainsDoWhile() {
        return this.containsDoWhile;
    }

    public void setContainsDoWhile$cfg(boolean bl) {
        this.containsDoWhile = bl;
    }

    private final Set<LocalFunctionDeclarationInstruction> getLocalDeclarations(Pseudocode pseudocode) {
        LinkedHashSet<Instruction> localDeclarations2 = new LinkedHashSet<Instruction>();
        Intrinsics.checkNotNull(pseudocode, "null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
        for (Instruction instruction : ((PseudocodeImpl)pseudocode).mutableInstructionList) {
            if (!(instruction instanceof LocalFunctionDeclarationInstruction)) continue;
            localDeclarations2.add(instruction);
            localDeclarations2.addAll((Collection)this.getLocalDeclarations(((LocalFunctionDeclarationInstruction)instruction).getBody()));
        }
        return localDeclarations2;
    }

    @Override
    @NotNull
    public Pseudocode getRootPseudocode() {
        for (Pseudocode parent2 = this.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            if (parent2.getParent() != null) continue;
            return parent2;
        }
        return this;
    }

    @NotNull
    public final PseudocodeLabel createLabel(@NotNull String name, @Nullable String comment) {
        Intrinsics.checkNotNullParameter(name, "name");
        PseudocodeLabel label = new PseudocodeLabel(this, name, comment);
        this.labels.add(label);
        return label;
    }

    @Override
    @NotNull
    public List<Instruction> getReversedInstructions() {
        LinkedHashSet traversedInstructions = new LinkedHashSet();
        PseudocodeTraverserKt.traverseFollowingInstructions(this.isInlined() ? (Instruction)CollectionsKt.last(this.getInstructions()) : (Instruction)this.getSinkInstruction(), traversedInstructions, TraversalOrder.BACKWARD, null);
        if (traversedInstructions.size() < ((ArrayList)this.getInstructions()).size()) {
            List<Instruction> simplyReversedInstructions = CollectionsKt.reversed(this.getInstructions());
            for (Instruction instruction : simplyReversedInstructions) {
                if (traversedInstructions.contains(instruction)) continue;
                PseudocodeTraverserKt.traverseFollowingInstructions(instruction, traversedInstructions, TraversalOrder.BACKWARD, null);
            }
        }
        return CollectionsKt.toList(traversedInstructions);
    }

    @Override
    @NotNull
    public List<Instruction> getInstructionsIncludingDeadCode() {
        return this.mutableInstructionList;
    }

    @NotNull
    public final List<PseudocodeLabel> getLabels() {
        return this.labels;
    }

    public final void addExitInstruction(@NotNull SubroutineExitInstruction exitInstruction) {
        boolean bl;
        Intrinsics.checkNotNullParameter(exitInstruction, "exitInstruction");
        this.addInstruction(exitInstruction);
        boolean bl2 = bl = this.internalExitInstruction == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Repeated initialization of exit instruction: " + this.internalExitInstruction + " --> " + exitInstruction;
            throw new AssertionError((Object)string2);
        }
        this.internalExitInstruction = exitInstruction;
    }

    public final void addSinkInstruction(@NotNull SubroutineSinkInstruction sinkInstruction) {
        boolean bl;
        Intrinsics.checkNotNullParameter(sinkInstruction, "sinkInstruction");
        this.addInstruction(sinkInstruction);
        boolean bl2 = bl = this.internalSinkInstruction == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Repeated initialization of sink instruction: " + this.internalSinkInstruction + " --> " + sinkInstruction;
            throw new AssertionError((Object)string2);
        }
        this.internalSinkInstruction = sinkInstruction;
    }

    public final void addErrorInstruction(@NotNull SubroutineExitInstruction errorInstruction) {
        boolean bl;
        Intrinsics.checkNotNullParameter(errorInstruction, "errorInstruction");
        this.addInstruction(errorInstruction);
        boolean bl2 = bl = this.internalErrorInstruction == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Repeated initialization of error instruction: " + this.internalErrorInstruction + " --> " + errorInstruction;
            throw new AssertionError((Object)string2);
        }
        this.internalErrorInstruction = errorInstruction;
    }

    public final void addInstruction(@NotNull Instruction instruction) {
        KtElement element;
        Intrinsics.checkNotNullParameter(instruction, "instruction");
        this.mutableInstructionList.add(instruction);
        instruction.setOwner(this);
        if (instruction instanceof KtElementInstruction && !this.representativeInstructions.containsKey(element = ((KtElementInstruction)instruction).getElement())) {
            ((Map)this.representativeInstructions).put(element, instruction);
        }
        if (instruction instanceof MergeInstruction) {
            this.addMergedValues((MergeInstruction)instruction);
        }
        for (PseudoValue inputValue : instruction.getInputValues()) {
            this.addValueUsage(inputValue, instruction);
            for (PseudoValue mergedValue : this.getMergedValues(inputValue)) {
                this.addValueUsage(mergedValue, instruction);
            }
        }
        if (PseudocodeUtilsKt.calcSideEffectFree(instruction)) {
            this.sideEffectFree.add(instruction);
        }
    }

    @Override
    @NotNull
    public SubroutineEnterInstruction getEnterInstruction() {
        Instruction instruction = this.mutableInstructionList.get(0);
        Intrinsics.checkNotNull(instruction, "null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction");
        return (SubroutineEnterInstruction)instruction;
    }

    @Override
    @Nullable
    public PseudoValue getElementValue(@Nullable KtElement element) {
        return this.elementsToValues.get(element);
    }

    @Override
    @NotNull
    public List<KtElement> getValueElements(@Nullable PseudoValue value2) {
        List<KtElement> list2 = this.elementsToValues.getKeysByValue(value2);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Instruction> getUsages(@Nullable PseudoValue value2) {
        List list2 = (List)((Map)this.valueUsages).get(value2);
        if (list2 == null) {
            list2 = new ArrayList();
        }
        return list2;
    }

    @Override
    public boolean isSideEffectFree(@NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter(instruction, "instruction");
        return this.sideEffectFree.contains(instruction);
    }

    public final void bindElementToValue(@NotNull KtElement element, @NotNull PseudoValue value2) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(value2, "value");
        this.elementsToValues.put(element, value2);
    }

    public final void bindLabel(@NotNull PseudocodeLabel label) {
        Intrinsics.checkNotNullParameter(label, "label");
        boolean bl = Intrinsics.areEqual(this, label.getPseudocode());
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Attempt to bind label " + label + " to instruction from different pseudocode: \nowner pseudocode = " + label.getPseudocode().mutableInstructionList + ", \nbound pseudocode = " + this.mutableInstructionList;
            throw new AssertionError((Object)string2);
        }
        label.setTargetInstructionIndex(this.mutableInstructionList.size());
    }

    private final Set<PseudoValue> getMergedValues(PseudoValue value2) {
        Set<PseudoValue> set = this.mergedValues.get(value2);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final void addMergedValues(MergeInstruction instruction) {
        LinkedHashSet<PseudoValue> result2 = new LinkedHashSet<PseudoValue>();
        for (PseudoValue value2 : instruction.getInputValues()) {
            result2.addAll((Collection)this.getMergedValues(value2));
            result2.add(value2);
        }
        this.mergedValues.put(instruction.getOutputValue(), result2);
    }

    private final void addValueUsage(PseudoValue value2, Instruction usage) {
        Object object;
        if (usage instanceof MergeInstruction) {
            return;
        }
        Map $this$getOrPut$iv = this.valueUsages;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(value2);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(value2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(usage);
    }

    public final void postProcess() {
        if (this.postPrecessed) {
            return;
        }
        this.postPrecessed = true;
        this.getErrorInstruction().setSink(this.getSinkInstruction());
        this.getExitInstruction().setSink(this.getSinkInstruction());
        Iterator<Instruction> iterator2 = this.mutableInstructionList.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            Instruction instruction = iterator2.next();
            this.processInstruction(instruction, index2);
        }
        this.collectAndCacheReachableInstructions();
    }

    private final void collectAndCacheReachableInstructions() {
        this.collectReachableInstructions();
        for (Instruction instruction : this.mutableInstructionList) {
            if (!this.reachableInstructions.contains(instruction)) continue;
            ((ArrayList)this.getInstructions()).add(instruction);
        }
        this.markDeadInstructions();
    }

    private final void processInstruction(Instruction $this$processInstruction, int currentPosition) {
        $this$processInstruction.accept(new InstructionVisitor(this, currentPosition){
            final /* synthetic */ PseudocodeImpl this$0;
            final /* synthetic */ int $currentPosition;
            {
                this.this$0 = $receiver;
                this.$currentPosition = $currentPosition;
            }

            public void visitInstructionWithNext(@NotNull InstructionWithNext instruction) {
                Intrinsics.checkNotNullParameter(instruction, "instruction");
                instruction.setNext(PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition));
            }

            public void visitJump(@NotNull AbstractJumpInstruction instruction) {
                Intrinsics.checkNotNullParameter(instruction, "instruction");
                instruction.setResolvedTarget(PseudocodeImpl.access$getJumpTarget(this.this$0, instruction.getTargetLabel()));
            }

            public void visitNondeterministicJump(@NotNull NondeterministicJumpInstruction instruction) {
                Intrinsics.checkNotNullParameter(instruction, "instruction");
                instruction.setNext(PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition));
                List<Label> targetLabels = instruction.getTargetLabels();
                for (Label targetLabel : targetLabels) {
                    instruction.setResolvedTarget(targetLabel, PseudocodeImpl.access$getJumpTarget(this.this$0, targetLabel));
                }
            }

            public void visitConditionalJump(@NotNull ConditionalJumpInstruction instruction) {
                Intrinsics.checkNotNullParameter(instruction, "instruction");
                Instruction nextInstruction = PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition);
                Instruction jumpTarget = PseudocodeImpl.access$getJumpTarget(this.this$0, instruction.getTargetLabel());
                if (instruction.getOnTrue()) {
                    instruction.setNextOnFalse(nextInstruction);
                    instruction.setNextOnTrue(jumpTarget);
                } else {
                    instruction.setNextOnFalse(jumpTarget);
                    instruction.setNextOnTrue(nextInstruction);
                }
                this.visitJump(instruction);
            }

            public void visitLocalFunctionDeclarationInstruction(@NotNull LocalFunctionDeclarationInstruction instruction) {
                Intrinsics.checkNotNullParameter(instruction, "instruction");
                Pseudocode pseudocode = instruction.getBody();
                Intrinsics.checkNotNull(pseudocode, "null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
                PseudocodeImpl body2 = (PseudocodeImpl)pseudocode;
                PseudocodeImpl.access$setParent$p(body2, this.this$0);
                body2.postProcess();
                instruction.setNext(this.this$0.getSinkInstruction());
            }

            public void visitInlinedLocalFunctionDeclarationInstruction(@NotNull InlinedLocalFunctionDeclarationInstruction instruction) {
                Intrinsics.checkNotNullParameter(instruction, "instruction");
                Pseudocode pseudocode = instruction.getBody();
                Intrinsics.checkNotNull(pseudocode, "null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
                PseudocodeImpl body2 = (PseudocodeImpl)pseudocode;
                PseudocodeImpl.access$setParent$p(body2, this.this$0);
                body2.postProcess();
                instruction.setNext(((ArrayList)body2.getInstructions()).contains(body2.getExitInstruction()) ? PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition) : (Instruction)this.this$0.getSinkInstruction());
            }

            public void visitSubroutineExit(@NotNull SubroutineExitInstruction instruction) {
                Intrinsics.checkNotNullParameter(instruction, "instruction");
            }

            public void visitSubroutineSink(@NotNull SubroutineSinkInstruction instruction) {
                Intrinsics.checkNotNullParameter(instruction, "instruction");
            }

            public void visitInstruction(@NotNull Instruction instruction) {
                Intrinsics.checkNotNullParameter(instruction, "instruction");
                throw new UnsupportedOperationException(instruction.toString());
            }
        });
    }

    private final void collectReachableInstructions() {
        HashSet<InstructionImpl> reachableFromThisPseudocode = new HashSet<InstructionImpl>();
        PseudocodeTraverserKt.traverseFollowingInstructions(this.getEnterInstruction(), (Set<Instruction>)reachableFromThisPseudocode, TraversalOrder.FORWARD, collectReachableInstructions.1.INSTANCE);
        if (!this.isInlined()) {
            reachableFromThisPseudocode.add(this.getExitInstruction());
            reachableFromThisPseudocode.add(this.getErrorInstruction());
            reachableFromThisPseudocode.add(this.getSinkInstruction());
        }
        Iterable $this$forEach$iv = reachableFromThisPseudocode;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Instruction it = (Instruction)element$iv;
            boolean bl = false;
            Pseudocode pseudocode = it.getOwner();
            Intrinsics.checkNotNull(pseudocode, "null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
            ((PseudocodeImpl)pseudocode).reachableInstructions.add(it);
        }
    }

    private final void markDeadInstructions() {
        HashSet instructionSet = CollectionsKt.toHashSet(this.getInstructions());
        for (Instruction instruction : this.mutableInstructionList) {
            if (instructionSet.contains(instruction)) continue;
            InstructionImpl instructionImpl = instruction instanceof InstructionImpl ? (InstructionImpl)instruction : null;
            if (instructionImpl != null) {
                instructionImpl.setMarkedAsDead(true);
            }
            for (Instruction nextInstruction : instruction.getNextInstructions()) {
                Object object = nextInstruction instanceof InstructionImpl ? (InstructionImpl)nextInstruction : null;
                if (object == null || (object = ((InstructionImpl)object).getPreviousInstructions()) == null) continue;
                object.remove(instruction);
            }
        }
    }

    private final Instruction getJumpTarget(Label targetLabel) {
        return targetLabel.resolveToInstruction();
    }

    private final Instruction getNextPosition(int currentPosition) {
        boolean bl;
        int targetPosition = currentPosition + 1;
        boolean bl2 = bl = targetPosition < this.mutableInstructionList.size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            Integer n = currentPosition;
            throw new AssertionError(n);
        }
        Instruction instruction = this.mutableInstructionList.get(targetPosition);
        Intrinsics.checkNotNullExpressionValue(instruction, "get(...)");
        return instruction;
    }

    @Override
    @NotNull
    public PseudocodeImpl copy() {
        PseudocodeImpl result2 = new PseudocodeImpl(this.getCorrespondingElement(), this.isInlined());
        result2.repeatWhole(this);
        return result2;
    }

    @Override
    @Nullable
    public KtElementInstruction instructionForElement(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this.representativeInstructions.get(element);
    }

    private final void repeatWhole(PseudocodeImpl originalPseudocode) {
        this.repeatInternal(originalPseudocode, null, null, 0);
        this.parent = originalPseudocode.getParent();
    }

    public final int repeatPart(@NotNull Label startLabel, @NotNull Label finishLabel, int labelCount) {
        Intrinsics.checkNotNullParameter(startLabel, "startLabel");
        Intrinsics.checkNotNullParameter(finishLabel, "finishLabel");
        Pseudocode pseudocode = startLabel.getPseudocode();
        Intrinsics.checkNotNull(pseudocode, "null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
        return this.repeatInternal((PseudocodeImpl)pseudocode, startLabel, finishLabel, labelCount);
    }

    private final int repeatInternal(PseudocodeImpl originalPseudocode, Label startLabel, Label finishLabel, int labelCountArg) {
        int labelCount = labelCountArg;
        Label label = startLabel;
        int startIndex = label != null ? label.getTargetInstructionIndex() : 0;
        Label label2 = finishLabel;
        int finishIndex = label2 != null ? label2.getTargetInstructionIndex() : originalPseudocode.mutableInstructionList.size();
        LinkedHashMap<PseudocodeLabel, PseudocodeLabel> originalToCopy = new LinkedHashMap<PseudocodeLabel, PseudocodeLabel>();
        HashMultimap originalLabelsForInstruction = HashMultimap.create();
        for (PseudocodeLabel label3 : originalPseudocode.labels) {
            int index2 = label3.getTargetInstructionIndex();
            if (index2 < 0 || label3 == startLabel || label3 == finishLabel) continue;
            boolean bl = startIndex <= index2 ? index2 <= finishIndex : false;
            if (!bl) continue;
            originalToCopy.put(label3, label3.copy(this, labelCount++));
            Intrinsics.checkNotNull(label3);
            originalLabelsForInstruction.put(this.getJumpTarget(label3), label3);
        }
        for (PseudocodeLabel label3 : originalToCopy.values()) {
            this.labels.add(label3);
        }
        for (int index3 = startIndex; index3 < finishIndex; ++index3) {
            Instruction originalInstruction;
            Intrinsics.checkNotNullExpressionValue(originalPseudocode.mutableInstructionList.get(index3), "get(...)");
            Map map = originalToCopy;
            Intrinsics.checkNotNull(originalLabelsForInstruction);
            this.repeatLabelsBindingForInstruction(originalInstruction, map, originalLabelsForInstruction);
            Instruction copy2 = this.copyInstruction(originalInstruction, (Map<Label, PseudocodeLabel>)originalToCopy);
            this.addInstruction(copy2);
            if (originalInstruction == originalPseudocode.internalErrorInstruction && copy2 instanceof SubroutineExitInstruction) {
                this.internalErrorInstruction = (SubroutineExitInstruction)copy2;
            }
            if (originalInstruction == originalPseudocode.internalExitInstruction && copy2 instanceof SubroutineExitInstruction) {
                this.internalExitInstruction = (SubroutineExitInstruction)copy2;
            }
            if (originalInstruction != originalPseudocode.internalSinkInstruction || !(copy2 instanceof SubroutineSinkInstruction)) continue;
            this.internalSinkInstruction = (SubroutineSinkInstruction)copy2;
        }
        if (finishIndex < originalPseudocode.mutableInstructionList.size()) {
            Instruction instruction = originalPseudocode.mutableInstructionList.get(finishIndex);
            Intrinsics.checkNotNullExpressionValue(instruction, "get(...)");
            Map map = originalToCopy;
            Intrinsics.checkNotNull(originalLabelsForInstruction);
            this.repeatLabelsBindingForInstruction(instruction, map, originalLabelsForInstruction);
        }
        return labelCount;
    }

    private final void repeatLabelsBindingForInstruction(Instruction originalInstruction, Map<Label, PseudocodeLabel> originalToCopy, Multimap<Instruction, Label> originalLabelsForInstruction) {
        for (Label originalLabel : originalLabelsForInstruction.get(originalInstruction)) {
            PseudocodeLabel pseudocodeLabel = originalToCopy.get(originalLabel);
            Intrinsics.checkNotNull(pseudocodeLabel);
            this.bindLabel(pseudocodeLabel);
        }
    }

    private final Instruction copyInstruction(Instruction instruction, Map<Label, PseudocodeLabel> originalToCopy) {
        Label originalTarget;
        PseudocodeLabel item;
        if (instruction instanceof AbstractJumpInstruction && (item = originalToCopy.get(originalTarget = ((AbstractJumpInstruction)instruction).getTargetLabel())) != null) {
            return ((AbstractJumpInstruction)instruction).copy(item);
        }
        if (instruction instanceof NondeterministicJumpInstruction) {
            List<Label> originalTargets = ((NondeterministicJumpInstruction)instruction).getTargetLabels();
            List<Label> copyTargets = this.copyLabels((Collection<? extends Label>)originalTargets, originalToCopy);
            return ((NondeterministicJumpInstruction)instruction).copy(copyTargets);
        }
        Intrinsics.checkNotNull(instruction, "null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl");
        return ((InstructionImpl)instruction).copy();
    }

    private final List<Label> copyLabels(Collection<? extends Label> labels2, Map<Label, PseudocodeLabel> originalToCopy) {
        ArrayList<Label> newLabels = new ArrayList<Label>();
        for (Label label : labels2) {
            PseudocodeLabel newLabel;
            PseudocodeLabel pseudocodeLabel = newLabel = originalToCopy.get(label);
            newLabels.add(pseudocodeLabel != null ? (Label)pseudocodeLabel : label);
        }
        return newLabels;
    }

    public static final /* synthetic */ Instruction access$getNextPosition(PseudocodeImpl $this, int currentPosition) {
        return $this.getNextPosition(currentPosition);
    }

    public static final /* synthetic */ Instruction access$getJumpTarget(PseudocodeImpl $this, Label targetLabel) {
        return $this.getJumpTarget(targetLabel);
    }

    public static final /* synthetic */ void access$setParent$p(PseudocodeImpl $this, Pseudocode pseudocode) {
        $this.parent = pseudocode;
    }

    public static final /* synthetic */ Set access$getLocalDeclarations(PseudocodeImpl $this, Pseudocode pseudocode) {
        return $this.getLocalDeclarations(pseudocode);
    }
}

