/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.lang.ref.Reference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Getter;
import org.jetbrains.kotlin.com.intellij.openapi.util.ModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProfiler;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.CachedValueImpl;
import org.jetbrains.kotlin.com.intellij.util.IdempotenceChecker;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.NotNullList;

public abstract class CachedValueBase<T> {
    private static final Logger LOG = Logger.getInstance(CachedValueImpl.class);
    private final boolean myTrackValue;
    private volatile SoftReference<Data<T>> myData;

    protected CachedValueBase(boolean trackValue) {
        this.myTrackValue = trackValue;
    }

    @NotNull
    private Data<T> computeData(Computable<? extends CachedValueProvider.Result<T>> doCompute) {
        CachedValueProfiler.ValueTracker tracker;
        CachedValueProvider.Result<T> result2;
        if (CachedValueProfiler.isProfiling()) {
            try (CachedValueProfiler.Frame frame = CachedValueProfiler.newFrame();){
                result2 = doCompute.compute();
                tracker = frame.newValueTracker(result2);
            }
        } else {
            result2 = doCompute.compute();
            tracker = null;
        }
        if (result2 == null) {
            return new Data<Object>(null, ArrayUtilRt.EMPTY_OBJECT_ARRAY, ArrayUtil.EMPTY_LONG_ARRAY, null);
        }
        T value2 = result2.getValue();
        Object[] inferredDependencies = this.normalizeDependencies(result2);
        long[] inferredTimeStamps = new long[inferredDependencies.length];
        for (int i = 0; i < inferredDependencies.length; ++i) {
            inferredTimeStamps[i] = this.getTimeStamp(inferredDependencies[i]);
        }
        return new Data<T>(value2, inferredDependencies, inferredTimeStamps, tracker);
    }

    @Nullable
    private synchronized Data<T> cacheOrGetData(@Nullable Data<T> expected, @Nullable Data<T> updatedValue) {
        if (expected != this.getRawData()) {
            return null;
        }
        if (updatedValue != null) {
            this.setData(updatedValue);
            return updatedValue;
        }
        return expected;
    }

    private synchronized void setData(@Nullable Data<T> data2) {
        this.myData = data2 == null ? null : new SoftReference<Data<Data<Data<Data<T>>>>>(data2);
    }

    protected Object @NotNull [] normalizeDependencies(@NotNull CachedValueProvider.Result<T> result2) {
        if (result2 == null) {
            CachedValueBase.$$$reportNull$$$0(0);
        }
        Object[] items2 = result2.getDependencyItems();
        T value2 = result2.getValue();
        Object[] rawDependencies = this.myTrackValue && value2 != null ? ArrayUtil.append(items2, value2) : items2;
        NotNullList<Object> flattened = new NotNullList<Object>(rawDependencies.length);
        CachedValueBase.collectDependencies(flattened, rawDependencies);
        Object[] objectArray = ArrayUtil.toObjectArray(flattened);
        if (objectArray == null) {
            CachedValueBase.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public void clear() {
        this.setData(null);
    }

    public boolean hasUpToDateValue() {
        return this.getUpToDateOrNull() != null;
    }

    @Nullable
    public final Data<T> getUpToDateOrNull() {
        Data<T> data2 = this.getRawData();
        return data2 != null && this.checkUpToDate(data2) ? data2 : null;
    }

    private boolean checkUpToDate(@NotNull Data<T> data2) {
        if (data2 == null) {
            CachedValueBase.$$$reportNull$$$0(2);
        }
        if (this.isUpToDate(data2)) {
            return true;
        }
        if (data2.trackingInfo != null) {
            data2.trackingInfo.onValueInvalidated();
        }
        return false;
    }

    @Nullable
    private Data<T> getRawData() {
        return SoftReference.dereference(this.myData);
    }

    protected boolean isUpToDate(@NotNull Data<T> data2) {
        if (data2 == null) {
            CachedValueBase.$$$reportNull$$$0(3);
        }
        for (int i = 0; i < ((Data)data2).myDependencies.length; ++i) {
            Object dependency = ((Data)data2).myDependencies[i];
            if (!this.isDependencyOutOfDate(dependency, ((Data)data2).myTimeStamps[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isDependencyOutOfDate(@NotNull Object dependency, long oldTimeStamp) {
        if (dependency == null) {
            CachedValueBase.$$$reportNull$$$0(4);
        }
        if (dependency instanceof CachedValueBase) {
            return !((CachedValueBase)dependency).hasUpToDateValue();
        }
        long timeStamp = this.getTimeStamp(dependency);
        return timeStamp < 0L || timeStamp != oldTimeStamp;
    }

    private static void collectDependencies(@NotNull List<Object> resultingDeps, Object @NotNull [] dependencies) {
        if (resultingDeps == null) {
            CachedValueBase.$$$reportNull$$$0(5);
        }
        if (dependencies == null) {
            CachedValueBase.$$$reportNull$$$0(6);
        }
        for (Object dependency : dependencies) {
            if (dependency == ObjectUtils.NULL) continue;
            if (dependency instanceof Object[]) {
                CachedValueBase.collectDependencies(resultingDeps, (Object[])dependency);
                continue;
            }
            resultingDeps.add(dependency);
        }
    }

    protected long getTimeStamp(@NotNull Object dependency) {
        if (dependency == null) {
            CachedValueBase.$$$reportNull$$$0(7);
        }
        if (dependency instanceof VirtualFile) {
            return ((VirtualFile)dependency).getModificationStamp();
        }
        if (dependency instanceof ModificationTracker) {
            return ((ModificationTracker)dependency).getModificationCount();
        }
        if (dependency instanceof Reference) {
            Object original = ((Reference)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Ref) {
            Object original = ((Ref)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Document) {
            return ((Document)dependency).getModificationStamp();
        }
        if (dependency instanceof CachedValueBase) {
            return 0L;
        }
        LOG.error("Wrong dependency type: " + dependency.getClass());
        return -1L;
    }

    public T setValue(@NotNull CachedValueProvider.Result<T> result2) {
        if (result2 == null) {
            CachedValueBase.$$$reportNull$$$0(8);
        }
        Data<T> data2 = this.computeData(() -> result2);
        this.setData(data2);
        return data2.getValue();
    }

    public abstract boolean isFromMyProject(@NotNull Project var1);

    public abstract Object getValueProvider();

    @Nullable
    protected <P> T getValueWithLock(P param) {
        Data data2 = this.getUpToDateOrNull();
        if (data2 != null) {
            if (IdempotenceChecker.areRandomChecksEnabled()) {
                IdempotenceChecker.applyForRandomCheck(data2, this.getValueProvider(), () -> this.computeData(() -> this.doCompute(param)));
            }
            return data2.getValue();
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        Computable<Data> calcData = () -> this.computeData(() -> this.doCompute(param));
        data2 = RecursionManager.doPreventingRecursion(this, true, calcData);
        if (data2 == null) {
            data2 = calcData.compute();
        } else if (stamp.mayCacheNow()) {
            boolean reuse;
            Data<T> alreadyComputed;
            Data<T> toReturn;
            do {
                boolean bl = reuse = (alreadyComputed = this.getRawData()) != null && this.checkUpToDate(alreadyComputed);
                if (!reuse) continue;
                IdempotenceChecker.checkEquivalence(alreadyComputed, data2, this.getValueProvider().getClass(), calcData);
            } while ((toReturn = this.cacheOrGetData(alreadyComputed, reuse ? null : data2)) == null);
            if (data2 != toReturn && data2.trackingInfo != null) {
                data2.trackingInfo.onValueRejected();
            }
            return toReturn.getValue();
        }
        return data2.getValue();
    }

    protected abstract <P> CachedValueProvider.Result<T> doCompute(P var1);

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.getValueProvider() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/CachedValueBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultingDeps";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/CachedValueBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "normalizeDependencies";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkUpToDate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyOutOfDate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class Data<T>
    implements Getter<T> {
        private final T myValue;
        private final Object @NotNull [] myDependencies;
        private final long @NotNull [] myTimeStamps;
        @Nullable
        final CachedValueProfiler.ValueTracker trackingInfo;

        Data(T value2, Object @NotNull [] dependencies, long @NotNull [] timeStamps, @Nullable CachedValueProfiler.ValueTracker trackingInfo) {
            if (dependencies == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (timeStamps == null) {
                Data.$$$reportNull$$$0(1);
            }
            this.myValue = value2;
            this.myDependencies = dependencies;
            this.myTimeStamps = timeStamps;
            this.trackingInfo = trackingInfo;
        }

        public Object @NotNull [] getDependencies() {
            if (this.myDependencies == null) {
                Data.$$$reportNull$$$0(2);
            }
            return this.myDependencies;
        }

        public long @NotNull [] getTimeStamps() {
            if (this.myTimeStamps == null) {
                Data.$$$reportNull$$$0(3);
            }
            return this.myTimeStamps;
        }

        @Override
        public T get() {
            return this.getValue();
        }

        public T getValue() {
            if (this.trackingInfo != null) {
                this.trackingInfo.onValueUsed();
            }
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timeStamps";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/CachedValueBase$Data";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/CachedValueBase$Data";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTimeStamps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

