/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.externalreport.detekt;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.kotlin.api.frontend.AbstractPropertyHandlerSensor;
import org.sonarsource.kotlin.externalreport.common.CheckstyleFormatImporterWithRuleLoader;
import org.sonarsource.kotlin.externalreport.detekt.DetektRulesDefinition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/sonarsource/kotlin/externalreport/detekt/DetektSensor;", "Lorg/sonarsource/kotlin/api/frontend/AbstractPropertyHandlerSensor;", "analysisWarnings", "Lorg/sonar/api/notifications/AnalysisWarnings;", "(Lorg/sonar/api/notifications/AnalysisWarnings;)V", "reportConsumer", "Lkotlin/Function1;", "Ljava/io/File;", "", "context", "Lorg/sonar/api/batch/sensor/SensorContext;", "Companion", "sonar-kotlin-external-linters"})
public final class DetektSensor
extends AbstractPropertyHandlerSensor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOG = LoggerFactory.getLogger(DetektSensor.class);
    @NotNull
    public static final String LINTER_KEY = "detekt";
    @NotNull
    public static final String LINTER_NAME = "detekt";
    @NotNull
    private static final String DETEKT_PREFIX = "detekt.";
    @NotNull
    public static final String REPORT_PROPERTY_KEY = "sonar.kotlin.detekt.reportPaths";

    public DetektSensor(@NotNull AnalysisWarnings analysisWarnings) {
        Intrinsics.checkNotNullParameter(analysisWarnings, "analysisWarnings");
        super(analysisWarnings, "detekt", "detekt", REPORT_PROPERTY_KEY, "kotlin");
    }

    @Override
    @NotNull
    public Function1<File, Unit> reportConsumer(@NotNull SensorContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        return new Function1<File, Unit>(context){
            final /* synthetic */ SensorContext $context;
            {
                this.$context = $context;
                super(1);
            }

            public final void invoke(@NotNull File reportPath) {
                Intrinsics.checkNotNullParameter(reportPath, "reportPath");
                new Companion.ReportImporter(this.$context).importFile(reportPath);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/sonarsource/kotlin/externalreport/detekt/DetektSensor$Companion;", "", "()V", "DETEKT_PREFIX", "", "LINTER_KEY", "LINTER_NAME", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "REPORT_PROPERTY_KEY", "ReportImporter", "sonar-kotlin-external-linters"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/sonarsource/kotlin/externalreport/detekt/DetektSensor$Companion$ReportImporter;", "Lorg/sonarsource/kotlin/externalreport/common/CheckstyleFormatImporterWithRuleLoader;", "context", "Lorg/sonar/api/batch/sensor/SensorContext;", "(Lorg/sonar/api/batch/sensor/SensorContext;)V", "createRuleKey", "Lorg/sonar/api/rule/RuleKey;", "source", "", "sonar-kotlin-external-linters"})
        private static final class ReportImporter
        extends CheckstyleFormatImporterWithRuleLoader {
            public ReportImporter(@NotNull SensorContext context) {
                Intrinsics.checkNotNullParameter(context, "context");
                super(context, "detekt", DetektRulesDefinition.Companion.getRULE_LOADER());
            }

            @Override
            @Nullable
            protected RuleKey createRuleKey(@NotNull String source) {
                Intrinsics.checkNotNullParameter(source, "source");
                if (!StringsKt.startsWith$default(source, DetektSensor.DETEKT_PREFIX, false, 2, null)) {
                    LOG.debug("Unexpected rule key without '{}' suffix: '{}'", (Object)DetektSensor.DETEKT_PREFIX, (Object)source);
                    return null;
                }
                String string2 = source.substring(7);
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                String preliminaryRuleKey = string2;
                String ruleKey = DetektRulesDefinition.Companion.getRULE_LOADER().ruleKeys().contains(preliminaryRuleKey) ? preliminaryRuleKey : "external.catchall";
                return super.createRuleKey(ruleKey);
            }
        }
    }
}

