/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.gradle.checks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.MessageKt;
import org.sonarsource.kotlin.gradle.checks.RootProjectNamePresentCheck;
import org.sonarsource.kotlin.gradle.checks.RootProjectNamePresentCheckKt;

@Rule(key="S6625")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/gradle/checks/RootProjectNamePresentCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "ScanRootProjectNameAssign", "sonar-kotlin-gradle"})
public final class RootProjectNamePresentCheck
extends AbstractCheck {
    @Override
    public void visitKtFile(@NotNull KtFile file2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        String string2 = file2.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        if (!StringsKt.endsWith$default(string2, "settings.gradle.kts", false, 2, null)) {
            return;
        }
        ScanRootProjectNameAssign visitor2 = new ScanRootProjectNameAssign();
        file2.acceptChildren(visitor2);
        if (!visitor2.isRootProjectNameAssigned()) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, null, MessageKt.message(visitKtFile.1.INSTANCE), null, null, 12, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/sonarsource/kotlin/gradle/checks/RootProjectNamePresentCheck$ScanRootProjectNameAssign;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "()V", "isRootProjectNameAssigned", "", "()Z", "setRootProjectNameAssigned", "(Z)V", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "sonar-kotlin-gradle"})
    private static final class ScanRootProjectNameAssign
    extends KtTreeVisitorVoid {
        private boolean isRootProjectNameAssigned;

        public final boolean isRootProjectNameAssigned() {
            return this.isRootProjectNameAssigned;
        }

        public final void setRootProjectNameAssigned(boolean bl) {
            this.isRootProjectNameAssigned = bl;
        }

        @Override
        public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            if (!Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.EQ)) {
                return;
            }
            KtExpression ktExpression = expression2.getLeft();
            KtDotQualifiedExpression ktDotQualifiedExpression = ktExpression instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)ktExpression : null;
            if (ktDotQualifiedExpression == null) {
                return;
            }
            KtDotQualifiedExpression qualifier = ktDotQualifiedExpression;
            KtExpression ktExpression2 = qualifier.getReceiverExpression();
            KtNameReferenceExpression ktNameReferenceExpression = ktExpression2 instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression2 : null;
            if (ktNameReferenceExpression == null) {
                return;
            }
            KtNameReferenceExpression receiver = ktNameReferenceExpression;
            KtExpression ktExpression3 = qualifier.getSelectorExpression();
            KtNameReferenceExpression ktNameReferenceExpression2 = ktExpression3 instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression3 : null;
            if (ktNameReferenceExpression2 == null) {
                return;
            }
            KtNameReferenceExpression selector = ktNameReferenceExpression2;
            if (Intrinsics.areEqual(receiver.getReferencedName(), "rootProject") && Intrinsics.areEqual(selector.getReferencedName(), "name")) {
                this.isRootProjectNameAssigned = true;
            }
        }

        @Override
        public void visitCallExpression(@NotNull KtCallExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            PsiElement psiElement = expression2.getParent();
            KtDotQualifiedExpression ktDotQualifiedExpression = psiElement instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null;
            if (ktDotQualifiedExpression == null) {
                return;
            }
            KtDotQualifiedExpression qualifier = ktDotQualifiedExpression;
            KtExpression ktExpression = PsiUtilsKt.getCalleeExpressionIfAny(expression2);
            if (Intrinsics.areEqual(ktExpression != null ? RootProjectNamePresentCheckKt.access$getReferencedName(ktExpression) : null, "setName") && Intrinsics.areEqual(RootProjectNamePresentCheckKt.access$getReferencedName(qualifier.getReceiverExpression()), "rootProject")) {
                this.isRootProjectNameAssigned = true;
            }
        }
    }
}

