/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.simulink.builder.SimulinkPortBuilder;
import org.conqat.lib.simulink.model.FlexiblePortPlacementParameters;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jspecify.annotations.Nullable;

public class FlexiblePortPlacementParser {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int NOT_FOUND = -1;

    public static FlexiblePortPlacementParameters getSimulinkPortSchemaEntryForPort(SimulinkPortBuilder.EPortType portType, int portNumber, JsonNode portSchema, SimulinkBlock simulinkBlock) {
        Optional<JsonNode> sides;
        String expectedConnectorId;
        if (portSchema == null) {
            return null;
        }
        if (portType == SimulinkPortBuilder.EPortType.INPORT) {
            expectedConnectorId = "In" + portNumber;
        } else if (portType == SimulinkPortBuilder.EPortType.OUTPORT) {
            expectedConnectorId = "Out" + portNumber;
        } else {
            return null;
        }
        String version = Optional.ofNullable(portSchema.get("version")).map(JsonNode::asText).orElse(null);
        if (!"1.0".equals(version)) {
            LOGGER.warn("Found unknown Simulink PortSchema version " + version + " in " + SimulinkUtils.buildBlockLocationForErrorReporting(simulinkBlock));
        }
        if (!(sides = Optional.ofNullable(portSchema.get("entries")).map(x -> x.get(0)).map(x -> x.get("content")).map(x -> x.get("sides"))).isPresent()) {
            LOGGER.error("Unexpected Simulink PortSchema on " + SimulinkUtils.buildBlockLocationForErrorReporting(simulinkBlock));
            return null;
        }
        return FlexiblePortPlacementParser.findSideContainingExpectedConnectorId(expectedConnectorId, sides.get(), simulinkBlock);
    }

    private static @Nullable FlexiblePortPlacementParameters findSideContainingExpectedConnectorId(String expectedConnectorId, JsonNode sides, SimulinkBlock simulinkBlock) {
        for (JsonNode entry : sides) {
            Optional<FlexiblePortPlacementParameters.EFlexiblePortPlacementSideName> side;
            int indexOnSide;
            JsonNode sideEntryContent = entry.get("content");
            JsonNode connectorIdsOnSide = sideEntryContent.get("connectorIds");
            if (connectorIdsOnSide == null || (indexOnSide = FlexiblePortPlacementParser.findConnectorIdOnSide(expectedConnectorId, connectorIdsOnSide)) == -1) continue;
            Optional<String> sideProperty = Optional.ofNullable(sideEntryContent.get("side")).map(JsonNode::asText);
            if (!sideProperty.isPresent()) {
                side = Optional.of(FlexiblePortPlacementParameters.EFlexiblePortPlacementSideName.LEFT);
            } else {
                side = FlexiblePortPlacementParameters.EFlexiblePortPlacementSideName.getSide(sideProperty.get());
                if (!side.isPresent()) {
                    LOGGER.error("Unknown port side " + String.valueOf(sideProperty) + " in flexible port placement in " + SimulinkUtils.buildBlockLocationForErrorReporting(simulinkBlock));
                    return null;
                }
            }
            String type = Optional.ofNullable(entry.get("type")).map(JsonNode::asText).orElse(null);
            if (!"ConnectorPlacement.EquallySpacedRectSide".equals(type)) {
                LOGGER.warn("Found unknown Simulink PortSchema connector type " + type + " in " + SimulinkUtils.buildBlockLocationForErrorReporting(simulinkBlock));
            }
            return new FlexiblePortPlacementParameters(side.get(), indexOnSide, connectorIdsOnSide.size(), type);
        }
        return null;
    }

    private static int findConnectorIdOnSide(String expectedConnectorId, JsonNode connectorIdsOnSide) {
        for (int idPosition = 0; idPosition < connectorIdsOnSide.size(); ++idPosition) {
            JsonNode connectorIdNode = connectorIdsOnSide.get(idPosition);
            if (!connectorIdNode.asText().equals(expectedConnectorId)) continue;
            return idPosition;
        }
        return -1;
    }
}

