/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;

@IndexValueClass
public class MatlabVariable
implements ISimulinkDataDictionaryEntry {
    private static final long serialVersionUID = 1L;
    public final String name;
    public final String rawDataType;
    private final String sanitizedDataType;
    public final int[] dimensions;
    public final String value;

    public MatlabVariable(String name, String type, int[] dimensions, String value) {
        this.name = name;
        this.rawDataType = type;
        this.sanitizedDataType = SimulinkDataTypeUtils.sanitizeTypeFromSimulinkModel(type, true);
        this.dimensions = dimensions;
        this.value = value;
    }

    public String toString() {
        return this.getEntryType() + " " + this.name;
    }

    @Override
    public String getEntryType() {
        return "MatlabVariable";
    }

    @Override
    public String getDataType() {
        return this.sanitizedDataType;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

