/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.conqat.lib.simulink.builder.MutableMDLSection;
import org.conqat.lib.simulink.builder.SimulinkPortBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SLXDefaultHandlerBase
extends DefaultHandler {
    public static final String XML_TEXT_CONTENT_PARAMETER_NAME = "Teamscale_XML_Text_Content";
    protected final Deque<MutableMDLSection> stack = new ArrayDeque<MutableMDLSection>();
    protected Locator locator;
    protected MutableMDLSection rootSection = null;
    protected String rootSectionName;
    private boolean isMatlabReleaseSection = false;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.rootSectionName.equals(localName) && this.stack.isEmpty()) {
            MutableMDLSection modelInformation = new MutableMDLSection(this.rootSectionName, this.locator.getLineNumber());
            this.stack.push(modelInformation);
        } else {
            if (this.stack.isEmpty()) {
                throw new SAXException("Slx file does not start with " + this.rootSectionName);
            }
            this.startInnerElement(localName, attributes);
        }
    }

    private static void copyNonNullParameters(Attributes attributes, MutableMDLSection subSection, String ... parameterNames) {
        for (String parameterName : parameterNames) {
            String value = attributes.getValue(parameterName);
            if (value == null) continue;
            value = org.conqat.lib.commons.string.StringUtils.escapeChars((String)value, (Map)org.conqat.lib.commons.string.StringUtils.ESCAPE_NEWLINE);
            subSection.setParameter(parameterName, value);
            if (!value.equals("StringFind")) continue;
            subSection.setParameter("Ports", "[2,1]");
        }
    }

    protected void startInnerElement(String localName, Attributes attributes) {
        switch (localName) {
            case "P": {
                this.startParameterElement(attributes);
                break;
            }
            case "Block": {
                this.createSubSectionWithAttributes(localName, attributes, "Name", "BlockType", "SID");
                break;
            }
            case "Object": {
                this.createSubSectionWithAttributes(localName, attributes, "PropName", "ObjectID", "ClassName");
                break;
            }
            case "Mask": {
                this.createMaskObjectSection();
                break;
            }
            case "MaskParameter": {
                this.createSubSectionWithAttributes(localName, attributes, "Name", "type");
                break;
            }
            case "Display": {
                this.handleDisplaySection(localName, attributes);
                break;
            }
            case "Array": {
                this.createSubSectionWithAttributes(localName, attributes, "PropName", "type", "Dimension");
                break;
            }
            case "System": {
                this.createSubSectionWithAttributes(localName, attributes, "Ref");
                break;
            }
            case "List": {
                this.createSubSectionWithAttributes(localName, attributes, "ListType");
                break;
            }
            case "state": 
            case "transition": 
            case "junction": 
            case "event": 
            case "target": 
            case "data": 
            case "machine": 
            case "chart": 
            case "instance": {
                this.createSubSectionWithAttributes(localName, attributes, "id", "SSID", "name");
                break;
            }
            case "Annotation": {
                this.createSubSectionWithAttributes(localName, attributes, "SID");
                break;
            }
            case "matlabRelease": {
                this.isMatlabReleaseSection = true;
                this.createSubSectionWithAttributes(localName, attributes, new String[0]);
                break;
            }
            case "ConfigSet": {
                this.createSubSectionWithAttributes(localName, attributes, "Active", "PartName");
                break;
            }
            case "PortCounts": {
                this.createSubSectionWithAttributes(localName, attributes, SimulinkPortBuilder.PORT_TYPE_NAMES_IN_PORTCOUNTS_SECTION.extractFirstList().toArray(new String[0]));
                break;
            }
            case "Port": {
                this.createSubSectionWithAttributes(localName, attributes, "Type", "Index");
                break;
            }
            default: {
                this.createSubSectionWithAttributes(localName, attributes, new String[0]);
            }
        }
    }

    private void handleDisplaySection(String localName, Attributes attributes) {
        if ("Object".equals(this.stack.peek().getName())) {
            this.stack.peek().setCurrentParameter("Display");
        }
        this.createSubSectionWithAttributes(localName, attributes, "RunInitForIconRedraw", "PortRotate");
    }

    private void createMaskObjectSection() {
        MutableMDLSection subSection = new MutableMDLSection("Object", this.locator.getLineNumber());
        subSection.setParameter("PropName", "MaskObject");
        subSection.setParameter("ClassName", "Simulink.Mask");
        this.pushSectionToStack(subSection);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("matlabRelease".equals(localName)) {
            this.isMatlabReleaseSection = false;
        }
        if (this.rootSectionName.equals(localName)) {
            this.rootSection = this.stack.pop();
        } else if (!this.stack.isEmpty() && ("P".equals(localName) || "MaskParameter".equals(this.stack.peek().getName()) && !"MaskParameter".equals(localName))) {
            MutableMDLSection section = this.stack.peek();
            String currentParameter = section.getCurrentParameter();
            section.appendParameter(currentParameter, "");
            section.resetCurrentParameter();
        } else if (this.stack.size() > 1) {
            MutableMDLSection section = this.stack.pop();
            section.resetCurrentParameter();
        }
    }

    protected void startParameterElement(Attributes attributes) {
        MutableMDLSection currentSection = this.stack.peek();
        String name = attributes.getValue("Name");
        currentSection.setCurrentParameter(name);
        String ref = attributes.getValue("Ref");
        if (ref != null) {
            currentSection.setParameter(name, ref);
        }
        SLXDefaultHandlerBase.setDimensionParameter(attributes, currentSection, name);
        SLXDefaultHandlerBase.setDataTypeParameter(attributes, currentSection, name);
    }

    private static void setDimensionParameter(Attributes attributes, MutableMDLSection currentSection, String name) {
        String dimension = attributes.getValue("Dimension");
        if ("Value".equals(name) && dimension != null) {
            currentSection.setParameter("ValueDimension", dimension);
        }
    }

    private static void setDataTypeParameter(Attributes attributes, MutableMDLSection currentSection, String name) {
        String datatype = attributes.getValue("Class");
        if ("Value".equals(name) && datatype != null) {
            currentSection.setParameter("ValueDatatype", datatype);
        }
    }

    protected void createSubSectionWithAttributes(String localName, Attributes attributes, String ... parameterNames) {
        if (!this.stack.isEmpty() && "MaskParameter".equals(this.stack.peek().getName()) && localName.equals("Value")) {
            this.stack.peek().setCurrentParameter(localName);
            return;
        }
        MutableMDLSection subSection = new MutableMDLSection(localName, this.locator.getLineNumber());
        SLXDefaultHandlerBase.copyNonNullParameters(attributes, subSection, parameterNames);
        this.pushSectionToStack(subSection);
    }

    private void pushSectionToStack(MutableMDLSection subSection) {
        MutableMDLSection parent = this.stack.peek();
        parent.addSubSection(subSection);
        this.stack.push(subSection);
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        if (this.stack.isEmpty()) {
            return;
        }
        MutableMDLSection container = this.stack.peek();
        if (this.isMatlabReleaseSection) {
            container.setParameter("MatlabReleaseVersion", new String(chars, start, length));
            return;
        }
        String currentParameter = container.getCurrentParameter();
        String value = new String(chars, start, length);
        if (currentParameter != null) {
            value = org.conqat.lib.commons.string.StringUtils.escapeChars((String)value, (Map)org.conqat.lib.commons.string.StringUtils.ESCAPE_NEWLINE);
            container.appendParameter(currentParameter, value);
        } else if (!StringUtils.isBlank((CharSequence)value.trim())) {
            value = org.conqat.lib.commons.string.StringUtils.escapeChars((String)value, (Map)org.conqat.lib.commons.string.StringUtils.ESCAPE_NEWLINE);
            container.appendParameter(XML_TEXT_CONTENT_PARAMETER_NAME, value);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public MutableMDLSection getRootModelSection() {
        return this.rootSection;
    }
}

