/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.MDLSection;
import org.conqat.lib.simulink.builder.ModelBuildingParameters;
import org.conqat.lib.simulink.builder.SimulinkLineBuilder;
import org.conqat.lib.simulink.builder.SimulinkModelBuilder;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.builder.SimulinkModelDictionaryBuilder;
import org.conqat.lib.simulink.builder.SimulinkPortBuilder;
import org.conqat.lib.simulink.model.SimulinkAnnotation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.SimulinkFunctionConnector;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkObject;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jetbrains.annotations.VisibleForTesting;

class SimulinkBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String RENAME_SUFFIX = "_renamed";
    private final SimulinkLineBuilder lineBuilder;
    private final SimulinkModelDictionaryBuilder modelDictionaryBuilder;
    private final SimulinkModel model;
    private static final Set<String> RELEVANT_LIST_TYPES = CollectionUtils.asHashSet((Object[])new String[]{"InputPortBusObjects", "InterfaceData"});

    public SimulinkBuilder(SimulinkModel model, ModelBuildingParameters parameters, boolean isSlx) {
        this.model = model;
        this.lineBuilder = new SimulinkLineBuilder(parameters, isSlx);
        this.modelDictionaryBuilder = new SimulinkModelDictionaryBuilder(isSlx);
    }

    public void buildSimulink(MDLSection modelSection) throws SimulinkModelBuildingException {
        this.buildMatlabReleaseParam(modelSection);
        this.buildFactoryDefaultParams();
        this.buildBlockTypeDefaultParams(modelSection);
        this.buildBlockDefaultParams(modelSection);
        this.buildLineDefaultParams(modelSection);
        this.buildAnnotationDefaultParams(modelSection);
        this.modelDictionaryBuilder.buildParameters(this.model, modelSection);
        this.buildSimulinkBlocks(modelSection, this.model);
    }

    private void buildFactoryDefaultParams() {
        this.model.setModelFactoryDefaultParameter("HorizontalAlignment", "left");
        this.model.setModelFactoryDefaultParameter("VerticalAlignment", "top");
        this.model.setModelFactoryDefaultParameter("ForegroundColor", "black");
        this.model.setModelFactoryDefaultParameter("BackgroundColor", "white");
        this.model.setModelFactoryDefaultParameter("DropShadow", "off");
        this.model.setModelFactoryDefaultParameter("FontSize", "10");
        this.model.setModelFactoryDefaultParameter("FontAngle", "normal");
        this.model.setModelFactoryDefaultParameter("FontWeight", "normal");
        this.model.setModelFactoryDefaultParameter("FontName", "Arial");
        this.model.setModelFactoryDefaultParameter("BlockMirror", "off");
        this.model.setModelFactoryDefaultParameter("BlockRotation", "0");
        if (this.model.getMatlabVersion() != null && "R2021b".compareTo(this.model.getMatlabVersion()) <= 0) {
            this.model.setModelFactoryDefaultParameter("HideAutomaticNames", "on");
        } else {
            this.model.setModelFactoryDefaultParameter("HideAutomaticNames", "off");
        }
        this.model.setModelFactoryDefaultParameter("LibraryLinkDisplay", "disabled");
    }

    private void buildSimulinkBlocks(MDLSection section, SimulinkBlock parent) throws SimulinkModelBuildingException {
        MDLSection systemSection = section.getFirstSubSection("System");
        if (systemSection == null) {
            return;
        }
        UnmodifiableList<MDLSection> blocks = systemSection.getSubSections("Block");
        for (MDLSection block : blocks) {
            this.buildSimulinkBlock(block, parent);
        }
        UnmodifiableList<MDLSection> functionConnectors = systemSection.getSubSections("FunctionConnector");
        for (MDLSection connector : functionConnectors) {
            SimulinkBuilder.buildSimulinkFunctionConnector(connector, parent);
        }
        section.removeSubSections("System");
        section.removeSubSections("Block");
        section.removeSubSections("FunctionConnector");
        this.lineBuilder.buildLines(systemSection, parent);
        SimulinkBuilder.buildAnnotations(systemSection, parent);
    }

    private void buildSimulinkBlock(MDLSection section, SimulinkBlock parent) throws SimulinkModelBuildingException {
        if (section.getParameter("Name") == null) {
            throw new SimulinkModelBuildingException("Block at line " + section.getLineNumber() + " has no name.");
        }
        if (section.getParameter("BlockType") == null) {
            throw new SimulinkModelBuildingException("Block at line " + section.getLineNumber() + " has no type.");
        }
        SimulinkBlock simulinkBlock = this.createBlock(section, parent);
        SimulinkModelBuilder.addParameters(simulinkBlock, section);
        this.checkDuplicateSubBlockName(simulinkBlock, parent);
        parent.addSubBlock(simulinkBlock);
        SimulinkPortBuilder.buildPorts(simulinkBlock, section);
        SimulinkBuilder.addSystemSectionParameters(section, simulinkBlock);
        SimulinkBuilder.addListSectionParameters(section, simulinkBlock);
        SimulinkBuilder.addInstanceDataSectionParameters(section, simulinkBlock);
        SimulinkBuilder.createCustomParameters(simulinkBlock);
        this.buildObjects(section, simulinkBlock);
        this.buildSimulinkBlocks(section, simulinkBlock);
        SimulinkBuilder.buildSimulinkFunctionPort(section, simulinkBlock);
    }

    private void checkDuplicateSubBlockName(SimulinkBlock subBlock, SimulinkBlock parent) {
        String name = subBlock.getParameter("Name");
        if (parent.getSubBlock(name) != null) {
            this.warnDuplicateSubBlock(name);
            SimulinkBuilder.renameDuplicateSubBlockName(subBlock, parent);
        }
    }

    private static void renameDuplicateSubBlockName(SimulinkBlock subBlock, SimulinkBlock parent) {
        Object name = subBlock.getParameter("Name");
        while (parent.getSubBlock((String)name) != null) {
            name = (String)name + RENAME_SUFFIX;
        }
        subBlock.setParameter("Name", (String)name);
    }

    private void warnDuplicateSubBlock(String name) {
        LOGGER.warn("Duplicate block name '" + name + "' in " + this.model.getUniformPath() + " . Renaming by adding '_renamed' to avoid conflict. If any MATLAB code refers to this block by the name it may no longer work.");
    }

    private static void addSystemSectionParameters(MDLSection section, SimulinkBlock simulinkBlock) {
        MDLSection systemSection = section.getFirstSubSection("System");
        if (systemSection != null) {
            for (String paramName : systemSection.getParameterNames()) {
                simulinkBlock.setParameter("System." + paramName, systemSection.getParameter(paramName));
            }
        }
    }

    private static void addListSectionParameters(MDLSection section, SimulinkBlock simulinkBlock) {
        UnmodifiableList<MDLSection> listSections = section.getSubSections("List");
        for (MDLSection listSection : listSections) {
            String listType = listSection.getParameter("ListType");
            if (listType == null || !RELEVANT_LIST_TYPES.contains(listType)) continue;
            for (String paramName : listSection.getParameterNames()) {
                if (paramName.equals("ListType")) continue;
                simulinkBlock.setParameter(listType + "." + paramName, listSection.getParameter(paramName));
            }
        }
    }

    private static void addInstanceDataSectionParameters(MDLSection section, SimulinkBlock simulinkBlock) {
        MDLSection instanceDataSection = section.getFirstSubSection("InstanceData");
        if (instanceDataSection != null) {
            for (String paramName : instanceDataSection.getParameterNames()) {
                simulinkBlock.setParameter(paramName, instanceDataSection.getParameter(paramName));
            }
        }
    }

    private static void buildSimulinkFunctionPort(MDLSection section, SimulinkBlock simulinkBlock) {
        MDLSection functionPortSection = section.getFirstSubSection("FunctionPort");
        if (functionPortSection != null) {
            SimulinkObject functionPort = new SimulinkObject();
            functionPort.setParameter("Name", "FunctionPort");
            for (String paramName : functionPortSection.getParameterNames()) {
                functionPort.setParameter(paramName, functionPortSection.getParameter(paramName));
            }
            simulinkBlock.addObject(functionPort);
        }
    }

    private static void buildSimulinkFunctionConnector(MDLSection connectorSection, SimulinkBlock parent) {
        SimulinkFunctionConnector functionConnector = new SimulinkFunctionConnector();
        SimulinkModelBuilder.addParameters(functionConnector, connectorSection);
        parent.addFunctionConnector(functionConnector);
    }

    private static void createCustomParameters(SimulinkBlock block) {
        if (block.isOfType("MultiPortSwitch")) {
            String value = block.getParameter("DataPortIndices");
            SimulinkBuilder.processInputSignalsList(block, value, "DataPortIndicesString", true);
        } else if (block.isOfType("Assignment") || block.isOfType("Selector")) {
            SimulinkBuilder.processIndexOptions(block);
        } else if (block.isOfType("SwitchCase")) {
            SimulinkBuilder.processInputSignalsList(block, block.getParameter("CaseConditions"), "ProcessedCaseConditions", false);
        } else if (block.isOfType("FunctionCaller")) {
            SimulinkBuilder.processFunctionArguments(block, block.getParameter("FunctionPrototype"));
        }
    }

    private static void processFunctionArguments(SimulinkBlock block, String functionPrototype) {
        String[] arguments = functionPrototype.split("\\s*=\\s*", 2);
        String output = "";
        String call = functionPrototype;
        if (arguments.length > 1) {
            output = arguments[0].replaceAll("[\\]\\[\\s]", "");
            call = arguments[1];
        }
        Matcher m = Pattern.compile("\\((.*)\\)").matcher(call);
        String inputs = "";
        if (m.find()) {
            inputs = m.group(1);
        }
        String functionName = call.replace(inputs, "");
        block.setParameter("FunctionName", functionName);
        block.setParameter("FunctionInput", inputs);
        block.setParameter("FunctionOutput", output);
    }

    private static void processIndexOptions(SimulinkBlock block) {
        String indexOptions = block.getParameter("IndexOptions");
        Object resultingIndices = "";
        if (indexOptions != null) {
            String[] splitIndexOptions = indexOptions.split(",");
            for (int i = 0; i < splitIndexOptions.length; ++i) {
                if (!splitIndexOptions[i].contains("port")) continue;
                resultingIndices = (String)resultingIndices + (i + 1) + " ";
            }
        }
        block.setParameter("PortIndices", (String)resultingIndices);
    }

    private static void processInputSignalsList(SimulinkBlock block, String input, String parameterName, boolean addAsterisk) {
        block.setParameter(parameterName, SimulinkBuilder.buildModifiedInputSignalsList(input, addAsterisk));
    }

    @VisibleForTesting
    static String buildModifiedInputSignalsList(String input, boolean addAsterisk) {
        if (input == null) {
            return "";
        }
        String modifiedInput = StringUtils.unescapeChars((String)input, (Map)StringUtils.ESCAPE_NEWLINE);
        modifiedInput = modifiedInput.replaceAll("\\{\\s*,?|,?\\s*\\}", "").trim();
        Matcher matcher = Pattern.compile("\\d+((\\s*[\\\\*/\\^/&&[^,]]\\s*|\\s*[-+]\\s+)\\d+)+").matcher(modifiedInput);
        StringBuffer inputSignalBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(inputSignalBuffer, matcher.group(0).replaceAll("\\s+", ""));
        }
        matcher.appendTail(inputSignalBuffer);
        modifiedInput = inputSignalBuffer.toString();
        matcher = Pattern.compile("(\\]\\s+[-+]?\\d+((\\s+\\d*)+)*|\\s*\\d+(\\s+\\d*)+)(?!(,|[+-\\\\*]\\s*\\[))").matcher(modifiedInput);
        inputSignalBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(inputSignalBuffer, matcher.group(0).trim().replaceAll("\\s+", ","));
        }
        matcher.appendTail(inputSignalBuffer);
        modifiedInput = inputSignalBuffer.toString().replaceAll("\\]\\s*\\[", "],[");
        modifiedInput = modifiedInput.replace(";", ",");
        while (modifiedInput.contains("[")) {
            modifiedInput = SimulinkBuilder.processBracketedInputs(modifiedInput);
        }
        if (addAsterisk) {
            modifiedInput = modifiedInput.concat(",*");
        }
        return modifiedInput;
    }

    private static String processBracketedInputs(String inputSignals) {
        Matcher matcher = Pattern.compile("([^,\\[]*)\\[([^\\[\\]]*)\\]([^,\\]]*)").matcher(inputSignals);
        StringBuffer inputSignalBuffer = new StringBuffer();
        while (matcher.find()) {
            String operandsBeforeBracket = matcher.group(1).replaceAll("\\s+", "");
            String inputsBetweenBrackets = matcher.group(2);
            String operandAfterBracket = matcher.group(3).replaceAll("\\s+", "");
            Object replacement = inputsBetweenBrackets.replace(",", operandAfterBracket + " " + operandsBeforeBracket);
            replacement = operandsBeforeBracket + (String)replacement + operandAfterBracket;
            matcher.appendReplacement(inputSignalBuffer, (String)replacement);
        }
        matcher.appendTail(inputSignalBuffer);
        return inputSignalBuffer.toString();
    }

    private SimulinkBlock createBlock(MDLSection section, SimulinkBlock parent) {
        StateflowChart chart;
        String name = section.getParameter("Name");
        String fqName = SimulinkUtils.buildId(parent, name);
        StateflowMachine machine = this.model.getStateflowMachine();
        if (machine != null && (chart = machine.getChart(fqName)) != null) {
            return new StateflowBlock(chart);
        }
        return new SimulinkBlock();
    }

    private static void buildAnnotations(MDLSection section, SimulinkBlock simulinkBlock) {
        for (MDLSection annotationSection : section.getSubSections("Annotation")) {
            SimulinkAnnotation annotation = new SimulinkAnnotation();
            SimulinkModelBuilder.addParameters(annotation, annotationSection);
            simulinkBlock.addAnnotation(annotation);
        }
    }

    private void buildObjects(MDLSection section, SimulinkElementBase simulinkElement) {
        for (MDLSection objectSection : section.getSubSections("Object")) {
            SimulinkObject object = new SimulinkObject();
            SimulinkModelBuilder.addParameters(object, objectSection);
            simulinkElement.addObject(object);
            SimulinkBuilder.buildMaskParameterObjects(objectSection, simulinkElement);
            this.buildObjects(objectSection, object);
        }
        for (MDLSection arraySection : section.getSubSections("Array")) {
            this.buildObjects(arraySection, simulinkElement);
        }
        for (MDLSection instanceDataSection : section.getSubSections("InstanceData")) {
            this.buildObjects(instanceDataSection, simulinkElement);
        }
    }

    private static void buildMaskParameterObjects(MDLSection section, SimulinkElementBase simulinkElement) {
        for (MDLSection maskSection : section.getSubSections("MaskParameter")) {
            SimulinkObject mask = new SimulinkObject();
            SimulinkModelBuilder.addParameters(mask, maskSection);
            simulinkElement.addObject(mask);
        }
        if ("MaskObject".equals(section.getParameter("PropName")) && "Simulink.Mask".equals(section.getParameter("ClassName"))) {
            for (MDLSection maskSubsection : section.getSubSections()) {
                String subsectionName = maskSubsection.getName();
                SimulinkBuilder.injectParametersIntoElement("Mask." + subsectionName, maskSubsection, simulinkElement);
            }
        }
    }

    private static void injectParametersIntoElement(String newParameterNamePrefix, MDLSection mdlSection, SimulinkElementBase simulinkElement) {
        for (String paramName : mdlSection.getParameterNames()) {
            if ("Teamscale_XML_Text_Content".equals(paramName)) {
                simulinkElement.setParameter(newParameterNamePrefix, mdlSection.getParameter(paramName));
                continue;
            }
            simulinkElement.setParameter(newParameterNamePrefix + "." + paramName, mdlSection.getParameter(paramName));
        }
    }

    private void buildBlockTypeDefaultParams(MDLSection modelSection) {
        MDLSection blockDefaults = modelSection.getFirstSubSection("BlockDefaults");
        if (blockDefaults == null) {
            return;
        }
        for (String name : blockDefaults.getParameterNames()) {
            this.model.setBlockDefaultParameter(name, blockDefaults.getParameter(name));
        }
    }

    private void buildBlockDefaultParams(MDLSection modelSection) {
        MDLSection blockParameterDefaults = modelSection.getFirstSubSection("BlockParameterDefaults");
        if (blockParameterDefaults == null) {
            return;
        }
        for (MDLSection childBlock : blockParameterDefaults.getSubSections("Block")) {
            String type = childBlock.getParameter("BlockType");
            for (String name : childBlock.getParameterNames()) {
                if (name.equals("BlockType")) continue;
                this.model.setBlockTypeDefaultParameter(type, name, childBlock.getParameter(name));
            }
        }
    }

    private void buildLineDefaultParams(MDLSection modelSection) {
        MDLSection lineDefaults = modelSection.getFirstSubSection("LineDefaults");
        if (lineDefaults == null) {
            return;
        }
        for (String name : lineDefaults.getParameterNames()) {
            this.model.setLineDefaultParameter(name, lineDefaults.getParameter(name));
        }
    }

    private void buildMatlabReleaseParam(MDLSection modelSection) {
        MDLSection matlabRelease = modelSection.getFirstSubSection("matlabRelease");
        if (matlabRelease == null) {
            return;
        }
        for (String name : matlabRelease.getParameterNames()) {
            this.model.setParameter(name, matlabRelease.getParameter(name));
        }
    }

    private void buildAnnotationDefaultParams(MDLSection modelSection) {
        MDLSection annotationDefaults = modelSection.getFirstSubSection("AnnotationDefaults");
        if (annotationDefaults == null) {
            return;
        }
        for (String name : annotationDefaults.getParameterNames()) {
            this.model.setAnnotationDefaultParameter(name, annotationDefaults.getParameter(name));
        }
    }

    class RegexConstants {
        private static final String MATHEMATICAL_OPERATIONS_PATTERN = "\\d+((\\s*[\\\\*/\\^/&&[^,]]\\s*|\\s*[-+]\\s+)\\d+)+";
        private static final String INDIVIDUAL_INPUTS_PATTERN = "(\\]\\s+[-+]?\\d+((\\s+\\d*)+)*|\\s*\\d+(\\s+\\d*)+)(?!(,|[+-\\\\*]\\s*\\[))";
        private static final String GROUPED_INPUTS_PATTERN = "([^,\\[]*)\\[([^\\[\\]]*)\\]([^,\\]]*)";

        RegexConstants(SimulinkBuilder this$0) {
        }
    }
}

