/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.builder.SimulinkBusElement;

@IndexValueClass
public class SimulinkBus
implements ISimulinkDataDictionaryEntry {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final UnmodifiableList<SimulinkBusElement> busElements;

    SimulinkBus(String name, List<SimulinkBusElement> busElements) {
        this.name = name;
        this.busElements = CollectionUtils.asUnmodifiable(busElements);
    }

    public UnmodifiableList<SimulinkBusElement> getBusElements() {
        return this.busElements;
    }

    @Override
    public String getEntryType() {
        return "Simulink.Bus";
    }

    @Override
    public String getDataType() {
        return "Bus";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Optional<SimulinkBusElement> findElement(String busElementName) {
        for (SimulinkBusElement element : this.busElements) {
            if (!element.getName().equals(busElementName)) continue;
            return Optional.of(element);
        }
        return Optional.empty();
    }
}

