/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.error.FormatException;
import org.conqat.lib.commons.version.Version;
import org.conqat.lib.simulink.builder.ModelBuildingParameters;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.model.datahandler.ModelDataHandler;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLayoutHandler;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLayoutHandler2008b;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLayoutHandler2009a;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLayoutHandler2015a;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLayoutHandler2016a;
import org.conqat.lib.simulink.model.datahandler.stateflow.StateflowLayoutHandler;

public class ModelDataHandlerFactory {
    public static ModelDataHandler createModelHandler(String versionString, String releaseVersionName, boolean isSlxFormat, ModelBuildingParameters parameters) throws SimulinkModelBuildingException {
        if (versionString == null) {
            throw new SimulinkModelBuildingException("Model version parameter missing in model!");
        }
        try {
            Version version = Version.parseVersion((String)versionString);
            return ModelDataHandlerFactory.createModelHandler(version, releaseVersionName, isSlxFormat, parameters);
        }
        catch (FormatException e) {
            throw new SimulinkModelBuildingException("Could not parse simulink model version: " + versionString, e);
        }
    }

    private static ModelDataHandler createModelHandler(Version version, String releaseVersionName, boolean isSlxFormat, ModelBuildingParameters parameters) {
        return new ModelDataHandler(parameters, ModelDataHandlerFactory.createSimulinkLayoutHandler(version, releaseVersionName, isSlxFormat), new StateflowLayoutHandler());
    }

    private static SimulinkLayoutHandler createSimulinkLayoutHandler(Version version, String releaseVersionName, boolean isSlxFormat) {
        if (!isSlxFormat && ModelDataHandlerFactory.isVersionAtOrBefore2008b(version, releaseVersionName)) {
            return new SimulinkLayoutHandler2008b();
        }
        if (ModelDataHandlerFactory.getMatlabReleaseVersionYear(releaseVersionName) >= 2016 || !isSlxFormat && ModelDataHandlerFactory.isVersionAtOrAfter2016a(version)) {
            return new SimulinkLayoutHandler2016a();
        }
        if (ModelDataHandlerFactory.isVersionAfter2014b(version, releaseVersionName)) {
            return new SimulinkLayoutHandler2015a();
        }
        return new SimulinkLayoutHandler2009a();
    }

    private static boolean isVersionAtOrAfter2016a(Version version) {
        return version.getMajor() > 8 || version.getMajor() == 8 && version.getMinor() >= 7;
    }

    private static boolean isVersionAtOrBefore2008b(Version version, String releaseVersionName) {
        int releaseYear = ModelDataHandlerFactory.getMatlabReleaseVersionYear(releaseVersionName);
        if (releaseYear != 0) {
            return releaseYear <= 2008;
        }
        return version.getMajor() < 7 || version.getMajor() == 7 && version.getMinor() <= 2;
    }

    private static boolean isVersionAfter2014b(Version version, String releaseVersionName) {
        int releaseYear = ModelDataHandlerFactory.getMatlabReleaseVersionYear(releaseVersionName);
        if (releaseYear != 0) {
            return releaseYear > 2014;
        }
        return version.getMajor() > 8 || version.getMajor() == 8 && version.getMinor() > 4;
    }

    public static int getMatlabReleaseVersionYear(String releaseVersionName) {
        if (releaseVersionName.isEmpty()) {
            return 0;
        }
        Matcher matcher = Pattern.compile("R(\\d{4}).+").matcher(releaseVersionName);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 0;
    }
}

