/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler.simulink;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkObject;
import org.conqat.lib.simulink.model.datahandler.ESimulinkColor;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class MaskObjectParameter {
    private static final Pattern COMMAND_PATTERN = Pattern.compile("([a-zA-Z_]+)\\s*\\((.*)\\)");
    private Color currentColor;
    private Color labelColor;
    private String labelText;
    private final Map<String, Color> portColors = new HashMap<String, Color>();
    private final Map<String, String> portTexts = new HashMap<String, String>();

    private MaskObjectParameter() {
    }

    private MaskObjectParameter parse(String displayString) {
        String[] commands;
        for (String command : commands = SimulinkUtils.replaceSimulinkLineBreaks(displayString).split("[;\n\r]+")) {
            this.interpret(command);
        }
        return this;
    }

    private void interpret(String command) {
        Matcher matcher = COMMAND_PATTERN.matcher(command);
        if (!matcher.matches()) {
            return;
        }
        String[] parameters = matcher.group(2).split(",");
        switch (matcher.group(1).toLowerCase()) {
            case "color": {
                this.setCurrentColor(parameters);
                break;
            }
            case "disp": 
            case "fprintf": {
                this.display(parameters);
                break;
            }
            case "port_label": {
                this.portLabel(parameters);
            }
        }
    }

    private void setCurrentColor(String[] parameters) {
        if (parameters.length != 1) {
            return;
        }
        String colorString = MaskObjectParameter.extractString(parameters[0]);
        if (colorString.startsWith("[")) {
            double[] colorArray = SimulinkUtils.getDoubleParameterArray(colorString);
            if (colorArray.length == 3) {
                this.currentColor = new Color((float)colorArray[0], (float)colorArray[1], (float)colorArray[2]);
            }
        } else {
            ESimulinkColor color = (ESimulinkColor)EnumUtils.valueOfIgnoreCase(ESimulinkColor.class, (String)colorString);
            if (color != null) {
                this.currentColor = color.getColor();
            }
        }
    }

    private void display(String[] parameters) {
        if (parameters.length > 0 && parameters[0].trim().startsWith("'")) {
            this.labelColor = this.currentColor;
            this.labelText = MaskObjectParameter.extractString(parameters[0]);
        }
    }

    private static String extractString(String string) {
        string = string.trim();
        string = StringUtils.stripPrefix((String)string, (String)"'");
        string = StringUtils.stripSuffix((String)string, (String)"'");
        return string;
    }

    private void portLabel(String[] parameters) {
        if (parameters.length != 3) {
            return;
        }
        String direction = MaskObjectParameter.extractString(parameters[0]);
        String key = direction + parameters[1];
        this.portColors.put(key, this.currentColor);
        this.portTexts.put(key, MaskObjectParameter.extractString(parameters[2]));
    }

    public static MaskObjectParameter extractFromBlock(SimulinkBlock block) {
        for (SimulinkObject object : block.getObjects()) {
            if (!MaskObjectParameter.isMaskObject(object)) continue;
            return MaskObjectParameter.parseMaskObject(object);
        }
        String maskDisplay = StringUtils.emptyIfNull((String)block.getParameter("MaskDisplay"));
        if (!maskDisplay.isEmpty()) {
            return new MaskObjectParameter().parse(maskDisplay);
        }
        return null;
    }

    public Color getLabelColor() {
        if (this.labelColor == null) {
            return Color.BLACK;
        }
        return this.labelColor;
    }

    public String getLabelText() {
        return this.labelText;
    }

    static boolean isMaskObject(SimulinkObject object) {
        return "Simulink.Mask".equals(object.getParameter("$ClassName")) || "Simulink.Mask".equals(object.getParameter("ClassName"));
    }

    private static MaskObjectParameter parseMaskObject(SimulinkObject object) {
        String displayString = object.getParameter("Display");
        if (displayString == null) {
            return null;
        }
        return new MaskObjectParameter().parse(displayString);
    }

    public String getPortText(boolean isInport, String index) {
        return this.portTexts.get(MaskObjectParameter.makePortKey(isInport, index));
    }

    public Color getPortColor(boolean isInport, String index) {
        Color color = this.portColors.get(MaskObjectParameter.makePortKey(isInport, index));
        if (color == null) {
            return Color.BLACK;
        }
        return color;
    }

    private static String makePortKey(boolean isInport, String index) {
        if (isInport) {
            return "input" + index;
        }
        return "output" + index;
    }
}

