/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.types;

import java.math.BigDecimal;

public enum ENumericDataType {
    BOOLEAN(8, false),
    INT8(8, true),
    UINT8(8, false),
    INT16(16, true),
    UINT16(16, false),
    INT32(32, true),
    UINT32(32, false),
    INT64(64, true),
    UINT64(64, false),
    HALF(66, true),
    SINGLE(68, true),
    DOUBLE(70, true);

    private final BigDecimal min;
    private final BigDecimal max;

    private ENumericDataType(int bit, boolean signed) {
        if (signed) {
            this.min = BigDecimal.valueOf(2L).pow(bit - 1).negate();
            this.max = BigDecimal.valueOf(2L).pow(bit - 1).subtract(BigDecimal.ONE);
        } else {
            this.min = BigDecimal.valueOf(0L);
            this.max = BigDecimal.valueOf(2L).pow(bit).subtract(BigDecimal.ONE);
        }
    }

    public BigDecimal min() {
        return this.min;
    }

    public BigDecimal max() {
        return this.max;
    }

    public boolean rangeContains(BigDecimal value) {
        return this.min.compareTo(value) <= 0 && value.compareTo(this.max) <= 0;
    }
}

