/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.ui;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.conqat.lib.simulink.builder.SimulinkRegistry;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.datahandler.ESimulinkBlockType;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkBlockLabelUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jspecify.annotations.Nullable;

public class SimulinkLabelOnBlockData {
    private static final String TEXT_PROPERTY = "text";
    private static final String ICON_FILE_NAME_PROPERTY = "iconFileName";
    private static final String TEXT_FITS_INSIDE_BLOCK_PROPERTY = "textFitsInsideBlock";
    @JsonProperty(value="text")
    private final @Nullable String text;
    @JsonProperty(value="iconFileName")
    private final @Nullable String iconFileName;
    @JsonProperty(value="textFitsInsideBlock")
    private final boolean textFitsInsideBlock;

    @JsonCreator
    public SimulinkLabelOnBlockData(@JsonProperty(value="text") String text, @JsonProperty(value="iconFileName") @Nullable String iconFileName) {
        this.text = text;
        this.iconFileName = iconFileName;
        this.textFitsInsideBlock = true;
    }

    public SimulinkLabelOnBlockData(SimulinkBlock block, ESimulinkBlockType type) {
        String blockType = block.getType();
        this.text = SimulinkLabelOnBlockData.getLabelText(block, type, blockType);
        this.iconFileName = SimulinkLabelOnBlockData.getLabelIconFilename(block, type, blockType);
        this.textFitsInsideBlock = SimulinkBlockLabelUtils.labelFitsInsideBlock(this.text, block);
    }

    public static String getLabelText(SimulinkBlock block) {
        return SimulinkLabelOnBlockData.getLabelText(block, SimulinkUtils.determineBlockType(block), block.getType());
    }

    private static String getLabelText(SimulinkBlock block, ESimulinkBlockType type, String typeString) {
        String text = SimulinkRegistry.getInstance().getLabelText(typeString);
        if (text != null) {
            return text;
        }
        String labelParameterForBlockType = SimulinkRegistry.getInstance().getLabelParameter(typeString);
        if (labelParameterForBlockType != null && (text = block.getParameter(labelParameterForBlockType)) != null && type != ESimulinkBlockType.LOGIC) {
            return text;
        }
        return type.getBlockTextLabel(block);
    }

    private static String getLabelIconFilename(SimulinkBlock block, ESimulinkBlockType type, String typeString) {
        String iconFileName = SimulinkRegistry.getInstance().getLabelIcon(typeString);
        if (iconFileName != null) {
            return iconFileName;
        }
        return type.getBlockIconLabel(block);
    }

    public String getText() {
        return this.text;
    }

    public String getIcon() {
        return this.iconFileName;
    }

    public boolean isTextFitsInsideBlock() {
        return this.textFitsInsideBlock;
    }
}

