/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.simulink.model.datahandler.ChartLayoutData;
import org.conqat.lib.simulink.model.datahandler.EHorizontalAlignment;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.RectangleLayoutData;
import org.conqat.lib.simulink.model.datahandler.TransitionLayoutData;
import org.conqat.lib.simulink.model.datahandler.stateflow.StateflowLayoutHandler;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowElementBase;
import org.conqat.lib.simulink.model.stateflow.StateflowJunction;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.RendererBase;
import org.conqat.lib.simulink.util.StateflowUtils;

public class StateflowChartRenderer
extends RendererBase {
    private static final int STATE_ARC_SIZE = 20;

    public static BufferedImage renderChart(StateflowChart chart) {
        Rectangle canvasRectangle = StateflowChartRenderer.determineCanvasRectangle(chart);
        BufferedImage image = new BufferedImage(canvasRectangle.width, canvasRectangle.height, 6);
        Graphics2D graphics = StateflowChartRenderer.createGraphics(canvasRectangle, image);
        StateflowChartRenderer.renderLabel(chart.obtainLabelLayoutData(), EHorizontalAlignment.LEFT, graphics, false);
        StateflowChartRenderer.renderNodes(graphics, chart.getNodes());
        for (StateflowTransition transition : StateflowUtils.getNonCrossingTransitions(chart)) {
            StateflowChartRenderer.renderTransition(transition, graphics);
        }
        return image;
    }

    private static void renderNodes(Graphics2D graphics, Collection<StateflowNodeBase> nodes) {
        for (StateflowNodeBase node : CollectionUtils.sort(nodes, Comparator.comparing(StateflowElementBase::getStateflowId))) {
            StateflowChartRenderer.renderNode(graphics, node);
            if (!(node instanceof StateflowState)) continue;
            StateflowState state = (StateflowState)node;
            StateflowChartRenderer.renderNodes(graphics, state.getNodes());
        }
    }

    private static void renderNode(Graphics2D graphics, StateflowNodeBase node) {
        RectangleLayoutData layoutData = node.obtainLayoutData();
        Rectangle position = layoutData.getPosition();
        graphics.setColor(layoutData.getBackgroundColor());
        if (node instanceof StateflowState) {
            StateflowState state = (StateflowState)node;
            if (!state.isNoteBox()) {
                if (state.isFunctionState() || state.isGroupState()) {
                    graphics.fillRect(position.x, position.y, position.width, position.height);
                } else {
                    graphics.fillRoundRect(position.x, position.y, position.width, position.height, 20, 20);
                }
            }
        } else if (node instanceof StateflowJunction) {
            graphics.fillOval(position.x, position.y, position.width, position.height);
        }
        graphics.setColor(layoutData.getForegroundColor());
        if (node instanceof StateflowState) {
            StateflowChartRenderer.renderStateflowStateBackgroundAndLabel(graphics, (StateflowState)node, layoutData);
        } else if (node instanceof StateflowJunction) {
            graphics.drawOval(position.x, position.y, position.width, position.height);
        }
    }

    private static void renderStateflowStateBackgroundAndLabel(Graphics2D graphics, StateflowState state, RectangleLayoutData stateLayoutData) {
        Rectangle statePosition = stateLayoutData.getPosition();
        Stroke oldStroke = graphics.getStroke();
        graphics.setStroke(stateLayoutData.getStroke());
        if (!state.isNoteBox()) {
            if (state.isFunctionState() || state.isGroupState()) {
                graphics.drawRect(statePosition.x, statePosition.y, statePosition.width, statePosition.height);
            } else {
                graphics.drawRoundRect(statePosition.x, statePosition.y, statePosition.width, statePosition.height, 20, 20);
            }
        }
        graphics.setStroke(oldStroke);
        LabelLayoutData labelData = state.obtainLabelData();
        StateflowChartRenderer.renderLabel(labelData, EHorizontalAlignment.LEFT, graphics, false);
        if (state.isSubChart() || state.isSimulinkFunction() || state.isActionSubsystemState()) {
            Font font = labelData.getFont().getAwtFont();
            float lineHeight = font.getLineMetrics("One Line", graphics.getFontRenderContext()).getHeight() * 1.5f;
            graphics.drawLine(statePosition.x, (int)((float)statePosition.y + lineHeight), statePosition.x + statePosition.width, (int)((float)statePosition.y + lineHeight));
        }
    }

    private static void renderTransition(StateflowTransition transition, Graphics2D graphics) {
        TransitionLayoutData layoutData = transition.obtainLayoutData();
        List<Point> points = layoutData.getPoints();
        GeneralPath path = new GeneralPath();
        path.moveTo(points.get((int)0).x, points.get((int)0).y);
        for (int i = 1; i < points.size() - 1; i += 2) {
            path.quadTo(points.get((int)i).x, points.get((int)i).y, points.get((int)(i + 1)).x, points.get((int)(i + 1)).y);
        }
        graphics.setColor(StateflowLayoutHandler.TRANSITION_COLOR);
        if (transition.getDst() == null) {
            graphics.setColor(Color.RED);
        }
        graphics.draw(path);
        StateflowChartRenderer.renderArrow(graphics, (Point)CollectionUtils.getLast(points), points.get(points.size() - 2), layoutData.getArrowheadSize());
        if (transition.getSrc() == null) {
            graphics.fillArc(points.get((int)0).x - 2, points.get((int)0).y - 2, 4, 4, 0, 360);
        }
        StateflowChartRenderer.renderLabel(transition.obtainLabelData(), graphics);
    }

    private static void renderArrow(Graphics2D graphics, Point position, Point lineStart, int arrowheadSize) {
        AffineTransform oldTransform = graphics.getTransform();
        double theta = Math.atan2(position.y - lineStart.y, position.x - lineStart.x);
        graphics.translate(position.x, position.y);
        graphics.rotate(theta);
        graphics.drawPolygon(StateflowChartRenderer.createArrowHeadPolygon(arrowheadSize));
        graphics.setTransform(oldTransform);
    }

    private static Polygon createArrowHeadPolygon(int size) {
        return new Polygon(new int[]{0, -size, -size}, new int[]{0, size / 4, -size / 4}, 3);
    }

    private static Rectangle determineCanvasRectangle(StateflowChart chart) {
        ChartLayoutData chartLayoutData = chart.obtainChartLayoutData();
        if (chartLayoutData != null && chartLayoutData.getDimensions() != null) {
            return chartLayoutData.getDimensions();
        }
        Rectangle canvasRectangle = null;
        for (StateflowNodeBase node : chart.getNodes()) {
            canvasRectangle = StateflowChartRenderer.enlargeCanvasRectangle(node.obtainLayoutData(), canvasRectangle);
            if (!(node instanceof StateflowState)) continue;
            canvasRectangle = StateflowChartRenderer.enlargeCanvasRectangle(((StateflowState)node).obtainLabelData(), canvasRectangle);
        }
        if (canvasRectangle == null) {
            return new Rectangle(10, 10);
        }
        for (StateflowTransition transition : StateflowUtils.getAllTransitions(chart, true)) {
            StateflowChartRenderer.enlargeCanvasRectangle(transition.obtainLabelData(), canvasRectangle);
            TransitionLayoutData layoutData = transition.obtainLayoutData();
            for (Point point : layoutData.getPoints()) {
                canvasRectangle.add(point);
            }
        }
        canvasRectangle.grow(10, 10);
        return canvasRectangle;
    }

    private static Rectangle enlargeCanvasRectangle(LabelLayoutData labelData, Rectangle canvasRectangle) {
        if (labelData != null) {
            Font font = labelData.getFont().getAwtFont();
            Dimension labelDimensions = StateflowChartRenderer.determineLabelDimensions(labelData.getText(), font, new FontRenderContext(null, false, false));
            Rectangle labelPosition = new Rectangle(labelData.getPosition().x, labelData.getPosition().y, (int)labelDimensions.getWidth(), (int)labelDimensions.getHeight());
            if (canvasRectangle == null) {
                canvasRectangle = labelPosition;
            } else {
                canvasRectangle.add(labelPosition);
            }
        }
        return canvasRectangle;
    }

    private static Rectangle enlargeCanvasRectangle(RectangleLayoutData layoutData, Rectangle canvasRectangle) {
        if (canvasRectangle == null) {
            canvasRectangle = layoutData.getPosition();
        } else {
            canvasRectangle.add(layoutData.getPosition());
        }
        return canvasRectangle;
    }
}

