/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.teamscale.commons.lang.ToStringHelpers;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.commons.util.LineRangeDeserializer;
import org.conqat.engine.commons.util.LineRangeSerializer;
import org.conqat.engine.sourcecode.coverage.CoverageProbeBase;
import org.conqat.lib.commons.collections.CompactLines;
import org.jspecify.annotations.Nullable;

public record TeamscaleCompactCoverageReport(@JsonProperty(value="version") Integer version, @JsonProperty(value="coverage") List<CompactCoverageFileInfo> fileCoverageInfos) {
    public String buildReport() throws JsonProcessingException {
        SimpleModule module = new SimpleModule();
        module.addSerializer(CompactLines.class, (JsonSerializer)new LineRangeSerializer());
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)module);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper.writeValueAsString((Object)this);
    }

    public static final class CompactCoverageFileInfo {
        @JsonProperty(value="filePath")
        private final String filePath;
        @JsonProperty(value="fullyCoveredLines")
        @JsonSerialize(using=LineRangeSerializer.class)
        @JsonDeserialize(using=LineRangeDeserializer.class)
        private final CompactLines fullyCoveredLines;
        @JsonProperty(value="partiallyCoveredLines")
        @JsonSerialize(using=LineRangeSerializer.class)
        @JsonDeserialize(using=LineRangeDeserializer.class)
        private final @Nullable CompactLines partiallyCoveredLines;
        @JsonProperty(value="uncoveredLines")
        @JsonSerialize(using=LineRangeSerializer.class)
        @JsonDeserialize(using=LineRangeDeserializer.class)
        private final @Nullable CompactLines uncoveredLines;
        @JsonProperty(value="coverageProbes")
        private final @Nullable List<CoverageProbeBase> coverageProbes;

        @JsonCreator
        public CompactCoverageFileInfo(@JsonProperty(value="filePath") String filePath, @JsonProperty(value="fullyCoveredLines") CompactLines fullyCoveredLines, @JsonProperty(value="partiallyCoveredLines") @Nullable CompactLines partiallyCoveredLines, @JsonProperty(value="uncoveredLines") @Nullable CompactLines uncoveredLines, @JsonProperty(value="coverageProbes") @Nullable List<CoverageProbeBase> coverageProbes) {
            this.filePath = filePath;
            this.fullyCoveredLines = fullyCoveredLines;
            this.partiallyCoveredLines = partiallyCoveredLines != null && !partiallyCoveredLines.isEmpty() ? partiallyCoveredLines : null;
            this.uncoveredLines = uncoveredLines != null && !uncoveredLines.isEmpty() ? uncoveredLines : null;
            this.coverageProbes = coverageProbes != null && !coverageProbes.isEmpty() ? coverageProbes : null;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public CompactLines getFullyCoveredLines() {
            return this.fullyCoveredLines;
        }

        public @Nullable CompactLines getPartiallyCoveredLines() {
            return this.partiallyCoveredLines;
        }

        public @Nullable CompactLines getUncoveredLines() {
            return this.uncoveredLines;
        }

        public @Nullable List<CoverageProbeBase> getCoverageProbes() {
            return this.coverageProbes;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            CompactCoverageFileInfo that = (CompactCoverageFileInfo)obj;
            return Objects.equals(this.filePath, that.filePath) && Objects.equals(this.fullyCoveredLines, that.fullyCoveredLines) && Objects.equals(this.partiallyCoveredLines, that.partiallyCoveredLines) && Objects.equals(this.uncoveredLines, that.uncoveredLines) && Objects.equals(this.coverageProbes, that.coverageProbes);
        }

        public int hashCode() {
            return Objects.hash(this.filePath, this.fullyCoveredLines, this.partiallyCoveredLines, this.uncoveredLines, this.coverageProbes);
        }

        public String toString() {
            return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
        }
    }
}

