/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser.ctc;

public class ProbeInfo {
    private final EExecutionInfo executedWithTrueValue;
    private final EExecutionInfo executedWithFalseValue;
    private final int lineNumber;
    private final String type;
    private final int nestingDepth;

    public ProbeInfo(EExecutionInfo executedWithTrueValue, EExecutionInfo executedWithFalseValue, int lineNumber, int nestingDepth, String type) {
        this.executedWithTrueValue = executedWithTrueValue;
        this.executedWithFalseValue = executedWithFalseValue;
        this.lineNumber = lineNumber;
        this.nestingDepth = nestingDepth;
        this.type = type;
    }

    public EExecutionInfo getExecutedWithTrueValue() {
        return this.executedWithTrueValue;
    }

    public EExecutionInfo getExecutedWithFalseValue() {
        return this.executedWithFalseValue;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getNestingDepth() {
        return this.nestingDepth;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.type + " : " + this.lineNumber;
    }

    public static enum EExecutionInfo {
        EXECUTED,
        NOT_EXECUTED,
        NO_INFORMATION;


        public static EExecutionInfo fromInt(int value) {
            if (value == -1) {
                return NO_INFORMATION;
            }
            if (value == 0) {
                return NOT_EXECUTED;
            }
            if (value > 0) {
                return EXECUTED;
            }
            throw new IllegalArgumentException("Unexpected value: " + value);
        }
    }
}

