/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.dotnet.fxcop;

import eu.cqse.check.framework.core.registry.CheckMapping;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.util.XMLReaderBase;
import org.conqat.engine.dotnet.fxcop.EFxCopAttribute;
import org.conqat.engine.dotnet.fxcop.EFxCopElement;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.IXMLElementProcessor;

public class FxCopReportReader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final FxCopFindingsCreator findingsCreator;
    private final Map<String, CheckMapping> checkMappingsByName;

    public FxCopReportReader(FxCopFindingsCreator findingsCreator, Map<String, CheckMapping> checkMappingsByName) {
        this.checkMappingsByName = checkMappingsByName;
        this.findingsCreator = findingsCreator;
    }

    public void loadReport(String report) throws ConQATException {
        new FxCopFileReader(this, report).parse();
    }

    public static interface FxCopFindingsCreator {
        public void apply(String var1, String var2, String var3, String var4, String var5, int var6, String var7, String var8) throws ConQATException;
    }

    private class FxCopFileReader
    extends XMLReaderBase<EFxCopElement, EFxCopAttribute, ConQATException> {
        final /* synthetic */ FxCopReportReader this$0;

        public FxCopFileReader(FxCopReportReader fxCopReportReader, String report) {
            FxCopReportReader fxCopReportReader2 = fxCopReportReader;
            Objects.requireNonNull(fxCopReportReader2);
            this.this$0 = fxCopReportReader2;
            super(report, EFxCopAttribute.class);
        }

        public void parse() throws ConQATException {
            this.parseAndWrapExceptions();
            this.readExceptions();
            this.extractRules();
            this.createFindings();
        }

        private void extractRules() throws ConQATException {
            this.processDecendantElements(new RuleProcessor(this));
        }

        private void createFindings() throws ConQATException {
            this.processDecendantElements(new NamespaceProcessor(this));
        }

        private void readExceptions() throws ConQATException {
            this.processDecendantElements(new AnalysisExcpetionProcessor(this));
        }

        protected String getLocation() {
            return "FxCop Report";
        }

        private class RuleProcessor
        implements IXMLElementProcessor<EFxCopElement, ConQATException> {
            final /* synthetic */ FxCopFileReader this$1;

            private RuleProcessor(FxCopFileReader fxCopFileReader) {
                FxCopFileReader fxCopFileReader2 = fxCopFileReader;
                Objects.requireNonNull(fxCopFileReader2);
                this.this$1 = fxCopFileReader2;
            }

            public EFxCopElement getTargetElement() {
                return EFxCopElement.Rule;
            }

            public void process() {
                String typeName = this.this$1.getStringAttribute(EFxCopAttribute.TypeName);
                String description = this.this$1.getChildText(EFxCopElement.Description);
                CCSMAssert.isFalse((boolean)StringUtils.isEmpty((String)typeName), (String)"The type name of the rule should not be empty");
                CCSMAssert.isFalse((boolean)StringUtils.isEmpty((String)description), (String)"The description of the rule should not be empty");
            }
        }

        private class NamespaceProcessor
        implements IXMLElementProcessor<EFxCopElement, ConQATException> {
            final /* synthetic */ FxCopFileReader this$1;

            private NamespaceProcessor(FxCopFileReader fxCopFileReader) {
                FxCopFileReader fxCopFileReader2 = fxCopFileReader;
                Objects.requireNonNull(fxCopFileReader2);
                this.this$1 = fxCopFileReader2;
            }

            public EFxCopElement getTargetElement() {
                return EFxCopElement.Namespace;
            }

            public void process() throws ConQATException {
                String namespaceName = this.this$1.getStringAttribute(EFxCopAttribute.Name);
                this.this$1.processDecendantElements(new TypeProcessor(this.this$1, namespaceName));
            }
        }

        private class AnalysisExcpetionProcessor
        implements IXMLElementProcessor<EFxCopElement, ConQATException> {
            final /* synthetic */ FxCopFileReader this$1;

            private AnalysisExcpetionProcessor(FxCopFileReader fxCopFileReader) {
                FxCopFileReader fxCopFileReader2 = fxCopFileReader;
                Objects.requireNonNull(fxCopFileReader2);
                this.this$1 = fxCopFileReader2;
            }

            public EFxCopElement getTargetElement() {
                return EFxCopElement.Exception;
            }

            public void process() {
                Object message = this.this$1.getChildText(EFxCopElement.ExceptionMessage);
                String innerMessage = this.this$1.getChildText(EFxCopElement.InnerExceptionMessage);
                if (!StringUtils.isEmpty((String)innerMessage)) {
                    message = (String)message + StringUtils.LINE_SEPARATOR + innerMessage;
                }
                LOGGER.warn("FxCop threw an exception while writing " + UniformPathUtils.getElementName((String)UniformPathUtils.normalizeAllSeparators((String)this.this$1.getLocation())) + StringUtils.LINE_SEPARATOR + (String)message);
            }
        }

        public class IssueProcessor
        implements IXMLElementProcessor<EFxCopElement, ConQATException> {
            private final String fxCopCheckId;
            private final String fxCopCheckName;
            private final String fqTypeName;
            final /* synthetic */ FxCopFileReader this$1;

            public IssueProcessor(FxCopFileReader this$1, String fxCopCheckId, String fxCopCheckName, String fqTypeName) {
                FxCopFileReader fxCopFileReader = this$1;
                Objects.requireNonNull(fxCopFileReader);
                this.this$1 = fxCopFileReader;
                this.fxCopCheckId = fxCopCheckId;
                this.fxCopCheckName = fxCopCheckName;
                this.fqTypeName = fqTypeName;
            }

            public EFxCopElement getTargetElement() {
                return EFxCopElement.Issue;
            }

            public void process() throws ConQATException {
                String message = this.this$1.getText();
                if (StringUtils.isEmpty((String)message)) {
                    message = "<missing message>";
                }
                String path = this.this$1.getStringAttribute(EFxCopAttribute.Path);
                String file = this.this$1.getStringAttribute(EFxCopAttribute.File);
                this.this$1.this$0.findingsCreator.apply(message, path, file, this.fxCopCheckName, this.fqTypeName, this.getLineNumber(), this.fxCopCheckId, this.fxCopCheckName);
            }

            private int getLineNumber() {
                String lineAsString = this.this$1.getStringAttribute(EFxCopAttribute.Line);
                if (StringUtils.isEmpty((String)lineAsString)) {
                    return 0;
                }
                try {
                    return Integer.parseInt(lineAsString);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Error parsing line for finding at " + lineAsString);
                    return -1;
                }
            }
        }

        public class MessageProcessor
        implements IXMLElementProcessor<EFxCopElement, ConQATException> {
            private final String fqTypeName;
            final /* synthetic */ FxCopFileReader this$1;

            public MessageProcessor(FxCopFileReader this$1, String fqTypeNme) {
                FxCopFileReader fxCopFileReader = this$1;
                Objects.requireNonNull(fxCopFileReader);
                this.this$1 = fxCopFileReader;
                this.fqTypeName = fqTypeNme;
            }

            public EFxCopElement getTargetElement() {
                return EFxCopElement.Message;
            }

            public void process() throws ConQATException {
                String fxCopCheckId = this.this$1.getStringAttribute(EFxCopAttribute.CheckId);
                Optional<String> fxCopCheckName = this.this$1.this$0.checkMappingsByName.keySet().stream().filter(checkName -> checkName.contains(fxCopCheckId)).findAny();
                CCSMAssert.isTrue((boolean)fxCopCheckName.isPresent(), (String)(String.valueOf((Object)EFxCopAttribute.TypeName) + "must not be empty"));
                CCSMAssert.isFalse((boolean)StringUtils.isEmpty((String)fxCopCheckId), (String)(String.valueOf((Object)EFxCopAttribute.CheckId) + "must not be empty"));
                this.this$1.processChildElements(new IssueProcessor(this.this$1, fxCopCheckId, fxCopCheckName.get(), this.fqTypeName));
            }
        }

        private class TypeProcessor
        implements IXMLElementProcessor<EFxCopElement, ConQATException> {
            private final String namespaceName;
            final /* synthetic */ FxCopFileReader this$1;

            public TypeProcessor(FxCopFileReader fxCopFileReader, String namespaceName) {
                FxCopFileReader fxCopFileReader2 = fxCopFileReader;
                Objects.requireNonNull(fxCopFileReader2);
                this.this$1 = fxCopFileReader2;
                this.namespaceName = namespaceName;
            }

            public EFxCopElement getTargetElement() {
                return EFxCopElement.Type;
            }

            public void process() throws ConQATException {
                Object typeName = this.this$1.getStringAttribute(EFxCopAttribute.Name);
                CCSMAssert.isFalse((boolean)StringUtils.isEmpty((String)typeName), (String)"Type name not set");
                if (!StringUtils.isEmpty((String)this.namespaceName)) {
                    typeName = this.namespaceName + "." + (String)typeName;
                }
                this.this$1.processDecendantElements(new MessageProcessor(this.this$1, (String)typeName));
            }
        }
    }
}

