/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.logging;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.conqat.engine.core.logging.LogEventCollection;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

class LogEventCollector {
    private final ConcurrentMap<Thread, LogEventCollection> eventsPerThread = new ConcurrentHashMap<Thread, LogEventCollection>();
    private final Lock globalLock;
    private final Lock threadSpecificLock;

    public LogEventCollector() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.globalLock = lock.writeLock();
        this.threadSpecificLock = lock.readLock();
    }

    public void addEvent(LogEvent event) {
        this.threadSpecificLock.lock();
        try {
            this.eventsPerThread.computeIfAbsent(Thread.currentThread(), ignored -> new LogEventCollection()).addEvent(event);
        }
        finally {
            this.threadSpecificLock.unlock();
        }
    }

    public UnmodifiableList<LogEvent> getLogEvents() {
        return CollectionUtils.asUnmodifiable(new ArrayList<LogEvent>(this.getCombinedEvents().getEvents()));
    }

    public UnmodifiableList<LogEvent> getLogEvents(Set<Level> levels) {
        return CollectionUtils.asUnmodifiable((List)CollectionUtils.filter(this.getCombinedEvents().getEvents(), event -> levels.contains(event.getLevel())));
    }

    public int getEventCount(Level level) {
        return this.getCombinedEvents().getCountsPerLevel().getValue((Object)level);
    }

    private LogEventCollection getCombinedEvents() {
        this.globalLock.lock();
        try {
            LogEventCollection logEventCollection = switch (this.eventsPerThread.size()) {
                case 0 -> LogEventCollection.EMPTY;
                case 1 -> this.getEventsOfSingleThread();
                default -> this.combineEvents();
            };
            return logEventCollection;
        }
        finally {
            this.globalLock.unlock();
        }
    }

    private LogEventCollection getEventsOfSingleThread() {
        Thread key = (Thread)Iterables.getOnlyElement(this.eventsPerThread.keySet());
        Thread currentThread = Thread.currentThread();
        if (!currentThread.equals(key)) {
            this.eventsPerThread.put(currentThread, (LogEventCollection)this.eventsPerThread.remove(key));
        }
        return (LogEventCollection)this.eventsPerThread.get(currentThread);
    }

    private LogEventCollection combineEvents() {
        LogEventCollection combined = LogEventCollection.merge(this.eventsPerThread.values());
        this.eventsPerThread.clear();
        this.eventsPerThread.put(Thread.currentThread(), combined);
        return combined;
    }
}

