/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.pointer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011J0\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J\u001a\u0010\u0016\u001a\u00020\u00042\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0019"}, d2={"Lru/bozaro/gitlfs/pointer/Pointer;", "", "()V", "PREFIX", "", "REQUIRED", "", "Lru/bozaro/gitlfs/pointer/Pointer$RequiredKey;", "[Lru/bozaro/gitlfs/pointer/Pointer$RequiredKey;", "createPointer", "", "", "oid", "size", "", "parsePointer", "stream", "Ljava/io/InputStream;", "blob", "offset", "", "length", "serializePointer", "pointer", "RequiredKey", "gitlfs-pointer"})
public final class Pointer {
    @NotNull
    public static final Pointer INSTANCE = new Pointer();
    @NotNull
    private static final byte[] PREFIX;
    @NotNull
    private static final RequiredKey[] REQUIRED;

    private Pointer() {
    }

    @NotNull
    public final byte[] serializePointer(@NotNull Map<String, String> pointer) {
        Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
        Map data = new TreeMap<String, String>(pointer);
        StringBuilder buffer = new StringBuilder();
        Pointer $this$serializePointer_u24lambda_u240 = this;
        boolean bl = false;
        String version = (String)data.remove("version");
        if (version == null) {
            version = "https://git-lfs.github.com/spec/v1";
        }
        buffer.append("version").append(' ').append(version).append('\n');
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            buffer.append(key).append(' ').append(value).append('\n');
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        String string2 = string;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @NotNull
    public final Map<String, String> createPointer(@NotNull String oid, long size) {
        Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
        TreeMap pointer = new TreeMap();
        ((Map)pointer).put("version", "https://git-lfs.github.com/spec/v1");
        ((Map)pointer).put("oid", oid);
        ((Map)pointer).put("size", String.valueOf(size));
        return pointer;
    }

    @Nullable
    public final Map<String, String> parsePointer(@NotNull InputStream stream) throws IOException {
        int len;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        byte[] buffer = new byte[1024];
        for (int size = 0; size < buffer.length; size += len) {
            len = stream.read(buffer, size, buffer.length - size);
            if (len > 0) continue;
            return this.parsePointer(buffer, 0, size);
        }
        return null;
    }

    @Nullable
    public final Map<String, String> parsePointer(@NotNull byte[] blob, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)blob, (String)"blob");
        if (length < PREFIX.length) {
            return null;
        }
        int n = PREFIX.length;
        for (int i = 0; i < n; ++i) {
            if (blob[i] == PREFIX[i]) continue;
            return null;
        }
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        String lastKey = null;
        int keyOffset = offset;
        int required = 0;
        while (keyOffset < length) {
            int valueOffset;
            block13: {
                valueOffset = keyOffset;
                while (++valueOffset < length) {
                    byte c = blob[valueOffset];
                    if (c != 32) {
                        if (c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 46 || c == 45) continue;
                    }
                    break block13;
                }
                return null;
            }
            int endOffset = valueOffset;
            do {
                if (++endOffset < length) continue;
                return null;
            } while (blob[endOffset] != 10);
            int n2 = valueOffset - keyOffset;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Object object = charset;
            String key = new String(blob, keyOffset, n2, (Charset)object);
            try {
                String string = decoder.decode(ByteBuffer.wrap(blob, valueOffset + 1, endOffset - valueOffset - 1)).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n                decode\u2026.toString()\n            }");
                object = string;
            }
            catch (CharacterCodingException e) {
                return null;
            }
            Object value = object;
            if (required < REQUIRED.length && Intrinsics.areEqual((Object)REQUIRED[required].getName(), (Object)key)) {
                if (!REQUIRED[required].getPattern().matcher((CharSequence)value).matches()) {
                    return null;
                }
                ++required;
            }
            if (keyOffset > offset) {
                if (lastKey != null && key.compareTo(lastKey) <= 0) {
                    return null;
                }
                lastKey = key;
            }
            if (result.put(key, value) != null) {
                return null;
            }
            keyOffset = endOffset + 1;
        }
        return required < REQUIRED.length ? null : (Map)result;
    }

    public static /* synthetic */ Map parsePointer$default(Pointer pointer, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return pointer.parsePointer(byArray, n, n2);
    }

    static {
        RequiredKey[] requiredKeyArray = "version ";
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = requiredKeyArray.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        PREFIX = byArray;
        requiredKeyArray = new RequiredKey[2];
        Pattern pattern = Pattern.compile("^[0-9a-z]+:[0-9a-f]+$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"^[0-9a-z]+:[0-9a-f]+$\")");
        requiredKeyArray[0] = new RequiredKey("oid", pattern);
        Pattern pattern2 = Pattern.compile("^\\d+$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(\"^\\\\d+$\")");
        requiredKeyArray[1] = new RequiredKey("size", pattern2);
        REQUIRED = requiredKeyArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lru/bozaro/gitlfs/pointer/Pointer$RequiredKey;", "", "name", "", "pattern", "Ljava/util/regex/Pattern;", "(Ljava/lang/String;Ljava/util/regex/Pattern;)V", "getName", "()Ljava/lang/String;", "getPattern", "()Ljava/util/regex/Pattern;", "gitlfs-pointer"})
    private static final class RequiredKey {
        @NotNull
        private final String name;
        @NotNull
        private final Pattern pattern;

        public RequiredKey(@NotNull String name, @NotNull Pattern pattern) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.name = name;
            this.pattern = pattern;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Pattern getPattern() {
            return this.pattern;
        }
    }
}

