/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io.inMemory;

import jetbrains.exodus.ExodusException;
import jetbrains.exodus.io.AbstractDataWriter;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.RemoveBlockType;
import jetbrains.exodus.io.inMemory.Memory;
import jetbrains.exodus.log.LogUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0014J\b\u0010\f\u001a\u00020\nH\u0014J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0014J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\u001a\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000f2\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0014J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J \u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ljetbrains/exodus/io/inMemory/MemoryDataWriter;", "Ljetbrains/exodus/io/AbstractDataWriter;", "memory", "Ljetbrains/exodus/io/inMemory/Memory;", "(Ljetbrains/exodus/io/inMemory/Memory;)V", "closed", "", "data", "Ljetbrains/exodus/io/inMemory/Memory$Block;", "checkClosed", "", "clearImpl", "closeImpl", "lock", "timeout", "", "lockInfo", "", "openOrCreateBlockImpl", "Ljetbrains/exodus/io/Block;", "address", "length", "release", "removeBlock", "blockAddress", "rbt", "Ljetbrains/exodus/io/RemoveBlockType;", "syncImpl", "truncateBlock", "write", "b", "", "off", "", "len", "Companion", "xodus-environment"})
public class MemoryDataWriter
extends AbstractDataWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Memory memory;
    private boolean closed;
    private Memory.Block data;

    public MemoryDataWriter(@NotNull Memory memory) {
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        this.memory = memory;
    }

    @NotNull
    public Block write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.checkClosed();
        Memory.Block block = this.data;
        if (block == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
            block = null;
        }
        block.write(b, off, len);
        Memory.Block block2 = this.data;
        if (block2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
            block2 = null;
        }
        return block2;
    }

    public void removeBlock(long blockAddress, @NotNull RemoveBlockType rbt) {
        Intrinsics.checkNotNullParameter((Object)rbt, (String)"rbt");
        if (!this.memory.removeBlock$xodus_environment(blockAddress)) {
            throw new ExodusException(Intrinsics.stringPlus((String)"There is no memory block by address ", (Object)blockAddress));
        }
        Companion.getLogger().info((Function0)new Function0<Object>(blockAddress){
            final /* synthetic */ long $blockAddress;
            {
                this.$blockAddress = $blockAddress;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)"Deleted file ", (Object)LogUtil.getLogFilename(this.$blockAddress));
            }
        });
    }

    public void truncateBlock(long blockAddress, long length) {
        this.memory.getOrCreateBlockData$xodus_environment(blockAddress, length);
        Companion.getLogger().info((Function0)new Function0<Object>(blockAddress){
            final /* synthetic */ long $blockAddress;
            {
                this.$blockAddress = $blockAddress;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)"Truncated file ", (Object)LogUtil.getLogFilename(this.$blockAddress));
            }
        });
    }

    public boolean lock(long timeout) {
        return true;
    }

    public boolean release() {
        return true;
    }

    @Nullable
    public String lockInfo() {
        return null;
    }

    @Override
    protected void syncImpl() {
    }

    @Override
    protected void closeImpl() {
        this.closed = true;
    }

    @Override
    protected void clearImpl() {
        this.memory.clear$xodus_environment();
    }

    @Override
    @NotNull
    protected Block openOrCreateBlockImpl(long address, long length) {
        Memory.Block result;
        this.data = result = this.memory.getOrCreateBlockData$xodus_environment(address, length);
        this.closed = false;
        return result;
    }

    private final void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Already closed");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/io/inMemory/MemoryDataWriter$Companion;", "Lmu/KLogging;", "()V", "xodus-environment"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

