/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions;

import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryBase;
import com.teamscale.index.admin.instance_comparison.comparison.PredefinedImprovedInstanceComparisonDiffEntry;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IDetailedInstanceComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.KeyValueInstanceComparisonValueBase;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.Pair;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class AssessmentInstanceComparisonValue
extends KeyValueInstanceComparisonValueBase<Assessment> {
    public AssessmentInstanceComparisonValue(@NonNull String key, @NonNull Assessment value) {
        this(key, value, null, AssessmentInstanceComparisonValue.noImprovement());
    }

    private AssessmentInstanceComparisonValue(@NonNull String key, @NonNull Assessment value, @Nullable IDetailedInstanceComparisonContribution detail, Predicate<Pair<@Nullable Assessment, @Nullable Assessment>> onlyImprovementDecider) {
        super(key, value, detail, onlyImprovementDecider, null);
    }

    @Override
    protected Optional<? extends InstanceComparisonDiffEntryBase<?>> computeDifference(InstanceComparisonContributionBase.ComparisonContext context, @Nullable KeyValueInstanceComparisonValueBase<Assessment> local, @Nullable KeyValueInstanceComparisonValueBase<Assessment> remote) {
        Assessment localValue = local != null ? (Assessment)local.value : null;
        Assessment remoteValue = remote != null ? (Assessment)remote.value : null;
        Pair localAndRemoteValue = Pair.createPair((Object)localValue, (Object)remoteValue);
        if (localValue == null || remoteValue == null) {
            return Optional.of(PredefinedImprovedInstanceComparisonDiffEntry.fromObject(this.key, localValue, remoteValue, IInstanceComparisonValue.computeExamples(this.key, local, remote), this.onlyImprovementDecider.test(localAndRemoteValue), false));
        }
        if (Objects.equals(localValue, remoteValue)) {
            return Optional.empty();
        }
        double acceptedDeviation = context.getAcceptedComparisonDeviation(this.getAcceptedDeviationKey());
        boolean withinAcceptedDeviation = true;
        for (ETrafficLightColor color : ETrafficLightColor.values()) {
            int localFrequency = localValue.getColorFrequency(color);
            int remoteFrequency = remoteValue.getColorFrequency(color);
            withinAcceptedDeviation &= IInstanceComparisonValue.isWithinAcceptedDeviation(localFrequency, remoteFrequency, acceptedDeviation);
        }
        return Optional.of(PredefinedImprovedInstanceComparisonDiffEntry.fromObject(this.key, localValue, remoteValue, IInstanceComparisonValue.computeExamples(this.key, local, remote), this.onlyImprovementDecider.test(localAndRemoteValue), withinAcceptedDeviation));
    }
}

