/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryBase;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonResultBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IInstanceComparisonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.NumbersAwareStringComparator;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS)
@IndexValueClass
public abstract class InstanceComparisonContributionBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String CONTRIBUTOR_PROPERTY = "contributor";
    public static final String NOT_FOUND = "<not found>";
    @JsonProperty(value="contributor")
    protected final String contributor;

    protected InstanceComparisonContributionBase(String contributor) {
        this.contributor = contributor;
    }

    public abstract String getProject();

    public abstract InstanceComparisonResultBase computeComparisonResult(InstanceComparisonContributionBase var1, ComparisonContext var2);

    public String getContributor() {
        return this.contributor;
    }

    public abstract Map<String, ? extends IInstanceComparisonValue> getValues(ComparisonContext var1);

    protected List<InstanceComparisonDiffEntryBase<?>> computeDiffs(InstanceComparisonContributionBase local, InstanceComparisonContributionBase remote, ComparisonContext context) {
        Map<String, ? extends IInstanceComparisonValue> localValues = InstanceComparisonContributionBase.withStableComparisonKeys(local.getValues(context));
        Map<String, ? extends IInstanceComparisonValue> remoteValues = InstanceComparisonContributionBase.withStableComparisonKeys(remote.getValues(context));
        ArrayList diffs = new ArrayList();
        List diffKeys = CollectionUtils.sort((Collection)CollectionUtils.intersectionSet(remoteValues.keySet(), (Collection[])new Collection[]{localValues.keySet()}), (Comparator)NumbersAwareStringComparator.INSTANCE);
        for (String stableKey : diffKeys) {
            if (this.isExcludedComparisonKey(stableKey)) continue;
            IInstanceComparisonValue localValue = localValues.get(stableKey);
            IInstanceComparisonValue remoteValue = remoteValues.get(stableKey);
            localValue.computeDifference(remoteValue, true, context).ifPresent(diffs::add);
        }
        return this.excludeIrrelevantEntries(diffs);
    }

    private static Map<String, ? extends IInstanceComparisonValue> withStableComparisonKeys(Map<String, ? extends IInstanceComparisonValue> comparisonValues) {
        HashMap dataWithStableKeys = new HashMap();
        comparisonValues.forEach((key, value) -> dataWithStableKeys.put(InstanceComparisonContributionBase.getStableComparisonKey(key), value));
        return dataWithStableKeys;
    }

    protected List<InstanceComparisonDiffEntryBase<?>> computeOnlyInOneInstance(InstanceComparisonContributionBase toKeep, InstanceComparisonContributionBase toSubtract, boolean keepLocal, ComparisonContext context) {
        Map<String, ? extends IInstanceComparisonValue> valuesToKeep = InstanceComparisonContributionBase.withStableComparisonKeys(toKeep.getValues(context));
        Map<String, ? extends IInstanceComparisonValue> valuesToSubtract = InstanceComparisonContributionBase.withStableComparisonKeys(toSubtract.getValues(context));
        List onlyInInstanceToKeepKeys = CollectionUtils.sort((Collection)CollectionUtils.differenceSet(valuesToKeep.keySet(), (Collection[])new Collection[]{valuesToSubtract.keySet()}), (Comparator)NumbersAwareStringComparator.INSTANCE);
        ArrayList diffs = new ArrayList(onlyInInstanceToKeepKeys.size());
        for (String key : onlyInInstanceToKeepKeys) {
            valuesToKeep.get(key).computeDifference(null, keepLocal, context).ifPresent(diffs::add);
        }
        return this.excludeIrrelevantEntries(diffs);
    }

    protected List<InstanceComparisonDiffEntryBase<?>> excludeIrrelevantEntries(List<InstanceComparisonDiffEntryBase<?>> diffs) {
        return diffs;
    }

    protected boolean isExcludedComparisonKey(String comparisonKey) {
        return false;
    }

    protected static String getStableComparisonKey(String comparisonKey) {
        if (comparisonKey.contains(".analysisGroup.")) {
            String codeScopeIdentifier = StringUtils.getFirstPart((String)comparisonKey, (String)".");
            return codeScopeIdentifier + ".analysisGroup." + StringUtils.getLastPart((String)comparisonKey, (String)".analysisGroup.");
        }
        if (comparisonKey.startsWith("connectors.")) {
            String[] splitKey = StringUtils.splitByWholeSeparator((String)comparisonKey, (String)".", (int)3);
            return splitKey[0] + ".connectorIdentifier." + splitKey[2];
        }
        return comparisonKey;
    }

    public String makeContributionKey() {
        return this.contributor + "#" + String.valueOf(this.getClass());
    }

    public static final class ComparisonContext {
        private final Collection<? extends InstanceComparisonContributionBase> localContributions;
        private final Collection<? extends InstanceComparisonContributionBase> remoteContributions;
        private final AcceptedComparisonDeviations acceptedComparisonDeviations;
        private final GlobalStorageSystem globalStorageSystem;

        public ComparisonContext(Collection<? extends InstanceComparisonContributionBase> localContributions, Collection<? extends InstanceComparisonContributionBase> remoteContributions, AcceptedComparisonDeviations acceptedComparisonDeviations, GlobalStorageSystem globalStorageSystem) {
            this.localContributions = localContributions;
            this.remoteContributions = remoteContributions;
            this.acceptedComparisonDeviations = acceptedComparisonDeviations;
            this.globalStorageSystem = globalStorageSystem;
        }

        public <T extends InstanceComparisonContributionBase> Optional<T> getLocalContribution(Class<T> contributionType) {
            return ComparisonContext.getContributionByType(this.localContributions, contributionType);
        }

        public <T extends InstanceComparisonContributionBase> Optional<T> getRemoteContribution(Class<T> contributionType) {
            return ComparisonContext.getContributionByType(this.remoteContributions, contributionType);
        }

        public double getAcceptedComparisonDeviation(String key) {
            return this.acceptedComparisonDeviations.getAcceptedComparisonDeviation(key);
        }

        public GlobalStorageSystem getGlobalStorageSystem() {
            return this.globalStorageSystem;
        }

        private static <T extends InstanceComparisonContributionBase> Optional<T> getContributionByType(Collection<? extends InstanceComparisonContributionBase> contributions, Class<T> contributionType) {
            return contributions.stream().filter(contributionType::isInstance).map(contributionType::cast).findFirst();
        }
    }

    public static class AcceptedComparisonDeviations {
        public static final AcceptedComparisonDeviations EMPTY = new AcceptedComparisonDeviations(0.0, Collections.emptyMap(), (PairList<Pattern, Double>)PairList.emptyPairList());
        private final double defaultValue;
        private final Map<String, Double> acceptedComparisonDeviations;
        private final PairList<Pattern, Double> acceptedPatternComparisonDeviations;

        public AcceptedComparisonDeviations(double defaultValue, Map<String, Double> acceptedComparisonDeviations, PairList<Pattern, Double> acceptedPatternComparisonDeviations) {
            this.defaultValue = defaultValue;
            this.acceptedComparisonDeviations = new HashMap<String, Double>(acceptedComparisonDeviations);
            this.acceptedPatternComparisonDeviations = new PairList(acceptedPatternComparisonDeviations);
        }

        public double getAcceptedComparisonDeviation(String key) {
            Double acceptedDeviation = this.acceptedComparisonDeviations.get(key);
            if (acceptedDeviation != null) {
                return acceptedDeviation;
            }
            for (Pair pair : this.acceptedPatternComparisonDeviations) {
                if (!((Pattern)pair.getFirst()).matcher(key).find()) continue;
                return (Double)pair.getSecond();
            }
            return this.defaultValue;
        }
    }
}

