/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.metrics.directory.HiddenMetricDirectoryIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryIndexBase;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.FindingsComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.IComparisonContributorContext;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributorBase;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.findings.calculation.FindingsServiceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class FindingsComparisonContributor
extends ProjectComparisonContributorBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public FindingsComparisonContributor(IComparisonContributorContext.ProjectContext context) {
        super(context);
    }

    @Override
    public FindingsComparisonContribution createComparisonInput() throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.getProjectStorageSystem();
        Map<UniformPath, List<TrackedFinding>> findingsByPath = FindingsServiceUtils.getFindingsVirtualPathAware((ProjectStorageSystem)projectStorageSystem, this.getHistoryAccessOption(), (UniformPath)UniformPath.codeRoot());
        ArrayList findings = new ArrayList();
        findingsByPath.forEach((path, findingsForPath) -> findings.addAll(findingsForPath));
        Map<String, FindingBlacklistInfo> blackListedEntries = this.getExcludedFindingsById();
        int linesOfCode = this.getLinesOfCode((ProjectStorageSystem)projectStorageSystem, this.getHistoryAccessOption());
        FindingsComparisonContribution findingsComparisonContribution = new FindingsComparisonContribution("Findings", ((IComparisonContributorContext.ProjectContext)this.context).publicProjectId().toString(), linesOfCode, ((IComparisonContributorContext.ProjectContext)this.context).detailed());
        block4: for (TrackedFinding finding : findings) {
            String findingCategory = finding.getQualifiedGroupName() + "/" + finding.getTypeId();
            String findingId = finding.getId();
            if (!blackListedEntries.containsKey(findingId)) {
                findingsComparisonContribution.addNonBlacklisted(findingCategory, finding);
                continue;
            }
            FindingBlacklistInfo findingBlacklistInfo = blackListedEntries.get(findingId);
            EFindingBlacklistType blacklistType = findingBlacklistInfo.getType();
            switch (blacklistType) {
                case FALSE_POSITIVE: {
                    findingsComparisonContribution.addFalsePositive(findingCategory, finding);
                    continue block4;
                }
                case TOLERATION: {
                    findingsComparisonContribution.addTolerated(findingCategory, finding);
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unsupported flagging type: " + String.valueOf((Object)blacklistType));
        }
        return findingsComparisonContribution;
    }

    private Map<String, FindingBlacklistInfo> getExcludedFindingsById() throws StorageException {
        FindingBlacklistIndex blacklistIndex = (FindingBlacklistIndex)this.getProjectStorageSystem().openProjectIndex(FindingBlacklistIndex.class, this.getHistoryAccessOption());
        return blacklistIndex.getAllBlacklistInfos();
    }

    private int getLinesOfCode(ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        MetricDirectorySchema schema = ((MetricSchemaIndex)projectStorageSystem.openProjectIndex(MetricSchemaIndex.class, "metric-schema", historyAccessOption.cloneToUnbranchedAccessOption())).getSchema(false);
        if (schema == null) {
            LOGGER.warn("No metrics schema found for project '{}'. This may be caused by the project being empty.", (Object)((IComparisonContributorContext.ProjectContext)this.context).publicProjectId());
            return 0;
        }
        MetricDirectorySchemaEntry locEntry = schema.getEntry("Lines of Code");
        if (locEntry == null) {
            LOGGER.error("No metric '{}' found for project '{}'.", (Object)"Lines of Code", (Object)((IComparisonContributorContext.ProjectContext)this.context).publicProjectId());
            return 0;
        }
        MetricDirectoryIndexBase metricDirectoryIndex = FindingsComparisonContributor.getMetricDirectoryIndexBase(projectStorageSystem, historyAccessOption, locEntry);
        MetricDirectoryEntry metrics = metricDirectoryIndex.getMetricDirectoryEntry(UniformPath.codeRoot().toString());
        if (metrics == null) {
            LOGGER.warn("Unable to get metrics for code root of project '{}' from '{}'.", (Object)((IComparisonContributorContext.ProjectContext)this.context).publicProjectId(), (Object)metricDirectoryIndex.getName());
            return 0;
        }
        int locEntryPosition = (int)schema.getAllEntries().stream().filter(entry -> entry.isHidden() == locEntry.isHidden()).takeWhile(entry -> entry != locEntry).count();
        Number value = (Number)metrics.getValueWithoutNullAssert(locEntryPosition, Number.class);
        if (value == null) {
            LOGGER.warn("No value found for metric '{}' for project '{}'.", (Object)"Lines of Code", (Object)((IComparisonContributorContext.ProjectContext)this.context).publicProjectId());
            return 0;
        }
        return value.intValue();
    }

    private static MetricDirectoryIndexBase getMetricDirectoryIndexBase(ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption, MetricDirectorySchemaEntry locEntry) throws StorageException {
        if (locEntry.isHidden()) {
            return (MetricDirectoryIndexBase)projectStorageSystem.openProjectIndex(HiddenMetricDirectoryIndex.class, historyAccessOption);
        }
        return (MetricDirectoryIndexBase)projectStorageSystem.openProjectIndex(MetricDirectoryIndex.class, "metric-directory", historyAccessOption);
    }
}

