/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.tga;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.tga.TestGapAnalysisComparisonContribution;
import com.teamscale.index.testgap.ETestGapState;
import java.io.Serializable;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass
public class TgaTrend
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TREND_ELEMENTS_PROPERTY = "elements";
    private static final String END_COMMIT_PROPERTY = "endCommit";
    private static final String BASELINE_PROPERTY = "baseline";
    @JsonProperty(value="baseline")
    private final long baseline;
    @JsonProperty(value="endCommit")
    private final @NonNull CommitDescriptor endCommit;
    @JsonProperty(value="elements")
    private final @NonNull List<TgaTrendElement> trendElements;

    @JsonCreator
    TgaTrend(@JsonProperty(value="baseline") long baseline, @JsonProperty(value="endCommit") @NonNull CommitDescriptor endCommit, @JsonProperty(value="elements") @NonNull List<TgaTrendElement> trendElements) {
        CCSMAssert.isNotNull((Object)endCommit, () -> String.format("Expected \"%s\" to be not null", END_COMMIT_PROPERTY));
        CCSMAssert.isNotNull(trendElements, () -> String.format("Expected \"%s\" to be not null", TREND_ELEMENTS_PROPERTY));
        this.baseline = baseline;
        this.endCommit = endCommit;
        this.trendElements = trendElements;
    }

    public long getBaseline() {
        return this.baseline;
    }

    public @NonNull CommitDescriptor getEndCommit() {
        return this.endCommit;
    }

    public @NonNull UnmodifiableList<TgaTrendElement> getTrendElements() {
        return CollectionUtils.asUnmodifiable(this.trendElements);
    }

    public String toString() {
        return "TgaTrend{baseline=" + this.baseline + ", endCommit=" + String.valueOf(this.endCommit) + ", trendElements=" + String.valueOf(this.trendElements) + "}";
    }

    @IndexValueClass
    static class TgaTrendElement
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String TIME_PROPERTY = "time";
        private static final String COUNTS_PROPERTY = "counts";
        @JsonProperty(value="time")
        private final long timestamp;
        @JsonProperty(value="counts")
        private final CounterSet<ETestGapState> counts;

        @JsonCreator
        TgaTrendElement(@JsonProperty(value="time") long timestamp, @JsonProperty(value="counts") @NonNull CounterSet<ETestGapState> counts) {
            CCSMAssert.isNotNull(counts, () -> String.format("Expected \"%s\" to be not null", COUNTS_PROPERTY));
            this.timestamp = timestamp;
            this.counts = counts;
        }

        public static TgaTrendElement of( @NonNull TgaTrendComputer.TgaTrendEntry trendEntry) {
            CCSMAssert.isNotNull((Object)trendEntry, () -> String.format("Expected \"%s\" to be not null", "trendEntry"));
            TestGapAnalysisComparisonContribution.assertOnlyExpectedStates(trendEntry.counts().keySet(), TestGapAnalysisComparisonContribution.EXPECTED_TEST_GAP_COUNT_STATES);
            CounterSet counts = CounterSet.forEnum(ETestGapState.class);
            trendEntry.counts().forEach((arg_0, arg_1) -> ((CounterSet)counts).inc(arg_0, arg_1));
            return new TgaTrendElement(trendEntry.timestamp(), (CounterSet<ETestGapState>)counts);
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public CounterSet<ETestGapState> getCounts() {
            return this.counts;
        }

        public String toString() {
            return "TgaTrendElement{timestamp=" + this.timestamp + ", counts=" + String.valueOf(this.counts) + "}";
        }
    }
}

