/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.external;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class ArchitectureUploadInfo
implements Serializable {
    private static final long serialVersionUID = -4894162605958922168L;
    private static final String USERNAME_PROPERTY = "username";
    private static final String MESSAGE_PROPERTY = "message";
    private static final String UNIFORM_PATHS_PROPERTY = "uniformPaths";
    private static final String DELETED_ARCHITECTURES_PROPERTY = "deletedArchitectures";
    private static final String ARCHITECTURES_PROPERTY = "architectures";
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="uniformPaths")
    private final List<String> uniformPaths;
    @JsonProperty(value="deletedArchitectures")
    private final List<String> deletedArchitectures;
    @JsonProperty(value="architectures")
    private final List<String> architectures;

    @JsonCreator
    public ArchitectureUploadInfo(@JsonProperty(value="username") String username, @JsonProperty(value="message") String message, @JsonProperty(value="uniformPaths") List<String> uniformPaths, @JsonProperty(value="architectures") List<String> architectures, @JsonProperty(value="deletedArchitectures") List<String> deletedArchitectures) {
        CCSMAssert.isNotEmpty((String)username, (String)"Username must not be empty");
        CCSMAssert.isNotEmpty((String)message, (String)"Message must not be empty");
        this.username = username;
        this.message = message;
        CCSMAssert.isTrue((uniformPaths.size() == architectures.size() ? 1 : 0) != 0, (String)"Expected same number of paths and architectures");
        this.uniformPaths = uniformPaths;
        this.architectures = architectures;
        this.deletedArchitectures = deletedArchitectures;
    }

    public String getUsername() {
        return this.username;
    }

    public List<String> getArchitectures() {
        return this.architectures;
    }

    public List<String> getUniformPaths() {
        return this.uniformPaths;
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getDeletedArchitectures() {
        return this.deletedArchitectures;
    }
}

