/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.google.common.collect.Iterables;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.architecture.incremental.ArchitectureAnalysisUtils;
import com.teamscale.index.architecture.incremental.ArchitectureComponentMapper;
import com.teamscale.index.architecture.incremental.ArchitectureComponentMappingUpdater;
import com.teamscale.index.architecture.incremental.ArchitectureMappingIndex;
import com.teamscale.index.architecture.incremental.TypeComponentMapping;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ArchitectureAnalysisSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @DeltaSource.Named(index=TokenElementIndex.class, name="content")
    private KeyDelta contentDelta;
    @DeltaSource(value=TypeIndex.class)
    private KeyDelta typeDelta;
    @DeltaSource(value=TypeDependencyIndex.class)
    private KeyDelta typeDependencyDelta;
    @IndexAccess.Named(mode=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, name="content")
    private TokenElementIndex previousContentIndex;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="content")
    private TokenElementIndex contentIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private TypeDependencyIndex previousTypeDependencyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TypeDependencyIndex typeDependencyIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private TypeIndex previousTypeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TypeIndex typeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ArchitectureMappingIndex architectureMetaInfoIndex;

    public void execute() throws ConQATException, ExecutionException {
        List<String> changedArchitectures = this.analyzeChangedArchitectures();
        this.updateArchitectures(changedArchitectures);
    }

    private void updateArchitectures(List<String> changedArchitectures) throws ConQATException, ExecutionException {
        if (this.typeDelta.isEmpty() && this.typeDependencyDelta.isEmpty()) {
            return;
        }
        ArchitectureComponentMappingUpdater updater = new ArchitectureComponentMappingUpdater(this.typeDelta, this.typeDependencyDelta, this.previousContentIndex, this.contentIndex, this.previousTypeIndex, this.typeIndex, this.previousTypeDependencyIndex, this.typeDependencyIndex, this.architectureMetaInfoIndex, this.getParallelTaskExecutor());
        List<String> architectures = this.architectureMetaInfoIndex.getAllArchitectures();
        architectures.removeAll(changedArchitectures);
        PairList result = new PairList();
        this.executeInParallelBatches(architectures, architecturesBatch -> {
            String architecturePath = (String)CollectionUtils.getAny((Iterable)architecturesBatch);
            updater.updateComponentMapping(architecturePath).ifPresent(mapping -> {
                ArchitectureAnalysisSynchronizer.logOverlaps(architecturePath, mapping);
                PairList pairList = result;
                synchronized (pairList) {
                    result.add(Pair.createPair((Object)architecturePath, (Object)mapping));
                }
            });
        }, 1);
        this.architectureMetaInfoIndex.setArchitecturesAndChanges((PairList<String, TypeComponentMapping>)result);
    }

    private List<String> analyzeChangedArchitectures() throws StorageException, ExecutionException {
        this.removeMappingsForDeletedArchitectures();
        List<String> changedArchitectures = ArchitectureAnalysisUtils.filterArchitectureFiles(this.contentDelta.getAddedOrChangedKeysAsStrings());
        if (changedArchitectures.isEmpty()) {
            return changedArchitectures;
        }
        List<TokenElementInfo> changedArchitectureElements = this.contentIndex.getTokenElements(changedArchitectures);
        PairList results = new PairList();
        ArchitectureComponentMapper analyzer = new ArchitectureComponentMapper(this.typeDependencyIndex, this.typeIndex, this.getParallelTaskExecutor());
        this.executeInParallelBatches(changedArchitectureElements, architecturesBatch -> {
            Pair<String, TypeComponentMapping> result = analyzer.createComponentMapping((TokenElementInfo)((Object)((Object)Iterables.getOnlyElement((Iterable)architecturesBatch))));
            ArchitectureAnalysisSynchronizer.logOverlaps((String)result.getFirst(), (TypeComponentMapping)result.getSecond());
            PairList pairList = results;
            synchronized (pairList) {
                results.add(result);
            }
        }, 1);
        this.architectureMetaInfoIndex.setArchitecturesAndChanges((PairList<String, TypeComponentMapping>)results);
        return changedArchitectures;
    }

    private void removeMappingsForDeletedArchitectures() throws StorageException {
        List<String> deletedArchitectures = ArchitectureAnalysisUtils.filterArchitectureFiles(this.contentDelta.getDeletedKeysAsStrings());
        this.architectureMetaInfoIndex.removeArchitectures(deletedArchitectures);
    }

    private static void logOverlaps(String architecturePath, TypeComponentMapping mapping) {
        if (!mapping.getComponentOverlaps().isEmpty()) {
            LOGGER.warn("Architecture '{}' has types, which can be mapped to multiple components. This might lead to types being mapped to unintended components. Please clarify the include/exclude patterns of the components. Types and their possible components: {}", (Object)architecturePath, (Object)mapping.getComponentOverlaps());
        }
    }
}

