/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.architecture.assessment.ArchitectureAssessor;
import com.teamscale.index.architecture.assessment.shared.Dependency;
import com.teamscale.index.architecture.assessment.shared.TypeDependency;
import com.teamscale.index.architecture.incremental.ArchitectureAnalysisUtils;
import com.teamscale.index.architecture.incremental.ArchitectureComponentDependencyIndex;
import com.teamscale.index.architecture.incremental.ArchitectureFileDependenciesIndex;
import com.teamscale.index.architecture.incremental.ArchitectureMappingIndex;
import com.teamscale.index.architecture.incremental.ArchitectureTypeDependenciesIndex;
import com.teamscale.index.architecture.incremental.ComponentDependencyContainer;
import com.teamscale.index.architecture.incremental.DependencyValueClass;
import com.teamscale.index.architecture.incremental.TypeComponentMapping;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.dependencies.DependencyListIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ArchitectureComponentDependencySynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="content")
    private TokenElementIndex contentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ArchitectureFileDependenciesIndex fileScopeIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private ArchitectureTypeDependenciesIndex typeScopeIndexLastCommit;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ArchitectureTypeDependenciesIndex typeScopeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ArchitectureMappingIndex architectureMetaInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ArchitectureComponentDependencyIndex architectureComponentDependencyIndex;
    @DeltaSource(value=ArchitectureFileDependenciesIndex.class)
    private KeyDelta fileScopeDelta;
    @DeltaSource(value=ArchitectureTypeDependenciesIndex.class)
    private KeyDelta typeScopeDelta;
    @DeltaSource.Named(index=TokenElementIndex.class, name="content")
    private KeyDelta contentDelta;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="dependencies")
    private DependencyListIndex dependencyIndex;
    @IndexAccess.Named(mode=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, name="dependencies")
    private DependencyListIndex dependencyIndexLastCommit;

    public void execute() throws ConQATException, ExecutionException {
        List<String> changedArchitectures = this.updateCompleteArchitectures();
        this.updateIncrementalArchitectures(changedArchitectures);
    }

    private List<String> updateCompleteArchitectures() throws StorageException, ExecutionException {
        List<String> changedArchitectures = ArchitectureAnalysisUtils.filterArchitectureFiles(this.contentDelta.getAddedOrChangedKeysAsStrings());
        if (changedArchitectures.isEmpty()) {
            return changedArchitectures;
        }
        this.removeMappingsForDeletedArchitectures();
        this.architectureComponentDependencyIndex.removeDependencies(changedArchitectures);
        Set<String> matchedFiles = Collections.synchronizedSet(new HashSet());
        Set<String> matchedTypes = Collections.synchronizedSet(new HashSet());
        List loadedArchitectures = Collections.synchronizedList(new ArrayList());
        this.executeInParallelBatches(changedArchitectures, architecturesBatch -> this.loadArchitectures((List<String>)architecturesBatch, matchedTypes, matchedFiles, loadedArchitectures), 1);
        ComponentDependencyContainer dependencyContainer = new ComponentDependencyContainer(this.fileScopeDelta, this.typeScopeDelta, this.fileScopeIndex, this.typeScopeIndex, this.typeScopeIndexLastCommit, this.dependencyIndex, this.dependencyIndexLastCommit, matchedFiles, matchedTypes);
        this.executeInParallelBatches(loadedArchitectures, architecturesBatch -> this.updateArchitecture((List<LoadedArchitecture>)architecturesBatch, dependencyContainer), 1);
        return changedArchitectures;
    }

    private void loadArchitectures(List<String> architecturesBatch, Set<String> matchedTypes, Set<String> matchedFiles, List<LoadedArchitecture> loadedArchitectures) throws ConQATException {
        String architecturePath = (String)CollectionUtils.getAny(architecturesBatch);
        TypeComponentMapping typeComponentMapping = this.architectureMetaInfoIndex.getMapping(architecturePath);
        if (typeComponentMapping == null) {
            return;
        }
        ArchitectureDefinition architectureDefinition = this.getArchitectureDefinition(architecturePath);
        loadedArchitectures.add(new LoadedArchitecture(architectureDefinition, typeComponentMapping));
        if (architectureDefinition.isFileBased()) {
            matchedFiles.addAll(typeComponentMapping.getMatchedTypes());
        } else {
            matchedTypes.addAll(typeComponentMapping.getMatchedTypes());
        }
    }

    private void updateArchitecture(List<LoadedArchitecture> architecturesBatch, ComponentDependencyContainer dependencyContainer) throws ConQATException {
        LoadedArchitecture loadedArchitecture = (LoadedArchitecture)CollectionUtils.getAny(architecturesBatch);
        CCSMAssert.isNotNull((Object)loadedArchitecture);
        TypeComponentMapping typeComponentMapping = loadedArchitecture.typeComponentMapping;
        ArchitectureDefinition architectureDefinition = loadedArchitecture.architectureDefinition;
        ArrayList<String> matchedTypes = new ArrayList<String>(typeComponentMapping.getMatchedTypes());
        SetMap<String, String> dependencies = dependencyContainer.getDependencies(architectureDefinition.isFileBased(), matchedTypes);
        ArchitectureAssessor assessor = new ArchitectureAssessor(architectureDefinition, dependencies, typeComponentMapping);
        UnmodifiableList<Dependency> allDependencies = assessor.getAllDependencies();
        this.architectureComponentDependencyIndex.setArchitecturesAndChanges(architectureDefinition.getName(), (List<Dependency>)allDependencies);
    }

    private void removeMappingsForDeletedArchitectures() throws StorageException {
        List<String> deletedArchitectures = ArchitectureAnalysisUtils.filterArchitectureFiles(this.contentDelta.getDeletedKeysAsStrings());
        this.architectureComponentDependencyIndex.removeDependencies(deletedArchitectures);
    }

    private void updateIncrementalArchitectures(List<String> changedArchitectures) throws ConQATException, ExecutionException {
        List<String> architectures = this.architectureMetaInfoIndex.getAllArchitectures();
        architectures.removeAll(changedArchitectures);
        if (architectures.isEmpty()) {
            return;
        }
        Set<String> matchedFiles = Collections.synchronizedSet(new HashSet());
        Set<String> matchedTypes = Collections.synchronizedSet(new HashSet());
        List loadedArchitectures = Collections.synchronizedList(new ArrayList());
        this.executeInParallelBatches(architectures, architecturesBatch -> this.loadArchitectures((List<String>)architecturesBatch, matchedTypes, matchedFiles, loadedArchitectures), 1);
        ComponentDependencyContainer dependencyContainer = new ComponentDependencyContainer(this.fileScopeDelta, this.typeScopeDelta, this.fileScopeIndex, this.typeScopeIndex, this.typeScopeIndexLastCommit, this.dependencyIndex, this.dependencyIndexLastCommit, matchedFiles, matchedTypes);
        this.executeInParallelBatches(loadedArchitectures, b -> this.updateComponentDependencies((List<LoadedArchitecture>)b, dependencyContainer), 1);
    }

    private void updateComponentDependencies(List<LoadedArchitecture> architecturesBatch, ComponentDependencyContainer dependencyContainer) throws ConQATException {
        LoadedArchitecture loadedArchitecture = (LoadedArchitecture)CollectionUtils.getAny(architecturesBatch);
        CCSMAssert.isNotNull((Object)loadedArchitecture);
        TypeComponentMapping typeComponentMapping = loadedArchitecture.typeComponentMapping;
        ArchitectureDefinition architectureDefinition = loadedArchitecture.architectureDefinition;
        this.handleDeletedDependencies(dependencyContainer, typeComponentMapping, architectureDefinition);
        boolean fileBased = architectureDefinition.isFileBased();
        SetMap finalDependencies = new SetMap();
        ArrayList<String> matchedTypes = new ArrayList<String>(typeComponentMapping.getMatchedTypes());
        SetMap<String, String> changedDependencies = dependencyContainer.getDependencies(fileBased, matchedTypes);
        finalDependencies.addAll(changedDependencies);
        UnmodifiableList<Dependency> allDependencies = new ArchitectureAssessor(architectureDefinition, (SetMap<String, String>)finalDependencies, typeComponentMapping).getAllDependencies();
        List<Dependency> newDependencies2 = this.calculateAllDependencies(architectureDefinition, allDependencies, dependencyContainer, fileBased);
        this.architectureComponentDependencyIndex.setArchitecturesAndChanges(architectureDefinition.getName(), newDependencies2);
    }

    private void handleDeletedDependencies(ComponentDependencyContainer dependencyContainer, TypeComponentMapping typeComponentMapping, ArchitectureDefinition architectureDefinition) throws StorageException {
        PairList<String, String> deletedDependencies = dependencyContainer.getDeletedComponentDependencies(architectureDefinition.isFileBased());
        HashMap<String, ComponentDependencyContainer.ComponentDependency> deletedComponents = new HashMap<String, ComponentDependencyContainer.ComponentDependency>();
        for (Pair dependency : deletedDependencies) {
            String mappedComponentForSource = typeComponentMapping.getMappedComponentForType((String)dependency.getFirst());
            String mappedComponentForTarget = typeComponentMapping.getMappedComponentForType((String)dependency.getSecond());
            if (mappedComponentForSource == null || mappedComponentForTarget == null || mappedComponentForSource.equals(mappedComponentForTarget)) continue;
            ComponentNode sourceComponent = architectureDefinition.getComponentByName(mappedComponentForSource);
            ComponentNode targetComponent = architectureDefinition.getComponentByName(mappedComponentForTarget);
            if (targetComponent.isDescendant(sourceComponent) || sourceComponent.isDescendant(targetComponent)) continue;
            String key = mappedComponentForSource + "##" + mappedComponentForTarget;
            TypeDependency typeDependency = new TypeDependency((String)dependency.getFirst(), (String)dependency.getSecond());
            deletedComponents.computeIfPresent(key, (id, objectState) -> {
                objectState.addTypeDependency(typeDependency);
                return objectState;
            });
            deletedComponents.computeIfAbsent(key, ignored -> new ComponentDependencyContainer.ComponentDependency(mappedComponentForSource, mappedComponentForTarget, new ArrayList<TypeDependency>(Collections.singletonList(typeDependency))));
        }
        this.architectureComponentDependencyIndex.removeDependencies(architectureDefinition.getName(), deletedComponents);
    }

    private List<Dependency> calculateAllDependencies(ArchitectureDefinition architectureDefinition, UnmodifiableList<Dependency> allDependencies, ComponentDependencyContainer dependencyContainer, boolean isFileBased) throws StorageException {
        List<Dependency> existingDependencies = this.getExistingDependencies(architectureDefinition);
        PairList<String, String> deletedDependencies = dependencyContainer.getDeletedComponentDependencies(isFileBased);
        List<Dependency> dependenciesToUpdate = this.updateDependencies(existingDependencies, deletedDependencies, architectureDefinition.getName());
        ArrayList<Dependency> newDependencies = new ArrayList<Dependency>();
        newDependencies.addAll(dependenciesToUpdate);
        newDependencies.addAll((Collection<Dependency>)allDependencies);
        return newDependencies;
    }

    private List<Dependency> updateDependencies(List<Dependency> existingDependencies, PairList<String, String> deletedDependencies, String architectureName) throws StorageException {
        ArrayList<Dependency> updatedDependencies = new ArrayList<Dependency>();
        ArrayList<Dependency> deletedDependenciesList = new ArrayList<Dependency>();
        for (Dependency dependency : existingDependencies) {
            HashSet<TypeDependency> typeDependenciesToRemove = new HashSet<TypeDependency>();
            for (TypeDependency typeDependency : dependency.getTypeDependencies()) {
                typeDependenciesToRemove.addAll(ArchitectureComponentDependencySynchronizer.getTypeDependenciesToRemove(deletedDependencies, typeDependency));
            }
            dependency.getTypeDependencies().removeAll(typeDependenciesToRemove);
            if (dependency.getTypeDependencies().isEmpty()) {
                deletedDependenciesList.add(dependency);
                continue;
            }
            updatedDependencies.add(dependency);
        }
        this.architectureComponentDependencyIndex.removeDependencies(architectureName, deletedDependenciesList);
        return updatedDependencies;
    }

    private static Set<TypeDependency> getTypeDependenciesToRemove(PairList<String, String> deletedDependencies, TypeDependency typeDependency) {
        String source = typeDependency.getSource();
        String target = typeDependency.getTarget();
        HashSet<TypeDependency> typeDependenciesToRemove = new HashSet<TypeDependency>();
        for (Pair pair : deletedDependencies) {
            if (!((String)pair.getFirst()).equals(source) || !((String)pair.getSecond()).equals(target)) continue;
            typeDependenciesToRemove.add(typeDependency);
        }
        return typeDependenciesToRemove;
    }

    private List<Dependency> getExistingDependencies(ArchitectureDefinition architectureDefinition) throws StorageException {
        List<DependencyValueClass> storedDependencies = this.architectureComponentDependencyIndex.getDependencies(architectureDefinition.getName()).stream().filter(Objects::nonNull).toList();
        return ArchitectureAnalysisUtils.convertDependencyObjects(architectureDefinition, storedDependencies);
    }

    private ArchitectureDefinition getArchitectureDefinition(String architecturePath) throws ConQATException {
        TokenElementInfo architectureElementInfo = this.contentIndex.getTokenElement(architecturePath);
        return ArchitectureAnalysisUtils.getArchitectureDefinition(architectureElementInfo);
    }

    private record LoadedArchitecture(ArchitectureDefinition architectureDefinition, TypeComponentMapping typeComponentMapping) {
    }
}

