/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.index.architecture.incremental.IArchitectureScopeIndex;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;

@Index(name="architecture-type-dependencies", options={EStorageOption.BRANCHED})
public class ArchitectureTypeDependenciesIndex
extends IndexBase
implements IProjectIndex,
IArchitectureScopeIndex {
    static final String INDEX_NAME = "architecture-type-dependencies";
    private final ValueIndex<ListMap<String, ElementLocation>> delegate;

    public ArchitectureTypeDependenciesIndex(IStore store) {
        super(store);
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    @Override
    public void storeDependencies(Map<String, ListMap<String, ElementLocation>> scope) throws StorageException {
        PairList entriesToWrite = PairList.fromMap(scope);
        this.delegate.setValues(entriesToWrite);
    }

    @Override
    public Map<String, ListMap<String, ElementLocation>> getDependencyLocations(List<String> files) throws StorageException {
        return this.delegate.getValuesByKeys(files);
    }

    @Override
    public Map<String, ListMap<String, ElementLocation>> getDependencyLocations() throws StorageException {
        return this.delegate.getAllEntries().toMap();
    }

    @Override
    public SetMap<String, String> getDependencies(List<String> files) throws StorageException {
        PairList allEntries = this.delegate.getEntriesStartingWith(files);
        SetMap dependencies = new SetMap();
        for (Pair entry : allEntries) {
            dependencies.addAll((Object)((String)entry.getFirst()), (Collection)((ListMap)entry.getSecond()).getKeys());
        }
        return dependencies;
    }

    @Override
    public SetMap<String, String> getDependencies() throws StorageException {
        PairList allEntries = this.delegate.getAllEntries();
        SetMap dependencies = new SetMap();
        for (Pair entry : allEntries) {
            dependencies.addAll((Object)((String)entry.getFirst()), (Collection)((ListMap)entry.getSecond()).getKeys());
        }
        return dependencies;
    }

    @Override
    public void removeDependencies(List<String> uniformPaths) throws StorageException {
        if (!uniformPaths.isEmpty()) {
            this.delegate.removeValues(uniformPaths);
        }
    }
}

