/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.index.architecture.incremental.ArchitectureAnalysisUtils;
import com.teamscale.index.dependencies.DependencyAnalysisFactory;
import com.teamscale.index.dependencies.IFileDependencyFilteringStrategy;
import com.teamscale.index.dependencies.ProjectModuleIndex;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.dependencies.TypeLookupEnvironmentFactory;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

public class FileDependencyCalculator {
    private final TypeDependencyIndex typeDependencyIndex;
    private final TypeIndex typeIndex;
    private final TypeLookupEnvironmentFactory typeLookupEnvironmentFactory;
    private final ListMap<String, String> typeToFilesLookup;

    public FileDependencyCalculator(TypeDependencyIndex typeDependencyIndex, TypeIndex typeIndex, ProjectModuleIndex projectModuleIndex) throws StorageException {
        this.typeDependencyIndex = typeDependencyIndex;
        this.typeIndex = typeIndex;
        this.typeToFilesLookup = typeIndex.getTypeFileLookupMap();
        this.typeLookupEnvironmentFactory = new TypeLookupEnvironmentFactory(typeIndex, projectModuleIndex);
    }

    public Map<String, ListMap<String, ElementLocation>> createDependencies(PairList<String, ArrayList<TypeDependencies>> typeDependenciesByPath) throws StorageException {
        HashMap<String, ListMap<String, ElementLocation>> result = new HashMap<String, ListMap<String, ElementLocation>>();
        for (Pair typeDependencies2 : typeDependenciesByPath) {
            String path = (String)typeDependencies2.getFirst();
            List typeDependencies = (List)typeDependencies2.getSecond();
            if (typeDependencies.isEmpty()) {
                result.put(path, (ListMap<String, ElementLocation>)new ListMap());
            }
            for (TypeDependencies typeDependency : typeDependencies) {
                ArchitectureAnalysisUtils.addThirdPartyDependencies(this.typeIndex, result, typeDependency);
                ListMap<String, ElementLocation> dependencyLocations = FileDependencyCalculator.getFileDependenciesWithLocations(path, typeDependency, this.typeToFilesLookup, this.typeLookupEnvironmentFactory);
                ListMap<String, ElementLocation> entries = result.getOrDefault(path, (ListMap<String, ElementLocation>)new ListMap());
                entries.addAll(dependencyLocations);
                result.put(path, entries);
            }
        }
        return result;
    }

    private static ListMap<String, ElementLocation> getFileDependenciesWithLocations(String path, TypeDependencies typeDependencies, ListMap<String, String> typeToFilesLookup, TypeLookupEnvironmentFactory typeLookupEnvironmentFactory) {
        ListMap dependencyLocations = new ListMap();
        Map<String, List<ElementLocation>> typeDependencyLocations = typeDependencies.getDependencyLocations();
        FileDependencyCalculator.addAsFileDependencyLocations(path, typeToFilesLookup, (ListMap<String, ElementLocation>)dependencyLocations, typeDependencyLocations, typeLookupEnvironmentFactory);
        return dependencyLocations;
    }

    private static void addAsFileDependencyLocations(String path, ListMap<String, String> typeToFilesLookup, ListMap<String, ElementLocation> fileDependencyLocations, Map<String, List<ElementLocation>> typeDependencyLocations, TypeLookupEnvironmentFactory typeLookupEnvironmentFactory) {
        IFileDependencyFilteringStrategy typeDependencyMappingStrategy = DependencyAnalysisFactory.createTypeDependencyMappingStrategy(ELanguage.fromPath((String)path));
        for (Map.Entry<String, List<ElementLocation>> entry : typeDependencyLocations.entrySet()) {
            String type = entry.getKey();
            List<ElementLocation> locations = entry.getValue();
            Collection<String> files = typeDependencyMappingStrategy.filterDependencies(path, typeToFilesLookup.getCollectionOrEmpty((Object)type), typeLookupEnvironmentFactory);
            if (files.isEmpty()) {
                files = Collections.singletonList(type);
            }
            for (String file : files) {
                FileDependencyCalculator.addLocations(path, fileDependencyLocations, file, locations);
            }
        }
    }

    private static void addLocations(String path, ListMap<String, ElementLocation> fileDependencyLocations, String file, List<ElementLocation> locations) {
        for (ElementLocation location : locations) {
            if (!path.equals(location.getUniformPath())) continue;
            fileDependencyLocations.add((Object)file, (Object)location);
        }
    }

    public List<String> getThirdPartyDependencies(List<String> uniformPaths) throws StorageException {
        if (uniformPaths.isEmpty()) {
            return Collections.emptyList();
        }
        List<TypeDependencies> allTypeDependencies = this.typeDependencyIndex.getTypeDependencies(uniformPaths);
        return allTypeDependencies.stream().map(TypeDependencies::getDependencies).flatMap(Collection::stream).toList();
    }
}

