/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.audit.checks;

import eu.cqse.check.clike.CatchExceptionCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Optional;

@Check(name="Catch of specific exception", groupName="Exception Handling", defaultEnablement=EFindingEnablement.OFF, languages={ELanguage.JAVA, ELanguage.CS, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CatchSpecificExceptionCheck
extends CatchExceptionCheckBase {
    protected boolean createFindingForException(Optional<String> className, ShallowEntity entity) throws CheckException {
        if (className.isEmpty()) {
            return false;
        }
        return switch (this.context.getLanguage()) {
            case ELanguage.JAVA -> {
                if (!LanguageFeatureParser.JAVA.isGenericExceptionClass(className.get())) {
                    yield true;
                }
                yield false;
            }
            case ELanguage.CS -> {
                if (!LanguageFeatureParser.CS.isGenericExceptionClass(className.get())) {
                    yield true;
                }
                yield false;
            }
            case ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP -> {
                if (!LanguageFeatureParser.OBJECTIVE_C.isGenericExceptionClass(className.get())) {
                    yield true;
                }
                yield false;
            }
            default -> throw new CheckException("Unsupported Language in CatchHighLevelExceptionCheck: " + String.valueOf(this.context.getLanguage()));
        };
    }

    protected String getFindingMessage(Optional<String> className) {
        return "Catch clause catches specific exception `" + className.get() + "`";
    }
}

