/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup;

import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.backup.write.BackupWriter;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class BackupUtils {
    private static final String GROUPS_FILE_PATH_SUFFIX = "-finding-groups.json";
    private static final String FINDINGS_FILE_PATH_SUFFIX = "-finding-descriptions.json";

    public static boolean isGlobalDataPath(String zipEntryName) {
        return StringUtils.startsWithOneOf((String)zipEntryName, (String[])BackupWriter.GLOBAL_DATA_PREFIXES);
    }

    public static String getExternalFindingDescriptionsPath(EAnalysisTool externalTool) {
        return BackupUtils.getExternalFilePath(externalTool, FINDINGS_FILE_PATH_SUFFIX);
    }

    public static String getExternalFindingDescriptionsFilename(EAnalysisTool externalTool) {
        return BackupUtils.getExternalFileName(externalTool, FINDINGS_FILE_PATH_SUFFIX);
    }

    public static String getExternalFindingGroupsPath(EAnalysisTool externalTool) {
        return BackupUtils.getExternalFilePath(externalTool, GROUPS_FILE_PATH_SUFFIX);
    }

    public static String getExternalFindingGroupsFilename(EAnalysisTool externalTool) {
        return BackupUtils.getExternalFileName(externalTool, GROUPS_FILE_PATH_SUFFIX);
    }

    private static String getExternalFilePath(EAnalysisTool externalTool, String suffix) {
        return "custom-external-findings/" + BackupUtils.getExternalFileName(externalTool, suffix);
    }

    private static String getExternalFileName(EAnalysisTool externalTool, String suffix) {
        return externalTool.name().toLowerCase().replace("_", "-") + suffix;
    }

    public static boolean isStoreFile(String pathInsideZipFile) {
        return pathInsideZipFile.indexOf(47) == -1 && !pathInsideZipFile.startsWith(".") && !"Teamscale-Version".equals(pathInsideZipFile) && !"Backup-Zip-File-Version".equals(pathInsideZipFile) && !"Encrypted-Stores".equals(pathInsideZipFile) && !pathInsideZipFile.endsWith(FINDINGS_FILE_PATH_SUFFIX) && !pathInsideZipFile.endsWith(GROUPS_FILE_PATH_SUFFIX);
    }

    private BackupUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

