/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.blacklisting;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.IndexDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.metrics.FindingsCountMetricUtils;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class BlacklistAwareMetricSynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private FindingBlacklistIndex blacklistIndex;
    @DeltaSource(value=FindingBlacklistIndex.class)
    private IndexDelta<String> blackListDelta;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_WRITE, name="metrics")
    private MetricsIndex metricsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TrackedFindingsIndex trackedFindingsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TrackedFindingsByIdIndex trackedFindingsByIdIndex;

    public void execute() throws StorageException {
        Set<String> findingIds = this.getChangedFindingIds();
        List affectedPaths = UniformPathCompatibilityUtil.convertCollection(new HashSet(CollectionUtils.filterAndMap(this.trackedFindingsByIdIndex.getFindings(new ArrayList<String>(findingIds)), Objects::nonNull, finding -> finding.getLocation().getUniformPath())));
        SetMap<UniformPath, TrackedFinding> uniformPathToTrackedFindings = FindingsCountMetricUtils.createPathToFindingsMap(this.trackedFindingsIndex, affectedPaths);
        FindingsCountMetricUtils.persistMetrics(this.metricsIndex, this.blacklistIndex, (Set<UniformPath>)CollectionUtils.emptySet(), uniformPathToTrackedFindings);
    }

    private Set<String> getChangedFindingIds() {
        return CollectionUtils.unionSet((Collection)this.blackListDelta.getAddedOrChangedKeys(), (Collection[])new Collection[]{this.blackListDelta.getDeletedKeys()});
    }
}

