/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.blacklisting;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.IndexDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.blacklisting.FindingBlacklistCommit;
import com.teamscale.index.blacklisting.FindingBlacklistEvent;
import com.teamscale.index.blacklisting.FindingBlacklistEventIndex;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistStagingIndex;
import java.util.Collection;
import org.conqat.lib.commons.collections.UnmodifiableSet;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class FindingBlacklistEventSynchronizer
extends ChangeProcessorAnalysisStep {
    @DeltaSource(value=FindingBlacklistIndex.class)
    private IndexDelta<String> blacklistIndexDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private FindingBlacklistStagingIndex stagingIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingBlacklistEventIndex eventIndex;

    public void execute() throws Exception {
        FindingBlacklistCommit commitInfo = (FindingBlacklistCommit)((Object)this.stagingIndex.getCommitInfo());
        if (commitInfo == null) {
            return;
        }
        UnmodifiableSet<FindingBlacklistEvent> blacklistEvents = commitInfo.getBlacklistEvents();
        this.eventIndex.storeEvents((Collection<FindingBlacklistEvent>)blacklistEvents);
    }
}

