/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.check;

import com.google.common.collect.Lists;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.check.CheckPhaseResultDependencyIndex;
import com.teamscale.index.check.CheckPhaseResultIndex;
import com.teamscale.index.check.CheckPhaseResultIndexBase;
import com.teamscale.index.check.CheckResultInvalidationIndex;
import com.teamscale.index.check.InvertedCheckPhaseResultIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.ContentIndexInputAnalysisStepBase;
import com.teamscale.index.resource.PreprocessorExpansionsIndex;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.registry.CheckRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class CheckPhaseInverter
extends ContentIndexInputAnalysisStepBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int BATCH_SIZE = 500;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CheckPhaseResultIndex currentResultIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private CheckPhaseResultIndex previousResultIndex;
    @DeltaSource(value=CheckPhaseResultIndex.class)
    private KeyDelta resultDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private InvertedCheckPhaseResultIndex invertedResultIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private CheckPhaseResultDependencyIndex phaseResultDependencyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CheckResultInvalidationIndex invalidationIndex;
    @DeltaSource(value=PreprocessorExpansionsIndex.class)
    protected KeyDelta preprocessorExpansionsIndexDelta;
    @DeltaSource(value=BasicTokenElementIndex.class)
    protected KeyDelta basicContentDelta;

    private Set<String> computePathsProcessedByCheckPhaseProcessor() {
        return CollectionUtils.unionSet((Collection)this.contentDelta.getAllKeysAsStrings(), (Collection[])new Collection[]{this.basicContentDelta.getAllKeysAsStrings(), this.preprocessorExpansionsIndexDelta.getAllKeysAsStrings()});
    }

    public void execute() throws StorageException {
        ListMap<String, String> phaseToChangedPaths = this.previousResultIndex.splitKeys((List<StorageKey>)this.resultDelta.getAddedOrChangedKeys());
        phaseToChangedPaths.addAll(this.previousResultIndex.splitKeys((List<StorageKey>)this.resultDelta.getDeletedKeys()));
        HashSet<String> additionalUniformPathsToUpdate = new HashSet<String>();
        Set<String> phaseProcessedPaths = this.computePathsProcessedByCheckPhaseProcessor();
        for (String phase : phaseToChangedPaths.getKeys()) {
            List changedPaths = (List)phaseToChangedPaths.getCollection((Object)phase);
            HashSet<String> allChangedValues = new HashSet<String>();
            boolean storeInvertedResults = CheckPhaseInverter.isRequiringInvertedResultStorage(phase);
            for (List changedPathsBatch : Lists.partition((List)changedPaths, (int)500)) {
                Map<String, List<CheckPhaseResultIndexBase.RawExtractedValue<?>>> rawValuesListByChangedPlainValue = this.determineRawValuesByChangedPlainValue(phase, changedPathsBatch);
                allChangedValues.addAll(rawValuesListByChangedPlainValue.keySet());
                if (!storeInvertedResults) continue;
                CheckPhaseInverter.removeRawValuesWithUniformPaths(rawValuesListByChangedPlainValue, new HashSet<String>(this.contentDelta.getDeletedKeysAsStrings()));
                this.invertedResultIndex.insertRawValues(phase, rawValuesListByChangedPlainValue);
            }
            additionalUniformPathsToUpdate.addAll(this.phaseResultDependencyIndex.getPathsForAccessedValues(phase, allChangedValues));
            additionalUniformPathsToUpdate.addAll(this.phaseResultDependencyIndex.getPathsForAccessedUniformPaths(phase, new HashSet<String>(phaseProcessedPaths)));
        }
        CollectionUtils.removeAll(additionalUniformPathsToUpdate, (List)this.contentDelta.getAllKeysAsStrings());
        if (!additionalUniformPathsToUpdate.isEmpty()) {
            PairList invalidationValues = new PairList();
            additionalUniformPathsToUpdate.forEach(path -> invalidationValues.add(path, (Object)this.getSchedulingCommit().getTimestamp()));
            this.invalidationIndex.setInvalidationTimestamps((PairList<String, Long>)invalidationValues);
        }
    }

    private static boolean isRequiringInvertedResultStorage(String phase) {
        try {
            return ((IGlobalExtractionPhase)CheckRegistry.getInstance().getCheckPhase(phase).getConstructor(new Class[0]).newInstance(new Object[0])).needsAccessByValue();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Could not instantiate check phase " + phase, (Throwable)e);
            return true;
        }
    }

    private static void removeRawValuesWithUniformPaths(Map<String, List<CheckPhaseResultIndexBase.RawExtractedValue<?>>> rawValuesListByChangedPlainValue, Set<String> deletedKeysAsStrings) {
        for (Collection collection : rawValuesListByChangedPlainValue.values()) {
            collection.removeIf(rawExtractedValue -> deletedKeysAsStrings.contains(rawExtractedValue.getUniformPath()));
        }
    }

    private Map<String, List<CheckPhaseResultIndexBase.RawExtractedValue<?>>> determineRawValuesByChangedPlainValue(String phase, List<String> paths) throws StorageException {
        Class contextClass = CheckRegistry.getInstance().getCheckPhase(phase);
        List<CheckPhaseResultIndexBase.RawExtractedValue<?>> oldWrappedValues = this.previousResultIndex.getRawValues(phase, paths, contextClass);
        List<CheckPhaseResultIndexBase.RawExtractedValue<?>> newWrappedValues = this.currentResultIndex.getRawValues(phase, paths, contextClass);
        HashSet values = new HashSet();
        values.addAll(CollectionUtils.map(oldWrappedValues, CheckPhaseResultIndexBase.RawExtractedValue::getValue));
        values.addAll(CollectionUtils.map(newWrappedValues, CheckPhaseResultIndexBase.RawExtractedValue::getValue));
        ArrayList<String> plainValuesList = new ArrayList<String>(values);
        List<List<CheckPhaseResultIndexBase.RawExtractedValue<?>>> rawValuesLists = this.invertedResultIndex.getRawValues(phase, plainValuesList, contextClass);
        HashSet<String> pathSet = new HashSet<String>(paths);
        HashMap rawValuesListByPlainValue = new HashMap();
        for (int i = 0; i < plainValuesList.size(); ++i) {
            ArrayList<CheckPhaseResultIndexBase.RawExtractedValue> rawValuesList = new ArrayList<CheckPhaseResultIndexBase.RawExtractedValue>(CollectionUtils.emptyIfNull(rawValuesLists.get(i)));
            rawValuesListByPlainValue.put((String)plainValuesList.get(i), rawValuesList);
            rawValuesList.removeIf(rawValue -> pathSet.contains(rawValue.getUniformPath()));
        }
        for (CheckPhaseResultIndexBase.RawExtractedValue<?> rawValue2 : newWrappedValues) {
            ((List)rawValuesListByPlainValue.get(rawValue2.getValue())).add(rawValue2);
        }
        for (int i = 0; i < plainValuesList.size(); ++i) {
            List newList = (List)rawValuesListByPlainValue.get(plainValuesList.get(i));
            if (newList == null) continue;
            Collections.sort(newList);
            List<CheckPhaseResultIndexBase.RawExtractedValue<?>> oldList = rawValuesLists.get(i);
            if (!newList.equals(oldList)) continue;
            rawValuesListByPlainValue.remove(plainValuesList.get(i));
        }
        return rawValuesListByPlainValue;
    }
}

