/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.check;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.check.CheckPhaseResultIndex;
import com.teamscale.index.check.CheckProcessorBase;
import com.teamscale.index.check.TokenElementContext;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.HiddenTokenElementDetail;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.core.registry.CheckRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class CheckPhaseProcessor
extends CheckProcessorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<IGlobalExtractionPhase<?, ?>> phases = new ArrayList();
    public static final String PHASE_PARAMETER = "phase.name";
    @StepParameter(value="phase.name", optional=true)
    private final List<String> phaseNames = new ArrayList<String>();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CheckPhaseResultIndex resultIndex;
    @DeltaSource(value=BasicTokenElementIndex.class)
    protected KeyDelta basicContentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected BasicTokenElementIndex basicContentIndex;

    public void execute() throws StorageException, ExecutionException {
        if (this.phaseNames.isEmpty()) {
            return;
        }
        for (String phaseName : this.phaseNames) {
            Class phaseClass = CheckRegistry.getInstance().getCheckPhase(phaseName);
            try {
                this.phases.add((IGlobalExtractionPhase)phaseClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.error(e.toString(), (Throwable)e);
                return;
            }
        }
        List<String> deletedUniformPaths = this.determineDeletedElements();
        if (!deletedUniformPaths.isEmpty()) {
            this.resultIndex.remove(deletedUniformPaths, CollectionUtils.map(this.phases, Object::getClass));
        }
        EnumSet<ECheckParameter> requiredParameters = CheckPhaseProcessor.collectRequiredParameters(this.phases);
        List<String> changedTokenElementPaths = List.copyOf(this.determineTokenElementsToAnalyze(requiredParameters));
        this.executeInParallelBatches(changedTokenElementPaths, this::runPhasesOnTokenElements);
        if (requiredParameters.contains(ECheckParameter.RUN_ON_HIDDEN_ELEMENTS)) {
            List changedBasicElementPaths = this.basicContentDelta.getAddedOrChangedKeysAsStrings();
            List<BasicTokenElementInfo> changedHiddenBasicElements = this.determineChangedHiddenElements(changedTokenElementPaths, changedBasicElementPaths);
            this.executeInParallelBatches(changedHiddenBasicElements, this::runPhasesOnBasicTokenElements);
        }
    }

    @Override
    protected List<String> determineDeletedElements() {
        return List.copyOf(CollectionUtils.unionSet(super.determineDeletedElements(), (Collection[])new Collection[]{this.basicContentDelta.getDeletedKeysAsStrings()}));
    }

    private static EnumSet<ECheckParameter> collectRequiredParameters(List<IGlobalExtractionPhase<?, ?>> phases) {
        EnumSet<ECheckParameter> requiredParameters = EnumSet.noneOf(ECheckParameter.class);
        for (IGlobalExtractionPhase<?, ?> phase : phases) {
            requiredParameters.addAll(phase.getRequiredContextParameters());
        }
        return requiredParameters;
    }

    private @NonNull List<BasicTokenElementInfo> determineChangedHiddenElements(List<String> changedTokenElementPaths, List<String> changedBasicElementPaths) throws StorageException {
        ArrayList changedHiddenPaths = CollectionUtils.sort((Collection)CollectionUtils.differenceSet(changedBasicElementPaths, (Collection[])new Collection[]{changedTokenElementPaths}));
        List<BasicTokenElementInfo> changedHiddenBasicElements = this.basicContentIndex.getTokenElements(changedHiddenPaths);
        changedHiddenBasicElements.removeIf(element -> element.getFirstDetailOfType(HiddenTokenElementDetail.class).isEmpty());
        return changedHiddenBasicElements;
    }

    private void runPhasesOnTokenElements(List<String> changedTokenElementPaths) throws StorageException {
        HashMap extractedValues = new HashMap();
        try (TokenElementContext context = new TokenElementContext();){
            List<TokenElementInfo> elements = this.contentIndex.getTokenElements(changedTokenElementPaths);
            for (TokenElementInfo tokenElementInfo : elements) {
                if (!CheckPhaseProcessor.elementIsHandledByCheckFramework(tokenElementInfo)) continue;
                this.processElement(tokenElementInfo, context, extractedValues);
            }
        }
        if (!extractedValues.isEmpty()) {
            this.resultIndex.storeValues(extractedValues);
        }
    }

    private void processElement(TokenElementInfo element, TokenElementContext context, Map<Class<? extends IGlobalExtractionPhase<?, ?>>, PairList<String, List<? extends IExtractedValue<?>>>> extractedValues) {
        context.reset(element);
        for (IGlobalExtractionPhase<?, ?> phase : this.phases) {
            if (!phase.getLanguages().contains(element.getLanguage())) continue;
            try {
                this.prepareContext(context, phase.getRequiredContextParameters());
                if (!EFeatureToggle.DISABLE_CLANG_JNI_CHECKS.isEnabled() && CheckPhaseProcessor.clangParserInitializationFailed(phase.getRequiredContextParameters(), context)) {
                    LOGGER.warn("Skipping custom check phase '" + phase.getClass().getCanonicalName() + "' on " + String.valueOf((Object)element) + " because clang parser could not be initialized.");
                    continue;
                }
                this.getProfilingMonitor().startProfiling(phase.getClass().getSimpleName());
                List values = phase.extract((ITokenElementContext)context);
                for (IExtractedValue value : values) {
                    CCSMAssert.isTrue((boolean)value.getUniformPath().equals(context.getUniformPath()), () -> "Expected that IExtractedValue of phase " + phase.getClass().getSimpleName() + " has current UniformPath (" + context.getUniformPath() + "). Was " + value.getUniformPath() + " instead.");
                }
                extractedValues.computeIfAbsent(phase.getClass(), x -> new PairList()).add((Object)element.getUniformPath(), (Object)values);
            }
            catch (Throwable e) {
                LOGGER.error("Error executing custom check phase '{}' on {}. Skipping phase.", (Object)phase.getClass().getCanonicalName(), (Object)element, (Object)e);
            }
            this.getProfilingMonitor().stopProfiling(phase.getClass().getSimpleName());
        }
    }

    private void runPhasesOnBasicTokenElements(List<BasicTokenElementInfo> changedHiddenBasicElements) throws StorageException {
        HashMap extractedValues = new HashMap();
        try (TokenElementContext context = new TokenElementContext();){
            for (BasicTokenElementInfo basicElement : changedHiddenBasicElements) {
                if (!CheckPhaseProcessor.elementIsHandledByCheckFramework(basicElement)) continue;
                this.processBasicElement(basicElement, context, extractedValues);
            }
        }
        if (!extractedValues.isEmpty()) {
            this.resultIndex.storeValues(extractedValues);
        }
    }

    private void processBasicElement(BasicTokenElementInfo basicElement, TokenElementContext context, Map<Class<? extends IGlobalExtractionPhase<?, ?>>, PairList<String, List<? extends IExtractedValue<?>>>> extractedValues) {
        context.reset(basicElement);
        for (IGlobalExtractionPhase<?, ?> phase : this.phases) {
            if (!phase.getLanguages().contains(basicElement.getLanguage()) || !phase.getRequiredContextParameters().contains(ECheckParameter.RUN_ON_HIDDEN_ELEMENTS)) continue;
            try {
                this.prepareContext(context, phase.getRequiredContextParameters());
                if (CheckPhaseProcessor.clangParserInitializationFailed(phase.getRequiredContextParameters(), context)) {
                    LOGGER.warn("Skipping custom check phase '" + phase.getClass().getCanonicalName() + "' on " + String.valueOf(basicElement) + " because clang parser could not be initialized.");
                    continue;
                }
                this.getProfilingMonitor().startProfiling(phase.getClass().getSimpleName());
                List values = phase.extract((ITokenElementContext)context);
                for (IExtractedValue value : values) {
                    CCSMAssert.isTrue((boolean)value.getUniformPath().equals(context.getUniformPath()), () -> "Expected that IExtractedValue of phase " + phase.getClass().getSimpleName() + " has current (hidden) UniformPath (" + context.getUniformPath() + "). Was " + value.getUniformPath() + " instead.");
                }
                extractedValues.computeIfAbsent(phase.getClass(), x -> new PairList()).add((Object)basicElement.getUniformPath(), (Object)values);
            }
            catch (Throwable e) {
                LOGGER.error("Error executing custom check phase '{}' on hidden element {}. Skipping phase.", (Object)phase.getClass().getCanonicalName(), (Object)basicElement, (Object)e);
            }
            this.getProfilingMonitor().stopProfiling(phase.getClass().getSimpleName());
        }
    }
}

