/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change;

import com.teamscale.index.code_change.ChangeRegions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.Nullable;

@Index(name="code-change", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class CodeChangeIndex
implements IProjectIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String INDEX_NAME = "code-change";
    private final ValueIndex<ChangeRegions> delegate;

    public CodeChangeIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public <T extends TrackedFinding> List<T> reduceToFindingsInChangedCode(Collection<T> findings, long lastChangeTimestamp) throws StorageException {
        Map<String, ChangeRegions> changeRegionsByPath = this.loadChangeRegions(findings);
        ArrayList<TrackedFinding> findingsInChangedCode = new ArrayList<TrackedFinding>();
        for (TrackedFinding finding : findings) {
            if (!CodeChangeIndex.isInChangedCode(finding, changeRegionsByPath.get(finding.getLocation().getUniformPath()), lastChangeTimestamp)) continue;
            findingsInChangedCode.add(finding);
        }
        return findingsInChangedCode;
    }

    private <T extends TrackedFinding> Map<String, ChangeRegions> loadChangeRegions(Collection<T> findings) throws StorageException {
        HashSet<String> uniformPaths = new HashSet<String>();
        for (TrackedFinding finding : findings) {
            uniformPaths.add(finding.getLocation().getUniformPath());
        }
        ArrayList uniformPathsList = new ArrayList(uniformPaths);
        List changeRegions = this.delegate.getValues(uniformPathsList);
        HashMap<String, ChangeRegions> changeRegionsByPath = new HashMap<String, ChangeRegions>();
        for (int i = 0; i < uniformPathsList.size(); ++i) {
            ChangeRegions regions = (ChangeRegions)changeRegions.get(i);
            if (regions == null) {
                LOGGER.error("Missing change regions for " + (String)uniformPathsList.get(i) + "! Probably code change tracking failed before?");
                regions = new ChangeRegions(0L);
            }
            changeRegionsByPath.put((String)uniformPathsList.get(i), regions);
        }
        return changeRegionsByPath;
    }

    private static boolean isInChangedCode(TrackedFinding finding, ChangeRegions changeRegions, long lastChangeTimestamp) {
        ElementLocation location = finding.getLocation();
        if (!(location instanceof TextRegionLocation)) {
            return false;
        }
        TextRegionLocation textRegionLocation = (TextRegionLocation)location;
        return changeRegions.getMaximalTimestamp(textRegionLocation.getRawStartOffset(), textRegionLocation.getRawEndOffset()) >= lastChangeTimestamp;
    }

    public List<ChangeRegions> getChangeRegions(List<String> uniformPaths) throws StorageException {
        return this.delegate.getValues(uniformPaths);
    }

    public @Nullable ChangeRegions getChangeRegion(String uniformPath) throws StorageException {
        return (ChangeRegions)this.delegate.getValue(uniformPath);
    }

    public void setChangeRegions(PairList<String, ChangeRegions> changeRegions) throws StorageException {
        this.delegate.setValues(changeRegions);
    }

    public void removeChangeRegions(Collection<String> uniformPaths) throws StorageException {
        this.delegate.removeValues(uniformPaths);
    }
}

