/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.detection;

import com.teamscale.index.code_clones.core.Clone;
import com.teamscale.index.code_clones.core.CloneClass;
import com.teamscale.index.code_clones.detection.CloneChunk;
import com.teamscale.index.code_clones.detection.CloneChunkList;
import com.teamscale.index.code_clones.report.ICloneClassReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.region.Region;
import org.jspecify.annotations.NonNull;

public class CloneIndexGappedCloneSearcher {
    private static final int MAXIMUM_ABSOLUTE_GAP_SIZE = 6;
    private final int chunkLength;
    private final String originId;
    private final ICloneClassReporter reporter;
    private final int minLength;
    private final List<CloneChunkList> orderedChunks;
    private final List<CloneClass> cloneClasses = new ArrayList<CloneClass>();
    private final ListMap<String, Clone> locationToClone = new ListMap();

    public CloneIndexGappedCloneSearcher(String originId, ICloneClassReporter reporter, int minLength, List<CloneChunkList> orderedChunks, int chunkLength) {
        this.originId = originId;
        this.reporter = reporter;
        this.minLength = minLength;
        this.orderedChunks = orderedChunks;
        this.chunkLength = chunkLength;
    }

    public void reportClones() throws StorageException {
        ListMap<String, ChunkPair> chunkPairsBySecondOrigin = this.createPairsBySecondOrigin();
        for (String otherOrigin : chunkPairsBySecondOrigin.getKeys()) {
            ArrayList sortedPairs = CollectionUtils.sort((Collection)chunkPairsBySecondOrigin.getCollection((Object)otherOrigin));
            CloneIndexGappedCloneSearcher.extendPrimitivePairs(sortedPairs);
            this.buildClonesFromExtendedPairs(sortedPairs);
            this.mergeCloneClasses();
            this.reportCloneClasses();
        }
    }

    private @NonNull ListMap<String, ChunkPair> createPairsBySecondOrigin() {
        ListMap chunkPairsBySecondOrigin = new ListMap();
        for (int i = 0; i < this.orderedChunks.size(); ++i) {
            CloneChunkList chunkList = this.orderedChunks.get(i);
            if (chunkList.isEmpty()) continue;
            CloneChunk originChunk = this.findOriginChunk(chunkList, i);
            for (CloneChunk otherChunk : chunkList) {
                if (otherChunk == originChunk) continue;
                chunkPairsBySecondOrigin.add((Object)otherChunk.getOriginId(), (Object)new ChunkPair(this, originChunk, otherChunk));
            }
        }
        return chunkPairsBySecondOrigin;
    }

    private static void extendPrimitivePairs(List<ChunkPair> sortedPairs) {
        for (int extendWithIndex = 1; extendWithIndex < sortedPairs.size(); ++extendWithIndex) {
            for (int toBeExtendedIndex = extendWithIndex - 1; toBeExtendedIndex >= 0 && !sortedPairs.get(extendWithIndex).tryToExtendPair(sortedPairs.get(toBeExtendedIndex)); --toBeExtendedIndex) {
            }
        }
    }

    private void buildClonesFromExtendedPairs(List<ChunkPair> sortedPairs) {
        for (ChunkPair chunkPair : sortedPairs) {
            if (chunkPair.isExtension()) continue;
            this.createClonesAndClassForPair(chunkPair);
        }
    }

    private void createClonesAndClassForPair(ChunkPair firstChunkPair) {
        ChunkPair lastChunkPair = firstChunkPair.getLastExtensionPair();
        if (this.clonesWillBeTooSmall(firstChunkPair, lastChunkPair)) {
            return;
        }
        CloneClass cloneClass = new CloneClass(lastChunkPair.lengthInUnits);
        Clone originClone = this.createClone(firstChunkPair.originChunk, lastChunkPair.originChunk, cloneClass);
        Clone otherClone = this.createClone(firstChunkPair.otherChunk, lastChunkPair.otherChunk, cloneClass);
        CloneIndexGappedCloneSearcher.addGapsToClones(firstChunkPair, lastChunkPair, originClone, otherClone);
        this.cloneClasses.add(cloneClass);
    }

    private static void addGapsToClones(ChunkPair firstChunkPair, ChunkPair lastChunkPair, Clone originClone, Clone otherClone) {
        if (lastChunkPair.gapCount > 0) {
            ChunkPair.PairGaps gaps = firstChunkPair.gatherGaps();
            gaps.originGaps.forEach(originClone::addGap);
            gaps.otherGaps.forEach(otherClone::addGap);
        }
    }

    private void mergeCloneClasses() {
        for (String key : this.locationToClone.getKeys()) {
            int first;
            List clones = (List)this.locationToClone.getCollection((Object)key);
            for (first = 0; first < clones.size() && ((Clone)clones.get(first)).getCloneClass() == null; ++first) {
            }
            if (first >= clones.size()) continue;
            CloneClass cloneClass = ((Clone)clones.get(first)).getCloneClass();
            HashSet<String> locations = new HashSet<String>();
            for (Clone clone : cloneClass.getClones()) {
                locations.add(clone.getLocation().toLocationString());
            }
            for (int i = first + 1; i < clones.size(); ++i) {
                CloneClass mergeCloneClass = ((Clone)clones.get(i)).getCloneClass();
                if (mergeCloneClass == cloneClass || mergeCloneClass == null) continue;
                for (Clone clone : new ArrayList<Clone>(mergeCloneClass.getClones())) {
                    if (locations.add(clone.getLocation().toLocationString())) {
                        cloneClass.add(clone);
                        continue;
                    }
                    mergeCloneClass.remove(clone);
                }
            }
        }
    }

    private void reportCloneClasses() throws StorageException {
        for (CloneClass cloneClass : this.cloneClasses) {
            if (cloneClass.size() < 2 || !this.reporter.shouldReport(cloneClass.getNormalizedLength(), cloneClass.size())) continue;
            this.reporter.report(cloneClass);
        }
    }

    private boolean clonesWillBeTooSmall(ChunkPair firstPair, ChunkPair lastPair) {
        return this.computeCloneLength(firstPair.originChunk, lastPair.originChunk) < this.minLength || this.computeCloneLength(firstPair.otherChunk, lastPair.otherChunk) < this.minLength;
    }

    private int computeCloneLength(CloneChunk firstChunk, CloneChunk lastChunk) {
        int length = lastChunk.getFirstUnitIndex() - firstChunk.getFirstUnitIndex() + this.chunkLength;
        CCSMAssert.isTrue((length >= this.chunkLength ? 1 : 0) != 0, (String)"Clone length must not be shorter than chunk size");
        return length;
    }

    private Clone createClone(CloneChunk firstChunk, CloneChunk lastChunk, CloneClass cloneClass) {
        TextRegionLocation location = new TextRegionLocation(firstChunk.getOriginId(), firstChunk.getRawStartOffset(), lastChunk.getRawEndOffset(), firstChunk.getFirstRawLineNumber(), lastChunk.getLastRawLineNumber() - 1);
        Clone clone = new Clone(cloneClass, location, firstChunk.getFirstUnitIndex(), this.computeCloneLength(firstChunk, lastChunk));
        this.locationToClone.add((Object)location.toLocationString(), (Object)clone);
        return clone;
    }

    private CloneChunk findOriginChunk(CloneChunkList chunkList, int index) {
        for (CloneChunk chunk : chunkList) {
            if (chunk.getFirstUnitIndex() != index || !this.originId.equals(chunk.getOriginId())) continue;
            return chunk;
        }
        throw new AssertionError((Object)"Could not find origin chunk for index %d in chunk list of size %d. This should not be possible!".formatted(index, chunkList.size()));
    }

    private class ChunkPair
    implements Comparable<ChunkPair> {
        private final CloneChunk originChunk;
        private final CloneChunk otherChunk;
        private int lengthInUnits;
        private int gapCount;
        private Region originGap;
        private Region otherGap;
        private ChunkPair extension;
        final /* synthetic */ CloneIndexGappedCloneSearcher this$0;

        private ChunkPair(CloneIndexGappedCloneSearcher cloneIndexGappedCloneSearcher, CloneChunk originChunk, CloneChunk otherChunk) {
            CloneIndexGappedCloneSearcher cloneIndexGappedCloneSearcher2 = cloneIndexGappedCloneSearcher;
            Objects.requireNonNull(cloneIndexGappedCloneSearcher2);
            this.this$0 = cloneIndexGappedCloneSearcher2;
            this.lengthInUnits = this.this$0.chunkLength;
            this.gapCount = 0;
            this.originGap = null;
            this.otherGap = null;
            this.extension = null;
            this.originChunk = originChunk;
            this.otherChunk = otherChunk;
        }

        private boolean tryToExtendPair(ChunkPair toBeExtended) {
            if (toBeExtended.hasExtension()) {
                return false;
            }
            int originDiff = this.originChunk.getFirstUnitIndex() - toBeExtended.originChunk.getFirstUnitIndex();
            int otherDiff = this.otherChunk.getFirstUnitIndex() - toBeExtended.otherChunk.getFirstUnitIndex();
            if (originDiff <= 0 || otherDiff <= 0) {
                return false;
            }
            int originDistance = originDiff - this.this$0.chunkLength;
            int otherDistance = otherDiff - this.this$0.chunkLength;
            int maxChunkDistance = Math.max(originDistance, otherDistance);
            if (maxChunkDistance > toBeExtended.lengthInUnits || maxChunkDistance > 6) {
                return false;
            }
            toBeExtended.extension = this;
            this.lengthInUnits = toBeExtended.lengthInUnits + maxChunkDistance + this.this$0.chunkLength;
            this.updateGaps(toBeExtended, originDistance, otherDistance);
            return true;
        }

        private void updateGaps(ChunkPair toBeExtended, int originDistance, int otherDistance) {
            this.gapCount = toBeExtended.gapCount;
            if (originDistance > 0) {
                this.originGap = new Region(toBeExtended.originChunk.getFirstUnitIndex() + this.this$0.chunkLength, this.originChunk.getFirstUnitIndex() - 1);
                ++this.gapCount;
            }
            if (otherDistance > 0) {
                this.otherGap = new Region(toBeExtended.otherChunk.getFirstUnitIndex() + this.this$0.chunkLength, this.otherChunk.getFirstUnitIndex() - 1);
                ++this.gapCount;
            }
        }

        private boolean hasExtension() {
            return this.extension != null;
        }

        private boolean isExtension() {
            return this.lengthInUnits > this.this$0.chunkLength;
        }

        private ChunkPair getLastExtensionPair() {
            ChunkPair last = this;
            while (last.hasExtension()) {
                last = last.extension;
            }
            return last;
        }

        private PairGaps gatherGaps() {
            CCSMAssert.isFalse((boolean)this.isExtension(), (String)"Should not be called on a non-root chunk pair in a chunk pair chain.");
            ArrayList<Region> originGaps = new ArrayList<Region>();
            ArrayList<Region> otherGaps = new ArrayList<Region>();
            ChunkPair pair = this;
            while (pair != null) {
                if (pair.originGap != null) {
                    originGaps.add(pair.originGap);
                }
                if (pair.otherGap != null) {
                    otherGaps.add(pair.otherGap);
                }
                pair = pair.extension;
            }
            return new PairGaps(originGaps, otherGaps);
        }

        private int getFragmentCount() {
            int count = 1;
            ChunkPair pair = this;
            while (pair.hasExtension()) {
                ++count;
                pair = pair.extension;
            }
            return count;
        }

        @Override
        public int compareTo(ChunkPair other) {
            int firstIndex = this.originChunk.getFirstUnitIndex() - other.originChunk.getFirstUnitIndex();
            if (firstIndex != 0) {
                return firstIndex;
            }
            return this.otherChunk.getFirstUnitIndex() - other.otherChunk.getFirstUnitIndex();
        }

        public String toString() {
            return "%s:%d|u=%d".formatted(this.originChunk.getOriginId(), this.originChunk.getFirstRawLineNumber(), this.originChunk.getFirstUnitIndex()) + "->" + "%s:%d|u=%d".formatted(this.otherChunk.getOriginId(), this.otherChunk.getFirstRawLineNumber(), this.otherChunk.getFirstUnitIndex()) + " (length=%d, gaps=%d, fragments=%d, ext=%b)".formatted(this.lengthInUnits, this.gapCount, this.getFragmentCount(), this.hasExtension());
        }

        private record PairGaps(List<Region> originGaps, List<Region> otherGaps) {
        }
    }
}

