/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.normalization;

import com.teamscale.index.code_clones.core.StatementUnit;
import com.teamscale.index.code_clones.core.TokenUnit;
import com.teamscale.index.code_clones.core.Unit;
import com.teamscale.index.code_clones.normalization.ITokenNormalizer;
import com.teamscale.index.code_clones.normalization.ITokenReporter;
import com.teamscale.index.code_clones.normalization.RepetitionNormalizationAdjuster;
import com.teamscale.index.code_clones.normalization.RepetitionRemover;
import com.teamscale.index.code_clones.normalization.StatementNormalizationConfiguration;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IStatementOracle;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageProperties;
import eu.cqse.check.framework.scanner.ShallowParserStatementOracle;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ILookahead;
import org.conqat.lib.commons.collections.IdManager;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;

public class StatementNormalization {
    private final List<IToken> tokens;
    private final List<ShallowEntity> parseTree;
    private final List<Unit> units = new ArrayList<Unit>();
    private final List<Unit> conservativeUnits = new ArrayList<Unit>();
    private IStatementOracle statementOracle;
    private final IdManager<String> idManager = new IdManager();
    private final String elementUniformPath;
    private int tokenIndex;
    private final ILookahead<IToken, NeverThrownRuntimeException> tokenLookahead = new ILookahead<IToken, NeverThrownRuntimeException>(this){
        final /* synthetic */ StatementNormalization this$0;
        {
            StatementNormalization statementNormalization = this$0;
            Objects.requireNonNull(statementNormalization);
            this.this$0 = statementNormalization;
        }

        public IToken lookahead(int index) throws NeverThrownRuntimeException {
            if (index + this.this$0.tokenIndex >= this.this$0.tokens.size()) {
                return null;
            }
            return this.this$0.tokens.get(index + this.this$0.tokenIndex);
        }
    };
    private final List<TokenUnit> currentStatement = new ArrayList<TokenUnit>();
    private final List<TokenUnit> currentConservativeStatement = new ArrayList<TokenUnit>();
    private int statementIndexInElement = 0;
    private final Predicate<List<TokenUnit>> statementPredicate;
    private final Function<List<IToken>, Integer> startIndexFinder;
    private final Set<String> methodNamesForConservativeNormalization;
    private final ITokenNormalizer tokenNormalizer;
    private final ITokenReporter tokenReporter = new ITokenReporter(this){
        final /* synthetic */ StatementNormalization this$0;
        {
            StatementNormalization statementNormalization = this$0;
            Objects.requireNonNull(statementNormalization);
            this.this$0 = statementNormalization;
        }

        @Override
        public void report(String normalized) {
            TokenUnit tokenUnit = this.buildTokenUnit(normalized, 0);
            this.this$0.currentStatement.add(tokenUnit);
            this.this$0.currentConservativeStatement.add(tokenUnit);
        }

        private TokenUnit buildTokenUnit(String normalized, int offset) {
            IToken token = this.this$0.tokens.get(this.this$0.tokenIndex + offset);
            return new TokenUnit(normalized, token.getText(), token.getOffset(), token.getEndOffset(), this.this$0.elementUniformPath, token.getType(), this.this$0.tokenIndex);
        }

        @Override
        public void report(String normalized, String conservative) {
            this.this$0.currentStatement.add(this.buildTokenUnit(normalized, 0));
            this.this$0.currentConservativeStatement.add(this.buildTokenUnit(conservative, 0));
        }

        @Override
        public void skippedTokensForConservative(int count) {
            for (int offset = 0; offset < count; ++offset) {
                IToken token = this.this$0.tokens.get(this.this$0.tokenIndex + offset);
                String text = token.getText();
                if (!token.getLanguage().isCaseSensitive()) {
                    text = text.toLowerCase();
                }
                this.this$0.currentConservativeStatement.add(this.buildTokenUnit(text, offset));
            }
        }
    };

    public StatementNormalization(List<IToken> tokens, List<ShallowEntity> parseTree) {
        CCSMAssert.isFalse((boolean)tokens.isEmpty(), (String)"Must provide non-empty tokens list!");
        this.tokens = tokens;
        this.parseTree = parseTree;
        IToken token = tokens.get(0);
        ELanguage language = token.getLanguage();
        this.statementOracle = LanguageProperties.of((ELanguage)language).getStatementOracle();
        if (language == ELanguage.TSQL) {
            this.statementOracle = new ShallowParserStatementOracle(parseTree, this.statementOracle);
        }
        this.elementUniformPath = token.getOriginId();
        this.tokenNormalizer = StatementNormalizationConfiguration.getTokenNormalization(language);
        this.statementPredicate = StatementNormalizationConfiguration.getStatementPredicate(language);
        this.startIndexFinder = StatementNormalizationConfiguration.getStartIndexFinder(language);
        this.methodNamesForConservativeNormalization = StatementNormalizationConfiguration.getMethodNamesForConservativeNormalization(language);
    }

    public List<Unit> normalize() {
        this.tokenIndex = this.startIndexFinder.apply(this.tokens);
        while (this.tokenIndex < this.tokens.size()) {
            IToken token = this.tokens.get(this.tokenIndex);
            if (this.statementOracle.isEndOfStatementToken(token.getType(), this.tokenLookahead)) {
                this.addStatementIfIncluded();
                this.currentStatement.clear();
                this.currentConservativeStatement.clear();
                this.idManager.clear();
            } else {
                this.tokenIndex += this.normalizeCurrentToken();
            }
            ++this.tokenIndex;
        }
        this.addStatementIfIncluded();
        RepetitionNormalizationAdjuster.normalizeRepetitionsConservative(this.units, this.conservativeUnits, this.parseTree, this.methodNamesForConservativeNormalization);
        return RepetitionRemover.removeRepetitions(this.units);
    }

    private void addStatementIfIncluded() {
        if (!this.isCurrentStatementIncluded()) {
            return;
        }
        this.units.add(new StatementUnit(this.currentStatement, this.elementUniformPath, true, this.statementIndexInElement));
        this.conservativeUnits.add(new StatementUnit(this.currentConservativeStatement, this.elementUniformPath, true, this.statementIndexInElement));
        ++this.statementIndexInElement;
    }

    private int normalizeCurrentToken() {
        return this.tokenNormalizer.normalize(this.tokens, this.tokenIndex, this.idManager, this.tokenReporter);
    }

    private boolean isCurrentStatementIncluded() {
        return !this.currentStatement.isEmpty() && this.statementPredicate.test(this.currentStatement);
    }
}

