/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_ownership;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class CodeOwnershipData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Long> committingAuthors = new HashMap<String, Long>();
    private final Map<String, Long> mergingAuthors = new HashMap<String, Long>();

    public static CodeOwnershipData merge(CodeOwnershipData first, CodeOwnershipData second) {
        CodeOwnershipData result = new CodeOwnershipData();
        CodeOwnershipData.mergeCodeOwnershipData(first.committingAuthors, second.committingAuthors, result.committingAuthors);
        CodeOwnershipData.mergeCodeOwnershipData(first.mergingAuthors, second.mergingAuthors, result.mergingAuthors);
        return result;
    }

    private static void mergeCodeOwnershipData(Map<String, Long> fistMap, Map<String, Long> secondMap, Map<String, Long> result) {
        result.putAll(fistMap);
        secondMap.forEach((username, timestamp) -> result.merge((String)username, (Long)timestamp, Math::max));
    }

    public static CodeOwnershipData fromAuthor(String author, long latestCommitTimestamp, boolean isMergeCommit) {
        CodeOwnershipData result = new CodeOwnershipData();
        if (isMergeCommit) {
            result.mergingAuthors.put(author, latestCommitTimestamp);
        } else {
            result.committingAuthors.put(author, latestCommitTimestamp);
        }
        return result;
    }

    public Set<String> getCommitters() {
        return this.committingAuthors.keySet();
    }

    public Set<String> getCommittersAndMergers() {
        return CollectionUtils.unionSet(this.committingAuthors.keySet(), (Collection[])new Collection[]{this.mergingAuthors.keySet()});
    }

    public void removeAuthorsCommittedBefore(long timestamp) {
        this.committingAuthors.entrySet().removeIf(entry -> (Long)entry.getValue() < timestamp);
        this.mergingAuthors.entrySet().removeIf(entry -> (Long)entry.getValue() < timestamp);
    }
}

