/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.metrics.MetricsIndexSynchronizer;
import com.teamscale.index.comment_analysis.CommentClassificationAnalysisBase;
import com.teamscale.index.comment_analysis.CommentClassificationCache;
import com.teamscale.index.comment_analysis.CommentCompletenessAssessor;
import com.teamscale.index.comment_analysis.CommentCompletenessFindingsAnalyzer;
import com.teamscale.index.comment_analysis.CommentMetricAnalysis;
import com.teamscale.index.comment_analysis.CommentedOutCodeAnalysis;
import com.teamscale.index.comment_analysis.EmptyInterfaceCommentAnalysis;
import com.teamscale.index.comment_analysis.ExclamationQuestionMarkAnalysis;
import com.teamscale.index.comment_analysis.LongInlineCommentAnalysis;
import com.teamscale.index.comment_analysis.ShortInlineCommentAnalysis;
import com.teamscale.index.comment_analysis.SourceCodeSearchFindingAnalyzer;
import com.teamscale.index.comment_analysis.TrivialInterfaceCommentAnalysis;
import com.teamscale.index.comment_analysis.UnrelatedInterfaceCommentAnalysis;
import com.teamscale.index.configuration.CodeScopeUtils;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.preprocessor.IPreprocessor;
import eu.cqse.check.framework.scanner.ETokenType;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class CommentAnalysis
extends FindingsSynchronizingAnalyzingStepBase {
    public static final String COMMENTS_FINDING_CATEGORY = "Comments";
    public static final String TASK_TAGS_FINDING_GROUP = "Task Tags";
    public static final String PROBLEM_TAGS_FINDING_GROUP = "Problem Tags";
    public static final String DEFAULT_TASK_TAG_PATTERN = "(?i)(^|(?<=\\W))TODO(\\b|\\W).*";
    public static final String DEFAULT_PROBLEM_TAG_PATTERN = "(?i)(^|(?<=\\W))(FIXME|HACK)(\\b|\\W).*";
    public static final String TASK_TAG_PATTERN = "task-tag.pattern";
    public static final String TASK_TAG_EXCLUSION_PATTERN = "task-tag.exclusion-pattern";
    public static final String PROBLEM_TAG_PATTERN = "problem-tag.pattern";
    public static final String PROBLEM_TAG_EXCLUSION_PATTERN = "problem-tag.exclusion-pattern";
    public static final String TASK_TAG_ANALYSIS_ENABLED = "task-tags-search.enabled";
    public static final String PROBLEM_TAG_ANALYSIS_ENABLED = "problem-tags-search.enabled";
    public static final String COMMENT_COMPLETENESS_ANALYSIS_ENABLED = "comment-completeness-analysis.enabled";
    public static final String COMMENT_RATIO_METRIC_ENABLED = "comment-ratio-metric.enabled";
    public static final String COMMENT_TYPE_METRICS_ENABLED = "comment-type-metrics.enabled";
    public static final String COMMENT_CLASSIFICATION_ENABLED = "comment-classification.enabled";
    public static final String DOC_COMMENT_REQUIRED = "comment-completeness.doc-comment";
    public static final String ENTITY_SELECTION_EXPRESSION = "comment-completeness.selector";
    public static final String ALLOW_COMMENTS_INSIDE = "comment-inside.allow";
    public static final String COMMENT_COMPLETENESS_ASSESSMENT_ENABLED = "comment-completeness-assessment.enabled";
    public static final String COMMENT_COMPLETENESS_ASSESSMENT_FOR_TYPES_ENABLED = "comment-completeness-assessment-for-types.enabled";
    public static final String COMMENT_COMPLETENESS_ASSESSMENT_FOR_METHODS_ENABLED = "comment-completeness-assessment-for-methods.enabled";
    public static final String COMMENT_COMPLETENESS_ASSESSMENT_FOR_ATTRIBUTES_ENABLED = "comment-completeness-assessment-for-attributes.enabled";
    public static final String TASK_PROBLEM_TAG_COMBINE_ADJACENT_LINE_COMMENTS_PARAMETER_NAME = "task-problem-tag.combine-adjacent-line-comments";
    @StepParameter(value="task-tag.pattern", optional=true)
    private CodeScopeAware<String> taskTagPattern = CodeScopeAware.defaultCodeScopeWithValue((Object)"");
    @StepParameter(value="task-tag.exclusion-pattern", optional=true)
    private CodeScopeAware<String> taskTagExclusionPattern = CodeScopeAware.defaultCodeScopeWithValue((Object)"");
    @StepParameter(value="problem-tag.pattern", optional=true)
    private CodeScopeAware<String> problemTagPattern = CodeScopeAware.defaultCodeScopeWithValue((Object)"");
    @StepParameter(value="problem-tag.exclusion-pattern", optional=true)
    private CodeScopeAware<String> problemTagExclusionPattern = CodeScopeAware.defaultCodeScopeWithValue((Object)"");
    @StepParameter(value="task-problem-tag.combine-adjacent-line-comments", optional=true)
    private CodeScopeAware<Boolean> combineAdjacentLineComments = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="task-tags-search.enabled", optional=true)
    private CodeScopeAware<Boolean> taskTagAnalysisEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="problem-tags-search.enabled", optional=true)
    private CodeScopeAware<Boolean> problemTagAnalysisEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="comment-completeness-analysis.enabled", optional=true)
    private CodeScopeAware<Boolean> commentCompletenessAnalysisEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="comment-ratio-metric.enabled", optional=true)
    private CodeScopeAware<Boolean> commentRatioMetricsEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="comment-type-metrics.enabled", optional=true)
    private CodeScopeAware<Boolean> commentTypeMetricsEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="comment-classification.enabled", optional=true)
    private CodeScopeAware<Boolean> commentClassificationEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="comment-completeness.doc-comment")
    private CodeScopeAware<Boolean> requireDocComment;
    @StepParameter(value="comment-completeness.selector")
    private CodeScopeAware<String> entitySelectionExpression;
    @StepParameter(value="comment-inside.allow", optional=true)
    private CodeScopeAware<Boolean> allowCommentInside = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="comment-completeness-assessment.enabled")
    private CodeScopeAware<Boolean> commentCompletenessAssessmentEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="comment-completeness-assessment-for-types.enabled")
    private CodeScopeAware<Boolean> commentCompletenessAssessmentForTypesEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="comment-completeness-assessment-for-methods.enabled")
    private CodeScopeAware<Boolean> commentCompletenessAssessmentForMethodsEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @StepParameter(value="comment-completeness-assessment-for-attributes.enabled")
    private CodeScopeAware<Boolean> commentCompletenessAssessmentForAttributesEnabled = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @IndexAccess.Named(mode=EIndexAccessMode.READ_WRITE, name="metrics")
    private MetricsIndex metricsIndex;
    private MetricsIndexSynchronizer metricsIndexSynchronizer;
    private final CodeScopeAware<ListMap<String, IndexFinding>> findings = CodeScopeAware.empty();
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws StorageException {
        this.metricsIndexSynchronizer = new MetricsIndexSynchronizer(this.metricsIndex, this.contentDelta);
        try {
            List<TokenElementInfo> tokenElements = this.getContentIndexCache().getValues(this.contentDelta.getAddedOrChangedKeysAsStrings());
            CodeScopeAware<List<TokenElementInfo>> elementsPerCodeScope = CodeScopeUtils.groupElementsByCodeScope(tokenElements);
            CommentClassificationCache classificationCache = new CommentClassificationCache();
            for (CodeScopeName codeScopeName : elementsPerCodeScope.getCodeScopeNames()) {
                this.findings.setValue(codeScopeName, (Object)new ListMap());
                if (((Boolean)this.taskTagAnalysisEnabled.getValueWithDefault(codeScopeName)).booleanValue()) {
                    this.performTaskTagAnalysis((List)elementsPerCodeScope.getValue(codeScopeName), codeScopeName);
                }
                if (((Boolean)this.problemTagAnalysisEnabled.getValueWithDefault(codeScopeName)).booleanValue()) {
                    this.performProblemTagAnalysis((List)elementsPerCodeScope.getValue(codeScopeName), codeScopeName);
                }
                if (((Boolean)this.commentClassificationEnabled.getValueWithDefault(codeScopeName)).booleanValue()) {
                    this.performCommentClassificationAnalyses((List)elementsPerCodeScope.getValue(codeScopeName), classificationCache, codeScopeName);
                }
                if (((Boolean)this.commentCompletenessAnalysisEnabled.getValueWithDefault(codeScopeName)).booleanValue()) {
                    this.performCommentCompletenessAnalysis((List)elementsPerCodeScope.getValue(codeScopeName), codeScopeName);
                }
                if (!((Boolean)this.commentTypeMetricsEnabled.getValueWithDefault(codeScopeName)).booleanValue() && !((Boolean)this.commentRatioMetricsEnabled.getValueWithDefault(codeScopeName)).booleanValue()) continue;
                this.performCommentMetricAnalysis((List)elementsPerCodeScope.getValue(codeScopeName), classificationCache, (Boolean)this.commentTypeMetricsEnabled.getValueWithDefault(codeScopeName), (Boolean)this.commentRatioMetricsEnabled.getValueWithDefault(codeScopeName));
            }
            this.determinePartitionsForDeletedKeys();
            this.metricsIndexSynchronizer.synchronize();
            this.synchronizeFindingsForTokenElementIndexDelta(this.findings, "comment-findings");
        }
        catch (ConQATException e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
    }

    private void determinePartitionsForDeletedKeys() throws StorageException {
        CommentMetricAnalysis commentMetricAnalysis;
        if (this.contentDelta.getDeletedKeys().isEmpty()) {
            return;
        }
        if (this.commentCompletenessAnalysisEnabled.getValues().contains(Boolean.TRUE)) {
            List<String> partitions = CommentCompletenessAssessor.getPartitions();
            partitions.forEach(arg_0 -> ((MetricsIndexSynchronizer)this.metricsIndexSynchronizer).addEmptyPartitionIfAbsent(arg_0));
        }
        if (this.commentTypeMetricsEnabled.getValues().contains(Boolean.TRUE)) {
            commentMetricAnalysis = new CommentMetricAnalysis(true, false);
            commentMetricAnalysis.getPartitions().forEach(arg_0 -> ((MetricsIndexSynchronizer)this.metricsIndexSynchronizer).addEmptyPartitionIfAbsent(arg_0));
        }
        if (this.commentRatioMetricsEnabled.getValues().contains(Boolean.TRUE)) {
            commentMetricAnalysis = new CommentMetricAnalysis(false, true);
            commentMetricAnalysis.getPartitions().forEach(arg_0 -> ((MetricsIndexSynchronizer)this.metricsIndexSynchronizer).addEmptyPartitionIfAbsent(arg_0));
        }
    }

    private void performCommentMetricAnalysis(List<TokenElementInfo> tokenElements, CommentClassificationCache classificationCache, boolean commentTypeMetricsEnabled, boolean commentRatioMetricEnabled) throws StorageException {
        CommentMetricAnalysis commentMetricAnalysis = new CommentMetricAnalysis(commentTypeMetricsEnabled, commentRatioMetricEnabled);
        commentMetricAnalysis.performAnalysis(tokenElements, classificationCache);
        commentMetricAnalysis.getMetricValues().forEach((arg_0, arg_1) -> ((MetricsIndexSynchronizer)this.metricsIndexSynchronizer).addPartition(arg_0, arg_1));
    }

    private void performCommentCompletenessAnalysis(List<TokenElementInfo> tokenElements, CodeScopeName codeScopeName) throws ConQATException {
        CommentCompletenessFindingsAnalyzer completenessAnalyzer = new CommentCompletenessFindingsAnalyzer((Boolean)this.requireDocComment.getValue(codeScopeName), (String)this.entitySelectionExpression.getValue(codeScopeName), (Boolean)this.allowCommentInside.getValueWithDefault(codeScopeName));
        completenessAnalyzer.performAnalysis(tokenElements);
        ((ListMap)this.findings.getValue(codeScopeName)).addAll(completenessAnalyzer.getFindings());
        CommentCompletenessAssessor commentCompletenessAssessor = new CommentCompletenessAssessor((Boolean)this.requireDocComment.getValue(codeScopeName), (String)this.entitySelectionExpression.getValue(codeScopeName), (Boolean)this.allowCommentInside.getValueWithDefault(codeScopeName), (Boolean)this.commentCompletenessAssessmentEnabled.getValue(codeScopeName), (Boolean)this.commentCompletenessAssessmentForTypesEnabled.getValue(codeScopeName), (Boolean)this.commentCompletenessAssessmentForMethodsEnabled.getValue(codeScopeName), (Boolean)this.commentCompletenessAssessmentForAttributesEnabled.getValue(codeScopeName));
        commentCompletenessAssessor.performAnalysis(tokenElements);
        Map<String, Map<String, Assessment>> assessmentsByPartition = commentCompletenessAssessor.getAssessments();
        for (Map.Entry<String, Map<String, Assessment>> entry : assessmentsByPartition.entrySet()) {
            String partition = entry.getKey();
            Map<String, Assessment> assessments = entry.getValue();
            PairList values = new PairList(assessments.size());
            assessments.forEach((arg_0, arg_1) -> ((PairList)values).add(arg_0, arg_1));
            this.metricsIndexSynchronizer.addPartition(partition, values);
        }
    }

    private void performCommentClassificationAnalyses(List<TokenElementInfo> tokenElements, CommentClassificationCache classificationCache, CodeScopeName codeScopeName) {
        List filteredTokenElements = CollectionUtils.filter(tokenElements, element -> CommentClassificationAnalysisBase.isSupportedLanguage(element.getLanguage()));
        UnrelatedInterfaceCommentAnalysis unrelatedInterfaceCommentAnalysis = new UnrelatedInterfaceCommentAnalysis();
        unrelatedInterfaceCommentAnalysis.performAnalysis(filteredTokenElements, classificationCache);
        ((ListMap)this.findings.getValue(codeScopeName)).addAll(unrelatedInterfaceCommentAnalysis.getFindings());
        TrivialInterfaceCommentAnalysis trivialInterfaceCommentAnalysis = new TrivialInterfaceCommentAnalysis();
        trivialInterfaceCommentAnalysis.performAnalysis(filteredTokenElements, classificationCache);
        ((ListMap)this.findings.getValue(codeScopeName)).addAll(trivialInterfaceCommentAnalysis.getFindings());
        ShortInlineCommentAnalysis shortInlineCommentAnalysis = new ShortInlineCommentAnalysis();
        shortInlineCommentAnalysis.performAnalysis(filteredTokenElements, classificationCache);
        ((ListMap)this.findings.getValue(codeScopeName)).addAll(shortInlineCommentAnalysis.getFindings());
        LongInlineCommentAnalysis longInlineCommentAnalysis = new LongInlineCommentAnalysis();
        longInlineCommentAnalysis.performAnalysis(filteredTokenElements, classificationCache);
        ((ListMap)this.findings.getValue(codeScopeName)).addAll(longInlineCommentAnalysis.getFindings());
        EmptyInterfaceCommentAnalysis emptyInterfaceCommentAnalysis = new EmptyInterfaceCommentAnalysis();
        emptyInterfaceCommentAnalysis.performAnalysis(filteredTokenElements, classificationCache);
        ((ListMap)this.findings.getValue(codeScopeName)).addAll(emptyInterfaceCommentAnalysis.getFindings());
        ExclamationQuestionMarkAnalysis exclamationQuestionMarkAnalysis = new ExclamationQuestionMarkAnalysis();
        exclamationQuestionMarkAnalysis.performAnalysis(filteredTokenElements, classificationCache);
        ((ListMap)this.findings.getValue(codeScopeName)).addAll(exclamationQuestionMarkAnalysis.getFindings());
        CommentedOutCodeAnalysis commentedOutCodeAnalysis = new CommentedOutCodeAnalysis();
        commentedOutCodeAnalysis.performAnalysis(filteredTokenElements, classificationCache);
        ((ListMap)this.findings.getValue(codeScopeName)).addAll(commentedOutCodeAnalysis.getFindings());
    }

    private void performTaskTagAnalysis(List<TokenElementInfo> tokenElements, CodeScopeName codeScopeName) {
        String pattern = DEFAULT_TASK_TAG_PATTERN;
        if (!StringUtils.isEmpty((String)((String)this.taskTagPattern.getValueWithDefault(codeScopeName)))) {
            pattern = (String)this.taskTagPattern.getValueWithDefault(codeScopeName);
        }
        this.performTagAnalysis(tokenElements, codeScopeName, pattern, (String)this.taskTagExclusionPattern.getValueWithDefault(codeScopeName), TASK_TAGS_FINDING_GROUP);
    }

    private void performProblemTagAnalysis(List<TokenElementInfo> tokenElements, CodeScopeName codeScopeName) {
        String pattern = DEFAULT_PROBLEM_TAG_PATTERN;
        if (!StringUtils.isEmpty((String)((String)this.problemTagPattern.getValueWithDefault(codeScopeName)))) {
            pattern = (String)this.problemTagPattern.getValueWithDefault(codeScopeName);
        }
        this.performTagAnalysis(tokenElements, codeScopeName, pattern, (String)this.problemTagExclusionPattern.getValueWithDefault(codeScopeName), PROBLEM_TAGS_FINDING_GROUP);
    }

    private void performTagAnalysis(List<TokenElementInfo> tokenElements, CodeScopeName codeScopeName, String pattern, String exclusionPattern, String findingGroup) {
        PatternList exclusionPatterns = new PatternList();
        if (!StringUtils.isEmpty((String)exclusionPattern)) {
            exclusionPatterns.add((Object)Pattern.compile(exclusionPattern));
        }
        SourceCodeSearchFindingAnalyzer searchFindingAnalyzer = new SourceCodeSearchFindingAnalyzer(this.getTokenPreprocessorFactory(codeScopeName), new PatternList(new Pattern[]{Pattern.compile(pattern)}), exclusionPatterns, findingGroup, COMMENTS_FINDING_CATEGORY, null);
        searchFindingAnalyzer.addTokenClass(ETokenType.ETokenClass.COMMENT);
        searchFindingAnalyzer.process(tokenElements);
        ((ListMap)this.findings.getValue(codeScopeName)).addAll(searchFindingAnalyzer.getFindings());
    }

    private Function<TokenElementInfo, IPreprocessor> getTokenPreprocessorFactory(CodeScopeName codeScopeName) {
        if (((Boolean)this.combineAdjacentLineComments.getValueWithDefault(codeScopeName)).booleanValue()) {
            return tokenElementInfo -> new SourceCodeSearchFindingAnalyzer.MultilineTokenCombiner((TokenElementInfo)((Object)tokenElementInfo), (Set<ETokenType>)EnumSet.of(ETokenType.END_OF_LINE_COMMENT, ETokenType.LINE_COMMENT));
        }
        return ignored -> IPreprocessor.identity();
    }
}

