/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis.identifier;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompoundBreaker {
    private static final Pattern WORD_SEPARATION_PATTERN = Pattern.compile("\\P{Alnum}+");
    private static final Pattern LOWER_UPPER_PATTERN = Pattern.compile("(\\P{Lu})(\\p{Lu})");
    private static final Pattern ACRONYM = Pattern.compile("(\\p{Lu}+)(\\p{Lu}[\\P{Lu}&&[^_]])");
    private static final Pattern END_DIGITS_PATTERN = Pattern.compile("\\d+$");
    private static final String UNDERSCORE = "_";

    public static List<String> breakCompound(String compound) {
        return CompoundBreaker.breakCompound(compound, true);
    }

    public static List<String> breakCompound(String compound, boolean discardShortParts) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = WORD_SEPARATION_PATTERN.matcher(compound);
        compound = matcher.replaceAll(UNDERSCORE);
        matcher = LOWER_UPPER_PATTERN.matcher(compound);
        compound = matcher.replaceAll("$1_$2");
        matcher = ACRONYM.matcher(compound);
        compound = matcher.replaceAll("$1_$2");
        for (String part : compound.split(UNDERSCORE)) {
            part = part.toLowerCase();
            matcher = END_DIGITS_PATTERN.matcher(part);
            part = matcher.replaceFirst("");
            if (discardShortParts && part.length() < 2) continue;
            result.add(part);
        }
        return result;
    }
}

